


-- Zuschnitte

    -- Alte Version, ohne Umrechnungsfaktor aus Mengeneinheiten
    CREATE OR REPLACE FUNCTION tartikel.zuschnittmenge(x NUMERIC, y NUMERIC, z NUMERIC, zz NUMERIC, stkz INTEGER) RETURNS NUMERIC(12,4) AS $$
      BEGIN
        zz := COALESCE(zz, 0);
        IF COALESCE(z, 0)>0 THEN--volumenberechnung
            RETURN (x+zz)*(y+zz)*(z+zz)*stkz;
        ELSIF COALESCE(y, 0)>0 THEN--Flächenberechnung
            RETURN (x+zz)*(y+zz)*stkz;
        ELSIF COALESCE(x, 0)>0 THEN--Längenberechnung
            RETURN (x+zz)*stkz;
        END IF;
      END $$ LANGUAGE plpgsql;
    --

    -- Mit Umrechnungsfaktor aus Mengeneinheiten, Umrechnungsfaktor wird von TArtikel.getMEuf ermittelt.
    CREATE OR REPLACE FUNCTION tartikel.zuschnittmenge(x NUMERIC, y NUMERIC, z NUMERIC, zz NUMERIC, stkz INTEGER, me_koef NUMERIC) RETURNS NUMERIC(12,4) AS $$
      BEGIN
        zz := COALESCE(zz, 0);
        IF COALESCE(z, 0)>0 THEN --Volumenberechnung
            RETURN (x+zz) * (y+zz) * (z+zz) * stkz * me_koef * me_koef * me_koef;
        ELSIF COALESCE(y, 0)>0 THEN --Flächenberechnung
            RETURN (x+zz) * (y+zz) * stkz * me_koef * me_koef;
        ELSIF COALESCE(x, 0)>0 THEN --Längenberechnung
            RETURN (x+zz) * stkz * me_koef;
        END IF;
      END $$ LANGUAGE plpgsql;
    --

    -- Mit Umrechnungsfaktor aus Mengeneinheiten, Umrechnungsfaktor wird von TArtikel.getMEuf ermittelt - me_koeff schließt hier bereits die Dimension ein.
    CREATE OR REPLACE FUNCTION tartikel.zuschnittmenge__dim__in__me_koef(
      x numeric,
      y numeric,
      z numeric,
      zz numeric,
      stkz integer,
      me_koef numeric
    ) RETURNS NUMERIC(12,4) AS $$
      BEGIN
        zz := coalesce( zz, 0 );
        RETURN ( x + zz ) * coalesce( y + zz, 1 ) * coalesce( z + zz, 1 ) * stkz * me_koef;
      END $$ LANGUAGE plpgsql;
    --
--

--Mengeneinheitsumrechnungsfaktor
CREATE OR REPLACE FUNCTION TArtikel.me__art__artmgc__m_ids__uf(me1 INTEGER, me2 INTEGER) RETURNS NUMERIC AS $$
    DECLARE richtung BOOLEAN;
           uf   NUMERIC;
           dim1 NUMERIC;
           dim2 NUMERIC;
    BEGIN
        IF me1=me2 THEN RETURN 1;
        END IF;

        SELECT COALESCE(me_dim1, me1), COALESCE(me_dimnum, 1) FROM mgcode WHERE me_cod = me1  INTO me1, dim1;
        SELECT COALESCE(me_dim1, me2), COALESCE(me_dimnum, 1) FROM mgcode WHERE me_cod = me2  INTO me2, dim2;

        -- Fehlermeldung wenn in unterschiedliche Dimensionen umgerechnet werden soll
        IF dim1 <> dim2 AND dim1 <> 1 AND dim1 <> 1 THEN
            RAISE EXCEPTION '%', Format('Fehler(TArtikel.me__art__artmgc__m_ids__uf): ' || lang_text(35230) /*Mengeneinheiten mit Unterschiedlichen Dimensionen können nicht ineinander umgerechnet werden: ME1=[Code:%, Bez: %, Dim:%], ME2=[Code:%, Bez: %, Dim:%] */
                ,me1, tartikel.me_mgcode_iso(me1), dim1, me2, tartikel.me_mgcode_iso(me2), dim2);
        END IF;

        SELECT
          power( mc_uf, dim1 ),
          (SELECT true FROM meconvert WHERE (mc_cod1=mgcode1.me_cod AND mc_cod2=mgcode2.me_cod))
        FROM meconvert
          LEFT JOIN mgcode mgcode1 ON mgcode1.me_cod=me1
          LEFT JOIN mgcode mgcode2 ON mgcode2.me_cod=me2
        WHERE (mc_cod1=mgcode1.me_cod AND mc_cod2=mgcode2.me_cod) OR (mc_cod1=mgcode2.me_cod AND mc_cod2=mgcode1.me_cod)
        INTO uf, richtung;
        -- wenn Umrechnungsfaktor in me_convert nicht gefunden
        IF uf IS NULL THEN
            RAISE EXCEPTION '%', Format('Fehler(TArtikel.me__art__artmgc__m_ids__uf): ' || lang_text(29145) /*Umrechnungsfaktor wurde nicht gefunden: ME1=[Code:%, Bez: %], ME2=[Code:%, Bez: %]' */
                ,me1, tartikel.me_mgcode_iso(me1), me2, tartikel.me_mgcode_iso(me2));
        ELSE
            IF richtung THEN
                IF uf=0 THEN
                    RAISE EXCEPTION '%', Format('Fehler(TArtikel.me__art__artmgc__m_ids__uf): ' || lang_text(29144) /*Umrechnungsfaktor darf nicht 0 sein. ME1=[Code:%, Bez: %], ME2=[Code:%, Bez: %]' */
                        ,me1, tartikel.me_mgcode_iso(me1), me2, tartikel.me_mgcode_iso(me2));
                END IF;
                RETURN 1/uf;
            ELSE
                RETURN uf;
            END IF;
        END IF;
        RETURN NULL;
    END $$ LANGUAGE plpgsql STABLE;
--

-- Mengeneinheitsumrechnungsfunktion, Val: Menge, me1: gegebene ME, me2: benötigte ME
CREATE OR REPLACE FUNCTION TArtikel.me__convert__menge__from_to__me(val NUMERIC, me1 VARCHAR, me2 VARCHAR) RETURNS NUMERIC AS $$
    BEGIN
      RETURN val * TArtikel.me__art__artmgc__m_ids__uf((SELECT me_cod FROM mgcode WHERE me_iso=me1), (SELECT me_cod FROM mgcode WHERE me_iso=me2));
    END $$ LANGUAGE plpgsql STABLE;
--

/*Versucht für den Zielartikel die ME zu finden, die als otherME angegeben wurde. Beispiel:
  Artikel = Stange1,
  OtherME = m_id der Mengeneinheit 'Meter' eines anderen Artikels
  Im Zielartikel 'Stange1' wird nach der Mengeneinheit Meter suchen und deren m_id zurückgeben
    wenn FallbackStandardME = True, wird Mengen-ID der standardmengeneinheit zurückgegeben, damit
    immer eine Rückgabe erfolgt. Andernfalls muss kann NULL zurückgegeben werden, was abgefangen werden muss.
 */
CREATE OR REPLACE FUNCTION TArtikel.me__convertme_for_art__by__mid(IN targetAknr VARCHAR(40), IN otherME INTEGER, IN FallBackStandardME BOOLEAN = FALSE ) RETURNS INTEGER AS $$
    DECLARE thisME INTEGER;
    BEGIN
      -- ArtMgcID vom gesuchten Artikel nehmen, auch wenn im Rahmen der Austauschartikel steht
      SELECT this.m_id INTO thisME
        FROM artmgc AS other
        JOIN artmgc AS this ON (other.m_mgcode = this.m_mgcode) AND (this.m_ak_nr   = targetAknr)
       WHERE (other.m_id = otherME)
       ORDER BY this.m_id LIMIT 1;

      IF ( (thisME IS NULL) AND FallBackStandardME) THEN
        thisME :=  tartikel.me__art__artmgc__m_id__by__ak_standard_mgc(targetAknr);
      END IF;

      RETURN thisME;
    END $$ LANGUAGE plpgsql STABLE;
--

/* Versucht für eine Mengeneinheit den Umrechnungsfaktor in eine globale Grundmengeneinheit zu finden
   Vorgehen:
   1. Anhand der Mengen-ID wir in den Mengeneinheiten des Artikels nach einer passenden Mengeneinheit mit Dimensionsangabe gesucht
   2. Falls die gewünschte Mengeneinheit keine Mengeneinheit des Artikels ist, dann wird diese per Mengenkonvertierung umgerechnet
*/
CREATE OR REPLACE FUNCTION TArtikel.mid__menge__in__mgc__menge(
      INOUT _menge      numeric,  -- Eingang: umzurechnende Menge
      IN    _mid_in     integer,  -- Eingang: umzurechnende m_id aus Artikel-Mengeneinheiten
      IN    _me_iso_out varchar   -- Ausgang: Mengeneinheit aus globaler Grundmengeneinheit
    )
    RETURNS numeric
    AS $$
    DECLARE
      _uf  numeric;
      _iso varchar;
    BEGIN
    -- 1. Umrechnungsfaktor zu einer gegebenen Mengeneinheit mit Dimensionsangabe finden
    -- Es wird in den Artikel-Mengeneinheiten nach der gewünschten Mengeneinheit gesucht
      SELECT b.m_uf / a.m_uf                                   -- erst in GME umrechnen und anschließend in gesuchte ME
          , mgc.me_iso
        INTO _uf
          , _iso
        FROM artmgc a
      INNER JOIN artmgc b    ON   a.m_ak_nr  =    b.m_ak_nr  -- Alle Mengeneinheiten zum Artikel finden
            JOIN mgcode mgc  ON   b.m_mgcode =  mgc.me_cod
      INNER JOIN mgcode dim1 ON mgc.me_dim1  = dim1.me_cod   -- Grunddimensionseinheit (Dim1) auslösen
            JOIN art         ON   a.m_ak_nr  =  art.ak_nr
      WHERE a.m_id = _mid_in
        AND mgc.me_dimnum = ak_lagdim  -- Restmengendimension im Artikelstamm passt zur Dimension des hinterlegten Umrechnungsfaktor
      ORDER BY dim1.me_iso = 'mm',     -- Umrechnung anhand Grunddimensionseinheit nach folgender Priorität: 1. 'mm', 2. 'm', 3. <Rest>
                dim1.me_iso = 'm'
      LIMIT 1;

      IF _uf IS null THEN
        RAISE NOTICE '%', Format('Fehler(TArtikel.mid__menge__in__mgc__menge): ' || lang_text(35231)  /* Für den Artikel existiert keine Mengeneinheit mit derselben Anzahl
                                                                                                          an Dimensionen entsprechend der hinterlegten Restmengendimension:
                                                                                                          ME-Code: %s, Art: %s, Restmengendimension: %s  */
                  , _mid_in
                  , ( SELECT m_ak_nr FROM artmgc WHERE m_id = _mid_in )
                  , ( SELECT ak_lagdim FROM art JOIN artmgc ON m_ak_nr = ak_nr WHERE m_id = _mid_in )
                  );
      END IF;

      _menge := _menge * _uf;

    -- 2. Prüfung ob die umgerechnete Mengeneinheit bereits der gewünschten Mengeneinheit entspricht
    --    falls nicht -> Mengenkonvertierung nutzen
      IF _iso <> _me_iso_out THEN
        _menge := TArtikel.me__convert__menge__from_to__me(_menge, _iso, _me_iso_out);
      END IF;

    END $$ LANGUAGE plpgsql STABLE;

-- moved to b art.sql
-- -- Mengencode zur Mengen-ID
-- CREATE OR REPLACE FUNCTION TArtikel.me__mec__by__mid(mid INTEGER) RETURNS INTEGER AS $$
--   SELECT m_mgcode FROM artmgc WHERE m_id = mid;
--   $$ LANGUAGE sql STABLE STRICT;
-- --

-- Prüfung ob m_ids für einen Artikel gültig sind
CREATE OR REPLACE FUNCTION TArtikel.me__art__artmgc__m_ids__valid(IN aknr VARCHAR(40),VARIADIC artmgcids INTEGER[] ) RETURNS BOOLEAN AS $$
  DECLARE mid INTEGER;
  BEGIN
    -- keine Mengeneinheit übergeben. Dann gibt es keine Prüfung! zB PreisMengeneinheit, diese ist nicht zwingend erforderlich!
    -- #20487 Nullabfrage für fehlende Mengeneinheit verbessert
    --  '{null}' ist notwendig, da die Funktion als Variadic auch mit null aufgerufen wird (zB bei Anfrage wo ein freier Artikel möglich ist). Es wird dann Null als Element übergeben somit ist der Array artmgcids nicht Null sondern enthält ein Element "null"
    IF artmgcids IS null OR artmgcids = '{null}' THEN
      RETURN null;
    END IF;

    IF current_user = 'postgres' THEN -- Trigger-Reihenfolgeprobleme bei Artikelaustausch abfangen (CONSTRAINT- vs. USER-Level-Trigger), siehe #8118
        RETURN true;
    END IF;

    FOR mid IN SELECT UnNest(artmgcids) LOOP
        IF NOT EXISTS (SELECT true FROM artmgc WHERE m_id = mid AND m_ak_nr = aknr) THEN
            RETURN false;
        END IF;
    END LOOP;

    RETURN true;
 END $$ LANGUAGE plpgsql STABLE;
--

-- Entgegen der Bezeichnung wird nicht auf ak_lag geprüft
CREATE OR REPLACE FUNCTION TArtikel.art__ac_i__is__50(IN aknr VARCHAR(40)) RETURNS BOOLEAN AS $$
 DECLARE rec RECORD;
 BEGIN
  SELECT ac_i INTO  rec
  FROM   art JOIN artcod ON ak_ac=ac_n
  WHERE  ak_nr = aknr;

  IF (rec.ac_i = 50) THEN
    RETURN FALSE;
  ELSE
    RETURN TRUE;
  END IF;

 END $$ LANGUAGE plpgsql STABLE RETURNS NULL ON NULL INPUT;
--

--
CREATE OR REPLACE FUNCTION TArtikel.art__lag__lg_anztot__get__lg_sperr(
      _aknr varchar
  ) RETURNS numeric AS $$
    -- Anzahl auf Sperrlagerorten
    -- http://redmine.prodat-sql.de/projects/prodat-v-x/wiki/Art


    SELECT
      sum( lg_anztot )
    FROM lag
    WHERE lg_aknr = _aknr
      AND lg_sperr
    ;

  $$ LANGUAGE sql STABLE STRICT;
--

--
CREATE OR REPLACE FUNCTION TArtikel.art__lag__lg_anztot__get__nverfueg(
      _aknr varchar
  ) RETURNS numeric AS $$
    -- Anzahl auf Lagerorten ohne Verfügbarkeit bzw. Sperrlager ohne Standardlagerort (sind per Default nicht verfügbar)
    -- http://redmine.prodat-sql.de/projects/prodat-v-x/wiki/Art


    SELECT
      sum( lg_anztot )
    FROM lag
    WHERE lg_aknr = _aknr
      AND coalesce(
              -- per Standardlagerort-Konfiguration nicht verfügbar.
              -- Speerkennzeichen am Lagerort wird überdeckt.
              NOT ( lagerorte__get_setup( lg_ort ) )._verfgbar,
              -- Ohne Standardlagerort-Konfiguration gilt gesperrt als nicht verfügbar.
              lg_sperr,
              -- default verfügbar ohne Standardlagerort-Konfiguration oder Sperrkennzeichen (null)
              false
          )
    ;

  $$ LANGUAGE sql STABLE STRICT;
--

--
CREATE OR REPLACE FUNCTION TArtikel.art__lag__lg_anztot__get__lg_sperr__nverfueg(
      _aknr varchar
  ) RETURNS numeric AS $$
    -- Anzahl auf Sperrlagerorten oder ohne Verfügbarkeit
    -- http://redmine.prodat-sql.de/projects/prodat-v-x/wiki/Art


    SELECT
      sum( lg_anztot )
    FROM lag
    WHERE lg_aknr = _aknr
      AND (
          -- Sperrlager (ohne Kennzeichnung default nicht gesperrt)
              coalesce( lg_sperr, false )
          -- oder per Standardlagerort-Konfiguration nicht verfügbar (ohne Konfig. default verfügbar)
          OR  coalesce( NOT (lagerorte__get_setup( lg_ort ))._verfgbar, false )
      )
    ;

  $$ LANGUAGE sql STABLE STRICT;
--

-- Anzahl der Artikel, die in Nacharbeits- oder Serviceprozessen unterwegs sind
-- http://redmine.prodat-sql.de/projects/prodat-v-x/wiki/Art
CREATE OR REPLACE FUNCTION TArtikel.art__qab__q_stk_fehlerhaft__get__service(
      _aknr varchar
  )
  RETURNS numeric
  AS $$

      SELECT sum( q_stk_fehlerhaft )
        FROM qab
       WHERE NOT ( q_isservice OR q_def )
         AND q_ak_nr = _aknr

  $$ LANGUAGE sql STABLE STRICT;
--
CREATE OR REPLACE FUNCTION TArtikel.art__qab__last__get(
      _aknr varchar,

      OUT q_nr  integer,
      OUT q_dat date,
      OUT txt   varchar
  )
  RETURNS record
  AS $$

      SELECT q_nr,
             q_dat,
             q_nr || coalesce('  ' || q_dat::varchar, '') AS txt
        FROM qab
       WHERE NOT q_isservice
         AND q_ak_nr = _aknr
         AND q_def
       ORDER BY q_dat DESC
       LIMIT 1

  $$ LANGUAGE sql STABLE STRICT;

--

CREATE OR REPLACE FUNCTION TArtikel.art__auftgr__ag_stk__get(
      _aknr varchar
  )
  RETURNS numeric
  AS $$

      SELECT sum( tauftg.auftgr__rahmen_info__stko_offen__by__ag_id__get( ag_id ) )
        FROM auftg
       WHERE ag_aknr = _aknr
         AND NOT ag_done
         AND ( ag_astat = 'R' OR ag_pos = 0 )

  $$ LANGUAGE sql STABLE STRICT;
--

CREATE OR REPLACE FUNCTION TArtikel.art__ldsdokr__ld_stk__get(
    _aknr varchar
  )
  RETURNS numeric
  AS $$

      SELECT sum( ( rahmen_stk_ldsdok_offen( ld_auftg || '/' || ld_pos ) ).stko )
        FROM ldsdok
       WHERE ld_aknr = _aknr
         AND NOT ld_done
         AND ( ld_code = 'R' OR ld_pos = 0 )

  $$ LANGUAGE sql STABLE STRICT;

--
/* Lieferfähigkeit eines externen Auftrags
  Einschränkung nach bestimmten Lagerorten möglich (LIKE)
  lieferbare Menge (je nach Lagerort und vorrigen Aufträge)
  in_agstat: standard "E" ansonsten "%" für E und I oder halt I
 */
CREATE OR REPLACE FUNCTION TArtikel.art__auftg__lieferbar_menge(
  IN in_agid   integer,
  IN in_lgort  varchar DEFAULT NULL,
  IN in_agstat varchar DEFAULT NULL
  )
  RETURNS numeric(12,4)
  AS $$
  DECLARE aknr       varchar;
          sum_lag    numeric;
          auftg_rec  record;
          no_neg_lag boolean;
          _status    varchar;
  BEGIN
    SELECT coalesce(in_agstat, ag_astat), ag_aknr  -- wenn der eingegangene Status leer ist, nehmen wir per Default den Status des Auftrags als Filter. Möchte ich gezielt nur E oder nur I, muss das explizit angegeben werden
      INTO _status, aknr
      FROM auftg
     WHERE NOT ag_done
       AND ag_astat LIKE coalesce(in_agstat, '%')
       AND ag_astat NOT IN ('A', 'R')
       AND ag_pos > 0
       AND ag_id = in_agid
       AND NOT ag_nstatistik; -- Artikel aus Auftragspos.

    -- Die bestimmte Auftragsposition gibts nicht, ist nicht extern, ist Rahmen oder schon geschlossen
    IF aknr IS NULL THEN
        RETURN NULL;
    END IF;

    -- Bei I per Default auch immer E. Möchte ich nur I, dann muss auch explizit I angegeben werden
    -- das ist andersrum als bei E. Dort ist per Default NUR E, da ich nur sehen möchte was ich direkt verkaufen könnte OHNE I.
    IF in_agstat IS NULL AND _status = 'I' THEN
      _status := '%';
    END IF;

    no_neg_lag := TSystem.Settings__GetBool('no_neg_lag');

    -- verfügbare Lagermenge des Artikels
    sum_lag := sum(lg_anztot)
               FROM lag LEFT JOIN LATERAL lagerorte__get_setup(lg_ort) ON true
               WHERE lg_aknr = aknr
                 AND lg_ort LIKE coalesce(in_lgort, lg_ort)         -- bestimmte Lagerort, wenn angg.
                 AND CASE WHEN no_neg_lag THEN (lg_anztot > 0 OR lg_ort = 'MINUS') ELSE true END -- vgl. bestand_abgleich_intern
                 AND coalesce(_verfgbar, NOT lg_sperr, true)        -- vgl. TArtikel.art__lag__lg_anztot__get__nverfueg
               ;

    -- Aufträge nach Priorität durchgehen und Lagermenge aufteilen
    -- Priorität: Ausliefertermin bzw. Kundenwunschtermin, ansonsten nach Auftragsnummer, Position
    -- Nicht ohne Weiteres über SUM abbildbar, da das ORDER BY als Kombinationen der Bedingungen ins WHERE müsste.
    FOR auftg_rec IN SELECT ag_id, ag_stk_uf1 - ag_stkl AS ag_stk_offen_uf1
                       FROM auftg
                      WHERE NOT ag_done
                        AND ag_astat LIKE _status AND ag_astat NOT IN ('A', 'R') AND ag_pos > 0 -- nur externe, keine Rahmen
                        AND ag_aknr = aknr
                        AND NOT ag_nstatistik
                      ORDER BY coalesce(ag_aldatum, ag_ldatum, ag_kdatum), ag_nr, ag_pos -- Priorität der Aufteilung
    LOOP
        IF auftg_rec.ag_id = in_agid OR coalesce(sum_lag, 0) <= 0 THEN
            RETURN greatest(sum_lag, 0);
        END IF;

        sum_lag := sum_lag - auftg_rec.ag_stk_offen_uf1; -- Auftragsmenge abziehen für nächsten Durchlauf
    END LOOP;
  END $$ LANGUAGE plpgsql STABLE;
--

-- Lieferfähigkeit eines kompletten Auftrags anhand Auftragsnummer
CREATE OR REPLACE FUNCTION TArtikel.art__auftg__lieferbar_komplett(IN in_agnr VARCHAR, IN in_agastat VARCHAR, IN in_lgort VARCHAR DEFAULT NULL) RETURNS VARCHAR AS $$
  DECLARE result_tmp VARCHAR;
  BEGIN
    IF in_agnr IS NULL OR in_agastat IS NULL THEN
        RETURN NULL;
    END IF;

    -- Rahmenverträge nicht betrachten, nur Abrufe
    IF in_agastat = 'R' THEN
        RETURN '/';
    END IF;

    -- Es gibt keine offene oder zu noch liefernden Positionen
    IF NOT EXISTS(SELECT true FROM auftg WHERE ag_astat = in_agastat AND ag_nr = in_agnr AND NOT ag_done AND ag_stk_uf1-ag_stkl > 0) THEN
        RETURN '/';
    END IF;

    -- Verkauf. Besonderheit: Geht positionsweise über Funktion tartikel.art__auftg__lieferbar_menge
    IF in_agastat = 'E' THEN
        -- Es gibt lieferbare Menge
        IF EXISTS(SELECT true FROM auftg
                  WHERE ag_astat = in_agastat AND ag_nr = in_agnr
                    AND NOT ag_done AND ag_stk_uf1-ag_stkl > 0 -- nicht erledigt und noch zu liefern
                    AND tartikel.art__auftg__lieferbar_menge(ag_id, in_lgort) >= ag_stk_uf1-ag_stkl) THEN -- lieferbare Menge ausreichend für offene Menge der Position
            -- es gibt wenigstens eine nicht lieferbare Menge
            IF EXISTS(SELECT true FROM auftg
                      WHERE ag_astat = in_agastat AND ag_nr = in_agnr
                        AND NOT ag_done AND ag_stk_uf1-ag_stkl > 0 -- nicht erledigt und noch zu liefern
                        AND tartikel.art__auftg__lieferbar_menge(ag_id, in_lgort) < ag_stk_uf1-ag_stkl) THEN -- lieferbare Menge nicht ausreichend
                result_tmp:=lang_text(16440); -- T: teilweise lieferbar, da wenigstens eine lieferbar und wenigstens eine nicht lieferabar ist
            ELSE
                result_tmp:=lang_text(16439); -- V: voll lieferbar
            END IF;
        ELSE
            result_tmp:=lang_text(16438); -- N: nichts lieferbar
        END IF;
    -- Materialbedarfe und Angebote. Besonderheit: Geht über ak_tot und bildet erst Summe über identische Artikel des Auftrags (wenn vorhanden in verschiedenen Positionen)
    ELSE -- 'I' und 'A'
        -- Es gibt lieferbare Menge
        IF EXISTS(SELECT true FROM
                      (SELECT ag_aknr, SUM(ag_stk_uf1-ag_stkl) AS auftg_aknr_offen FROM auftg
                       WHERE ag_astat = in_agastat AND ag_nr = in_agnr
                         AND NOT ag_done AND ag_stk_uf1-ag_stkl > 0 -- nicht erledigt und noch zu liefern
                       GROUP BY ag_aknr) AS auftg_aknr_sum
                  JOIN art ON ak_nr = ag_aknr
                  WHERE ak_tot >= auftg_aknr_offen) THEN -- Lagermenge ausreichend für offene Artikelmenge des Auftrags
            -- es gibt wenigstens eine nicht lieferbare Menge
            IF EXISTS(SELECT true FROM
                          (SELECT ag_aknr, SUM(ag_stk_uf1-ag_stkl) AS auftg_aknr_offen FROM auftg
                           WHERE ag_astat = in_agastat AND ag_nr = in_agnr
                             AND NOT ag_done AND ag_stk_uf1-ag_stkl > 0 -- nicht erledigt und noch zu liefern
                           GROUP BY ag_aknr) AS auftg_aknr_sum
                      JOIN art ON ak_nr = ag_aknr
                      WHERE ak_tot < auftg_aknr_offen) THEN -- Lagermenge nicht ausreichend
                result_tmp:=lang_text(16440); -- T: teilweise lieferbar, da wenigstens eine lieferbar und wenigstens eine nicht lieferabar ist
            ELSE
                result_tmp:=lang_text(16439); -- V: voll lieferbar
            END IF;
        ELSE
            result_tmp:=lang_text(16438); -- N: nichts lieferbar
        END IF;
    END IF;

    RETURN result_tmp;
  END $$ LANGUAGE plpgsql STABLE;
--

-- Artikelaustausch: Artikel umbenennen oder zusammenführen
CREATE OR REPLACE FUNCTION tartikel.artikelaustausch(IN ak_nr_old VARCHAR, IN ak_nr_new VARCHAR) RETURNS VOID AS $$
  DECLARE me_iso_incomplete VARCHAR;
          opix INTEGER;
          new_dbrid VARCHAR;
          old_dbrid VARCHAR;
  BEGIN
    --- OG #13758
        ak_nr_new := trim(ak_nr_new);

        IF NOT EXISTS(SELECT true FROM art WHERE ak_nr = ak_nr_old) THEN
           RAISE EXCEPTION '%', format(lang_text(29578), ak_nr_old);   --- xtt29578: 'Artikelaustausch nicht möglich. Quell-Artikel %s existiert nicht.'
        END IF;
    ---
    -- Die Einträge in die artlog (PHKO). #7441
        -- Bestehende Logs auf neue Artikelnummer umschreiben, mit Vermerk der alten Artikelnummer.
        UPDATE artlog SET akl_aknr= ak_nr_new, akl_txt= (COALESCE(akl_txt || E'\n' ,'') || lang_text(16641) || ' ' ||  ak_nr_old) WHERE akl_aknr = ak_nr_old;
        -- eigener Eintrag fürs Umschreiben selbst
        INSERT INTO artlog (akl_aknr, akl_ak_bez_new, akl_ak_znr_new, akl_ak_idx_new, akl_ak_hest_new, akl_ak_vkpbas_new, akl_txt)
        SELECT ak_nr_new, ak_bez, ak_znr, ak_idx, ak_hest, ak_vkpbas, (lang_text(16641) || ' ' ||  ak_nr_old) FROM art WHERE ak_nr = ak_nr_old;
    --

    -- Einträge in Audit-Log. #9264
        new_dbrid:= dbrid FROM art WHERE ak_nr = ak_nr_new; -- dbrid des Zielartikels. Wenn NULL, dann nur umbenannt und l_dbrid bleibt.
        old_dbrid:= dbrid FROM art WHERE ak_nr = ak_nr_old; -- dbrid des Quellartikels.

        -- Bestehende Logs auf neue Artikelnummer umschreiben.
        UPDATE tlog.Auditlog SET l_dbrid = COALESCE(new_dbrid, l_dbrid), l_parent_ID = ak_nr_new WHERE l_dbrid = old_dbrid;
        -- eigener Eintrag fürs Umschreiben selbst.
        INSERT INTO tlog.Auditlog(l_tablename , l_txid        , l_operation, l_json_old                                                         , l_json_new                                                         , l_dbrid                       , l_parent_ID, l_parent_FName, l_ident)
        SELECT                    'public.art', txid_current(), 'U'        , ( SELECT to_json( sub ) FROM ( SELECT ak_nr_old AS ak_nr ) as sub ), ( SELECT to_json( sub ) FROM ( SELECT ak_nr_new AS ak_nr ) as sub ), COALESCE(new_dbrid, old_dbrid), ak_nr_new  , 'ak_nr'       , concat_ws( ' ', lang_text(6131), ': ', ak_nr_old, '=>', ak_nr_new );
    --

    -- Audit-Log abschalten: so tun, als wären wir 'syncro' (u.a. wg. modified-Triggern)
    PERFORM disablemodified();
    PERFORM TSystem.trigger__disable( 'auftg' );
    --
    SET LOCAL SESSION AUTHORIZATION 'syncro';
    -- Umbenennen: Zielartikel nicht vorhanden
    IF NOT EXISTS(SELECT true FROM art WHERE ak_nr = ak_nr_new) THEN -- Der neue Artikel existiert noch nicht.
        UPDATE art SET ak_nr= ak_nr_new WHERE ak_nr = ak_nr_old; -- Super, dann macht die Datenbank alles! (REFERENCES art ON UPDATE CASCADE)
        -- ohne Referenzen
        UPDATE abk SET ab_ap_nr= ak_nr_new WHERE ab_ap_nr = ak_nr_old;
        UPDATE BestVorschlagPos SET bvp_aknr= ak_nr_new WHERE bvp_aknr = ak_nr_old;
        UPDATE bestanfpos SET bap_aknr = ak_nr_new WHERE bap_aknr = ak_nr_old;
        UPDATE anfart SET aArt_ak_nr= ak_nr_new WHERE aArt_ak_nr = ak_nr_old;
        UPDATE recnokeyword SET r_descr= ak_nr_new WHERE r_kategorie = 'art' AND r_descr = ak_nr_old; -- Schlüsselworte der Dokumente umschreiben
        UPDATE lagerlog SET lo_aknr_old= ak_nr_old, lo_aknr_new= ak_nr_new WHERE lo_aknr_new = ak_nr_old;
        UPDATE stvrevision SET str_resid= ak_nr_new WHERE str_resid = ak_nr_old;
        UPDATE stvtrs SET resid= ak_nr_new WHERE resid = ak_nr_old AND stv_str_revnr IS NOT NULL; -- Nur gespeicherte Revisionen
        UPDATE stvtrs SET aknr= ak_nr_new WHERE aknr = ak_nr_old AND stv_str_revnr IS NOT NULL; -- Nur gespeicherte Revisionen
        UPDATE haenel_aktion SET ha_aknr= ak_nr_new WHERE ha_aknr = ak_nr_old;
        UPDATE belzeil_frei SET bz_aknr= ak_nr_new WHERE bz_aknr = ak_nr_old; -- belzeil_auftg_lif hat fkey (belzeil_grund und belzeil_frei nicht)
    -- Zusammenführung: Zielartikel ist vorhanden
    ELSE
        -- Prüfung der ME für Zusammenführung
            IF EXISTS( -- Im Zielartikel sind ME-Codes nicht vorhanden? Prüfe Verwendungen inkl. Fehlermeldung, sodass sie dann vom Anwender erstellt werden können.
                SELECT true FROM artmgc AS artmgc_old
                WHERE artmgc_old.m_ak_nr = ak_nr_old
                  AND NOT EXISTS(SELECT true FROM artmgc AS artmgc_new WHERE artmgc_new.m_ak_nr = ak_nr_new AND artmgc_new.m_mgcode = artmgc_old.m_mgcode))
            THEN
                SELECT array_to_string(ARRAY( -- Stringliste der fehlenden me_bez bauen
                    SELECT me_bez FROM artmgc AS artmgc_old JOIN mgcode ON me_cod = artmgc_old.m_mgcode
                    WHERE artmgc_old.m_ak_nr = ak_nr_old -- aus Quelle
                      -- ME-Code existiert nicht im Ziel
                      AND NOT EXISTS(SELECT true FROM artmgc AS artmgc_new WHERE artmgc_new.m_ak_nr = ak_nr_new AND artmgc_new.m_mgcode = artmgc_old.m_mgcode)
                      -- Findet in einer der Referenzen Verwendung
                      AND (  EXISTS(SELECT true FROM auftg WHERE ag_mcv = m_id)
                          OR EXISTS(SELECT true FROM auftg WHERE ag_vkp_mce = m_id)
                          OR EXISTS(SELECT true FROM belegpos WHERE belp_mce = m_id)
                          OR EXISTS(SELECT true FROM belegpos WHERE belp_preis_mce = m_id)
                          OR EXISTS(SELECT true FROM belzeil_grund WHERE belzeil_grund.bz_mce = m_id)
                          OR EXISTS(SELECT true FROM belzeil_grund WHERE belzeil_grund.bz_vkp_mce = m_id)
                          -- OR EXISTS(SELECT true FROM belzeil_auftg_lif WHERE belzeil_auftg_lif.bz_mce = m_id)     -- in belzeil_grund enthalten
                          -- OR EXISTS(SELECT true FROM belzeil_auftg_lif WHERE belzeil_auftg_lif.bz_vkp_mce = m_id) -- in belzeil_grund enthalten
                          OR EXISTS(SELECT true FROM bestvorschlagpos WHERE bvp_mcv = m_id)
                          OR EXISTS(SELECT true FROM epreis WHERE e_mcv = m_id)
                          -- OR EXISTS(SELECT true FROM invlag WHERE il_mce = m_id) -- Nicht nötig. Keine Zusammenführung bei Inventur, s.u..
                          OR EXISTS(SELECT true FROM lag WHERE lg_mce = m_id) -- Prüfung/Fehler hierbei fraglich, da keine Zusammenführung der Lagerdaten (s.u.). Info ist allerdings nützlich fürs händische Umbuchen, daher gelassen.
                          OR EXISTS(SELECT true FROM ldsdok WHERE ld_mce = m_id)
                          OR EXISTS(SELECT true FROM ldsdok WHERE ld_ekp_mce = m_id)
                          OR EXISTS(SELECT true FROM lifsch WHERE l_abg_mec = m_id)
                          OR EXISTS(SELECT true FROM op6 WHERE o6_mce = m_id)
                          -- OR EXISTS(SELECT true FROM rahmenlieferant WHERE rhl_mgc = m_id) -- Nicht nötig. Keine Zusammenführung bei Zwischentabelle für Rahmenbestellung, s.u..
                          OR EXISTS(SELECT true FROM stv WHERE st_mgc = m_id)
                          OR EXISTS(SELECT true FROM stvtrs WHERE stmgc = m_id AND stv_str_revnr IS NOT NULL) -- Nur gespeicherte Revisionen
                          OR EXISTS(SELECT true FROM vertrag_pos WHERE vtp_mce = m_id)
                          OR EXISTS(SELECT true FROM wendat WHERE w_zug_mec = m_id)
                      )
                    ORDER BY me_bez) -- SELECT me_bez ENDE
                , ', ') -- array_to_string Separator
                INTO me_iso_incomplete;

                IF COALESCE(me_iso_incomplete, '') <> '' THEN
                    RAISE EXCEPTION '%', langtext(16293) || E'\n\n' || me_iso_incomplete;
                END IF;
            END IF;
        --

        -- Prüfung, ob noch Lagermengen vorhanden sind. Hier kann nicht automatisiert vorgegangen werden (Lagorte gleich, UF der ME ...). Dann Konflikt-Fehler mit Hinweis.
            IF EXISTS(SELECT true FROM lag WHERE lg_aknr = ak_nr_old AND lg_anztot > 0) THEN
                RAISE EXCEPTION '%', lang_text(16300); -- Konflikte... Bitte buchen Sie per Hand den alten Artikel aus und den neuen ein.
            END IF;
        --

        -- Zusammenführung
            -- Umschreiben der Artikelnummer. Ggf. inkl. Umschreiben der ME-ID (muss zusammen gemacht werden, wegen neuer Konsistenz-Prüfung #7858)
            -- Artikelstamm
                UPDATE artzuo SET az_pronr= ak_nr_new WHERE az_pronr = ak_nr_old;
            -- AVOR
                FOR opix IN SELECT op_ix FROM opl WHERE op_n = ak_nr_new LOOP
                    UPDATE abk SET ab_askix= TArtikel.opl__op_ix__get__standard_by__aknr(ak_nr_old) WHERE ab_askix = opix;
                END LOOP;
                UPDATE opl SET op_n = ak_nr_new, op_vi = op_vi || 'X', op_vit = op_vit || '~' || op_n, op_standard = false, op_qs_freigabe = NULL, op_stat = NULL WHERE op_n = ak_nr_old; -- QS-Freigabe zurücksetzen
                IF FOUND THEN -- #13045
                  PERFORM PRODAT_MESSAGE(lang_text(28267), 'Information'); -- #10822
                END IF;
                UPDATE op5 SET o5_wz_aknr= ak_nr_new WHERE o5_wz_aknr = ak_nr_old;
                UPDATE op6 SET
                  o6_aknr= ak_nr_new,
                  o6_mce= (SELECT am_new.m_id FROM artmgc AS am_new WHERE am_new.m_ak_nr = ak_nr_new AND am_new.m_mgcode = (SELECT am_old.m_mgcode FROM artmgc AS am_old WHERE am_old.m_id = o6_mce))
                WHERE o6_aknr = ak_nr_old;
                UPDATE oplpm SET pm_part= ak_nr_new WHERE pm_part = ak_nr_old;
                UPDATE artpr SET pr_aknr= ak_nr_new WHERE pr_aknr = ak_nr_old;
            -- Stückliste
                UPDATE stv SET st_zn= ak_nr_new WHERE st_zn = ak_nr_old;
                UPDATE stv SET
                  st_n= ak_nr_new,
                  st_mgc= (SELECT am_new.m_id FROM artmgc AS am_new WHERE am_new.m_ak_nr = ak_nr_new AND am_new.m_mgcode = (SELECT am_old.m_mgcode FROM artmgc AS am_old WHERE am_old.m_id = st_mgc))
                WHERE st_n = ak_nr_old;
                UPDATE stvrevision SET str_resid= ak_nr_new WHERE str_resid = ak_nr_old;
                UPDATE stvtrs SET resid= ak_nr_new WHERE resid = ak_nr_old AND stv_str_revnr IS NOT NULL; -- Nur gespeicherte Revisionen
                UPDATE stvtrs SET
                  aknr= ak_nr_new,
                  stmgc= (SELECT am_new.m_id FROM artmgc AS am_new WHERE am_new.m_ak_nr = ak_nr_new AND am_new.m_mgcode = (SELECT am_old.m_mgcode FROM artmgc AS am_old WHERE am_old.m_id = stmgc))
                WHERE aknr = ak_nr_old AND stv_str_revnr IS NOT NULL; -- Nur gespeicherte Revisionen
            -- Verkauf
                UPDATE auftg SET
                  ag_aknr= ak_nr_new,
                  ag_mcv= (SELECT am_new.m_id FROM artmgc AS am_new WHERE am_new.m_ak_nr = ak_nr_new AND am_new.m_mgcode = (SELECT am_old.m_mgcode FROM artmgc AS am_old WHERE am_old.m_id = ag_mcv)),
                  ag_vkp_mce= (SELECT am_new.m_id FROM artmgc AS am_new WHERE am_new.m_ak_nr = ak_nr_new AND am_new.m_mgcode = (SELECT am_old.m_mgcode FROM artmgc AS am_old WHERE am_old.m_id = ag_vkp_mce))
                WHERE ag_aknr = ak_nr_old;
            -- Einkauf
                UPDATE ldsdok SET
                  ld_aknr= ak_nr_new,
                  ld_mce= (SELECT am_new.m_id FROM artmgc AS am_new WHERE am_new.m_ak_nr = ak_nr_new AND am_new.m_mgcode = (SELECT am_old.m_mgcode FROM artmgc AS am_old WHERE am_old.m_id = ld_mce)),
                  ld_ekp_mce= (SELECT am_new.m_id FROM artmgc AS am_new WHERE am_new.m_ak_nr = ak_nr_new AND am_new.m_mgcode = (SELECT am_old.m_mgcode FROM artmgc AS am_old WHERE am_old.m_id = ld_ekp_mce))
                WHERE ld_aknr = ak_nr_old;
                -- rahmenlieferant: Keine automatische Zusammenführung. Weder Artikelnummer noch ME-ID werden bei Zwischentabelle Rahmenbestellung umgeschrieben. Kaskadiert mit ldsdok über Trigger.
                UPDATE epreis SET
                  e_aknr= ak_nr_new,
                  e_mcv= (SELECT am_new.m_id FROM artmgc AS am_new WHERE am_new.m_ak_nr = ak_nr_new AND am_new.m_mgcode = (SELECT am_old.m_mgcode FROM artmgc AS am_old WHERE am_old.m_id = e_mcv))
                WHERE e_aknr = ak_nr_old;
                UPDATE epreis SET e_fertaknr = ak_nr_new WHERE e_fertaknr = ak_nr_old;
                UPDATE eprzutxt SET ezt_aknr= ak_nr_new WHERE ezt_aknr = ak_nr_old;
            -- Lager
                -- lag:     Keine automatische Zusammenführung. Bei vorhandenen Lagerdaten, gibt es Fehler (s.o.).
                -- invlag:  Keine automatische Zusammenführung. Weder Artikelnummer noch ME-ID werden bei Inventur umgeschrieben.
                UPDATE wendat SET
                  w_aknr= ak_nr_new,
                  w_zug_mec= (SELECT am_new.m_id FROM artmgc AS am_new WHERE am_new.m_ak_nr = ak_nr_new AND am_new.m_mgcode = (SELECT am_old.m_mgcode FROM artmgc AS am_old WHERE am_old.m_id = w_zug_mec))
                WHERE w_aknr = ak_nr_old;
                UPDATE lifsch SET
                  l_aknr= ak_nr_new,
                  l_abg_mec= (SELECT am_new.m_id FROM artmgc AS am_new WHERE am_new.m_ak_nr = ak_nr_new AND am_new.m_mgcode = (SELECT am_old.m_mgcode FROM artmgc AS am_old WHERE am_old.m_id = l_abg_mec))
                WHERE l_aknr = ak_nr_old;
                UPDATE lifschpack SET lp_aknr= ak_nr_new WHERE lp_aknr = ak_nr_old;
                UPDATE haenel_aktion SET ha_aknr= ak_nr_new WHERE ha_aknr = ak_nr_old;
                -- #8920
                UPDATE lagerlog SET lo_aknr_old= ak_nr_old, lo_aknr_new= ak_nr_new WHERE lo_aknr_new = ak_nr_old;
            -- Belege (Lieferschein, Eingangsrechnung)
                UPDATE belegpos SET
                  belp_aknr= ak_nr_new,
                  belp_mce= (SELECT am_new.m_id FROM artmgc AS am_new WHERE am_new.m_ak_nr = ak_nr_new AND am_new.m_mgcode = (SELECT am_old.m_mgcode FROM artmgc AS am_old WHERE am_old.m_id = belp_mce)),
                  belp_preis_mce= (SELECT am_new.m_id FROM artmgc AS am_new WHERE am_new.m_ak_nr = ak_nr_new AND am_new.m_mgcode = (SELECT am_old.m_mgcode FROM artmgc AS am_old WHERE am_old.m_id = belp_preis_mce))
                WHERE belp_aknr=ak_nr_old;
            -- Faktura
                UPDATE belzeil_auftg_lif SET
                  bz_aknr= ak_nr_new,
                  bz_mce= (SELECT am_new.m_id FROM artmgc AS am_new WHERE am_new.m_ak_nr = ak_nr_new AND am_new.m_mgcode = (SELECT am_old.m_mgcode FROM artmgc AS am_old WHERE am_old.m_id = bz_mce)),
                  bz_vkp_mce= (SELECT am_new.m_id FROM artmgc AS am_new WHERE am_new.m_ak_nr = ak_nr_new AND am_new.m_mgcode = (SELECT am_old.m_mgcode FROM artmgc AS am_old WHERE am_old.m_id = bz_vkp_mce))
                WHERE bz_aknr = ak_nr_old;
                UPDATE belzeil_frei SET bz_aknr= ak_nr_new WHERE bz_aknr = ak_nr_old; -- wird nicht mit ME-ID sondern mit ME-Code erzeugt
            -- Bestellvorschläge
                UPDATE BestVorschlagPos SET
                  bvp_aknr= ak_nr_new,
                  bvp_mcv= (SELECT am_new.m_id FROM artmgc AS am_new WHERE am_new.m_ak_nr = ak_nr_new AND am_new.m_mgcode = (SELECT am_old.m_mgcode FROM artmgc AS am_old WHERE am_old.m_id = bvp_mcv))
                WHERE bvp_aknr = ak_nr_old;
            -- ABK Arbeitspakte
                UPDATE abk SET ab_ap_nr= ak_nr_new WHERE ab_ap_nr = ak_nr_old;
            -- Anfrageverwaltung
                UPDATE anfart SET aArt_ak_nr= ak_nr_new WHERE aArt_ak_nr = ak_nr_old; -- wird nicht mit ME-ID sondern mit ME-Code erzeugt
            -- Schlüsselworte der Dokumente umschreiben
                UPDATE recnokeyword SET r_descr= ak_nr_new WHERE r_kategorie = 'art' AND r_descr = ak_nr_old;
            -- Vertragsmanagement
                UPDATE vertrag_pos SET
                  vtp_ak_nr= ak_nr_new,
                  vtp_mce= (SELECT am_new.m_id FROM artmgc AS am_new WHERE am_new.m_ak_nr = ak_nr_new AND am_new.m_mgcode = (SELECT am_old.m_mgcode FROM artmgc AS am_old WHERE am_old.m_id = vtp_mce))
                WHERE vtp_ak_nr = ak_nr_old;
            --
        --
    END IF;
    --- #9421
    PERFORM tartikel.bestand_abgleich(ak_nr_old);--bestandsabgleich und bedarfsaktualisierung
    PERFORM tartikel.bestand_abgleich(ak_nr_new);--bestandsabgleich und bedarfsaktualisierung
    ---

    -- raus
    RESET SESSION AUTHORIZATION;
    PERFORM enablemodified();
    PERFORM TSystem.trigger__enable( 'auftg' );     --- ALTER TABLE auftg ENABLE  TRIGGER USER;
    RETURN;
  END $$ LANGUAGE plpgsql;
--
--- #17568
--- Eingangsparameter sind aus RTF ( rtf_id = 69 )
CREATE OR REPLACE FUNCTION tartikel.artikel__copy(
    IN _ak_nr_old               varchar,                   --- alter Artikel-Nr
    IN _ak_nr_new               varchar,                   --- neuer Artikel-Nr
    IN _chkpreisweg             boolean = false,           --- Preise entfernen
    IN _chkkunden               boolean = false,           --- Kundenzuordnung kopieren
    IN _chkaenderung            boolean = false,           --- Änderungen kopieren
    IN _chklieferanten          boolean = false,           --- Lieferanten kopieren
    IN _mitask                  boolean = false,           --- ASK kopieren
    IN _op_ix                   integer  = null,           --- ASK kopieren
    IN _copy_all_ask_variants   boolean = false,           --- alle ASK-Varianten kopieren
    IN _chkfert                 boolean = false,           --- Fertigungsvariante: die kopierte ASK wird automatisch für die nächste ABK ausgelöst, keine Freigabe durch AVOR
    IN _mitstv                  boolean = false,           --- Stückliste kopieren
    IN _mitparam                boolean = false,           --- Kopiert die Eigenschaften unter Sonstiges.
    IN _chkminmeldesoll         boolean = false            --- Mindest / Melde / Sollbestand mitkopieren
    )
    RETURNS VOID
    AS $$
    DECLARE new_dbrid             varchar;
            old_dbrid             varchar;
            _tabnameendung        varchar := '__' || to_char( Now(), 'YYYY_MM_DD__HH24_MI_SS' );
            _ak_nr_old_           varchar := _ak_nr_old;     --- Quelle-Artikel ohne Quote-Literal-Casten
            _ak_nr_new_           varchar := _ak_nr_new;     --- Ziel-Artikel ohne Quote-Literal-Casten

    BEGIN

        RAISE NOTICE '_tabnameendung = %', _tabnameendung;

        _ak_nr_old := quote_literal( _ak_nr_old );
        _ak_nr_new := quote_literal( _ak_nr_new );

        --- Daten von neuer Artikel löschen
        IF NOT EXISTS( SELECT true FROM art WHERE ak_nr = _ak_nr_old_ ) THEN
            --- RAISE EXCEPTION '''%'' - %', _ak_nr_new, lang_text(16710);
            RAISE EXCEPTION '%', lang_text(16710);
            RETURN;
        END IF;

        --- Daten von neuer Artikel löschen
        IF _chkkunden THEN
            DELETE FROM artzuo WHERE az_pronr = _ak_nr_new;
        END IF;

        IF _chklieferanten THEN
            DELETE FROM epreisabzu WHERE eaz_e_id IN (SELECT e_id FROM epreis WHERE e_aknr = _ak_nr_new);
            DELETE FROM epreis WHERE e_aknr = _ak_nr_new;
        END IF;

        IF _mitstv THEN
            DELETE FROM stv WHERE st_zn = _ak_nr_new;
        END IF;

        IF _mitask THEN
            DELETE FROM opl WHERE op_n = _ak_nr_new;
        END IF;

        DELETE FROM art WHERE ak_nr = _ak_nr_new_;
        DELETE FROM artlog WHERE akl_aknr = _ak_nr_new;
        DELETE FROM tlog.Auditlog WHERE (l_dbrid = (SELECT dbrid FROM art WHERE ak_nr = _ak_nr_new)) OR (l_parent_ID = _ak_nr_new AND l_tablename = 'public.art' AND l_parent_FName = 'ak_nr');

        --- kopierte Artikel in temporäre Tabelle kopieren
        EXECUTE 'DROP TABLE IF EXISTS art' || _tabnameendung || ';';
        EXECUTE 'CREATE TEMP TABLE art' || _tabnameendung || ' AS SELECT * FROM art WHERE ak_nr = ' || _ak_nr_old || ';';
        EXECUTE 'UPDATE art' || _tabnameendung || ' SET ak_nr=' || _ak_nr_new || ', ak_znr=CASE WHEN ak_nr=ak_znr /*Alte ArtikelNummer=alte Zeichnungsnummer*/ THEN ' || _ak_nr_new || ' ELSE ak_znr END, ak_tot=0, ak_res=0, ak_bes=0, dbrid=nextval(''db_id_seq''), ak_neuanlage = true, ak_bfr = null, insert_by = current_user;';


        --- Artikeldaten beim Bedarf löschen
        IF _chkpreisweg THEN
            EXECUTE 'UPDATE art' || _tabnameendung || ' SET ak_hest=0, ak_hest_et=0, ak_rust=0, ak_rust_et=0, ak_fertk=0, ak_fertk_et=0, ak_matk=0, ak_matk_et=0, ak_awkost=0, ak_awkost_et=0, ak_vkpbas=0, ak_vkpbas_et=0;';
        END IF;

        IF not _chkminmeldesoll THEN
            EXECUTE 'UPDATE art' || _tabnameendung || ' SET ak_min=0, ak_melde=NULL, ak_soll=NULL;';
        END IF;

        IF not _chkkunden THEN
            EXECUTE 'UPDATE art' || _tabnameendung || ' SET ak_kunde=NULL;';
        END IF;

        EXECUTE 'INSERT INTO art SELECT * FROM art' || _tabnameendung || ';';

        --- artlog, Eintrag in die Artlog art damit man nachvollziehen kann welcher Artikel kopiert worden ist
        INSERT INTO artlog (akl_aknr, akl_ak_bez_new, akl_ak_znr_new, akl_ak_idx_new, akl_ak_hest_new, akl_ak_vkpbas_new, akl_txt) SELECT _ak_nr_new, ak_bez, ak_znr, ak_idx, ak_hest, ak_vkpbas, (COALESCE((SELECT akl_txt FROM artlog WHERE akl_aknr = ak_nr AND akl_txt IS NOT NULL ORDER BY akl_id DESC LIMIT 1)|| E'\n', '')  ||  'Artikel-Nr. vor dem Kopieren: ' ||  _ak_nr_old) FROM art WHERE ak_nr = _ak_nr_old;

        --- Audit-Log, Eintrag in Audit-Log damit man nachvollziehen kann welcher Artikel kopiert worden ist
        INSERT INTO tlog.Auditlog(l_tablename , l_txid        , l_operation, l_json_old                               , l_json_new                               , l_dbrid                       , l_parent_ID, l_parent_FName)
        SELECT                    'public.art', txid_current(), 'U'        , to_json('"ak_nr":"' || _ak_nr_old::TEXT || '"'), to_json('"ak_nr":"' || _ak_nr_new::TEXT || '"'), COALESCE(new_dbrid, old_dbrid), _ak_nr_new  , 'ak_nr';

        ---  artmgc, Mengeneinheiten
        EXECUTE 'CREATE TEMP TABLE artmgc' || _tabnameendung || ' AS SELECT * FROM artmgc WHERE m_ak_nr=' || _ak_nr_old || ';';
        EXECUTE 'UPDATE artmgc' || _tabnameendung || ' SET m_ak_nr=' || _ak_nr_new || ', m_id=nextval(''artmgc_m_id_seq''), dbrid=nextval(''db_id_seq'');';
        EXECUTE 'INSERT INTO artmgc SELECT * FROM artmgc' || _tabnameendung || ' m1 WHERE NOT EXISTS(SELECT true FROM artmgc m2 WHERE m1.m_ak_nr=m2.m_ak_nr AND m1.m_mgcode=m2.m_mgcode);';

        ---  artblang, Artikelbezeichnung
        EXECUTE 'CREATE TEMP TABLE artblang' || _tabnameendung || ' AS SELECT *  FROM artblang WHERE akbl_ak_nr=' || _ak_nr_old || ';';
        EXECUTE 'UPDATE artblang' || _tabnameendung || ' SET akbl_ak_nr=' || _ak_nr_new || ', akbl_id=nextval(''artblang_akbl_id_seq''), dbrid=nextval(''db_id_seq'');';
        EXECUTE 'INSERT INTO artblang SELECT * FROM artblang' || _tabnameendung || ' AS a1 WHERE NOT EXISTS(SELECT true FROM artblang AS a2 WHERE a1.akbl_ak_nr=a2.akbl_ak_nr AND a1.akbl_spr_key=a2.akbl_spr_key);';

        ---  artmlang, Materialbezeichnung
        EXECUTE 'CREATE TEMP TABLE artmlang' || _tabnameendung || ' AS SELECT * FROM artmlang WHERE akml_ak_nr=' || _ak_nr_old || ';';
        EXECUTE 'UPDATE artmlang' || _tabnameendung || ' SET akml_ak_nr=' || _ak_nr_new || ', akml_id=nextval(''artmlang_akml_id_seq''), dbrid=nextval(''db_id_seq'');';
        EXECUTE 'INSERT INTO artmlang SELECT * FROM artmlang' || _tabnameendung || ' AS a1 WHERE NOT EXISTS(SELECT true FROM artmlang AS a2 WHERE a1.akml_ak_nr=a2.akml_ak_nr AND a1.akml_spr_key=a2.akml_spr_key);';

        ---  artdlang, Dimensionsbezeichnung
        EXECUTE 'CREATE TEMP TABLE artdlang' || _tabnameendung || ' AS SELECT * FROM artdlang WHERE akdl_ak_nr=' || _ak_nr_old || ';';
        EXECUTE 'UPDATE artdlang' || _tabnameendung || ' SET akdl_ak_nr=' || _ak_nr_new || ', akdl_id=nextval(''artdlang_akdl_id_seq''), dbrid=nextval(''db_id_seq'');';
        EXECUTE 'INSERT INTO artdlang SELECT * FROM artdlang' || _tabnameendung || ' AS a1 WHERE NOT EXISTS(SELECT true FROM artdlang AS a2 WHERE a1.akdl_ak_nr=a2.akdl_ak_nr AND a1.akdl_spr_key=a2.akdl_spr_key);';

        --- beim Bedarf die Daten durch temporäre Tabellen kopieren
        IF not _chkpreisweg THEN
            EXECUTE 'CREATE TEMP TABLE artvkp' || _tabnameendung || ' AS SELECT * FROM artvkp WHERE vkp_aknr=' || _ak_nr_old || ';';
            EXECUTE 'UPDATE artvkp' || _tabnameendung || ' SET vkp_aknr=' || _ak_nr_new || ', vkp_id=nextval(''artvkp_vkp_id_seq''), dbrid=nextval(''db_id_seq'');';
            EXECUTE 'CREATE TEMP TABLE artstp' || _tabnameendung || ' AS SELECT * FROM artstp WHERE astp_aknr=' || _ak_nr_old || ';';
            EXECUTE 'UPDATE artstp' || _tabnameendung || ' SET astp_aknr=' || _ak_nr_new || ', astp_id=nextval(''artstp_astp_id_seq''), dbrid=nextval(''db_id_seq'');';
            EXECUTE 'INSERT INTO artvkp SELECT * FROM artvkp' || _tabnameendung || ';';
            EXECUTE 'INSERT INTO artstp SELECT * FROM artstp' || _tabnameendung || ';';
        END IF;

        IF _chkkunden THEN
            EXECUTE 'CREATE TEMP TABLE artzuo' || _tabnameendung || ' AS SELECT * FROM artzuo WHERE az_pronr = ' || _ak_nr_old || ' AND NOT EXISTS(SELECT true FROM art WHERE ak_nr = az_pronr AND ak_kunde = az_prokrz AND COALESCE(az_bisdatum, current_date) >= current_date);'; -- ak_kunde erzeugt automatisch Eintrag"
            EXECUTE 'UPDATE artzuo' || _tabnameendung || ' SET az_id = nextval(''artzuo_az_id_seq''), az_pronr = ' || _ak_nr_new || ', dbrid = nextval(''db_id_seq''), az_kupr = 0, az_kunr = NULL, az_gdatum = NULL;';
            EXECUTE 'INSERT INTO artzuo SELECT * FROM artzuo' || _tabnameendung || ';';
        END IF;

        IF _chklieferanten THEN
            EXECUTE 'CREATE TEMP TABLE epreis' || _tabnameendung || ' AS SELECT * FROM epreis WHERE e_aknr = ' || _ak_nr_old || ' AND e_lkn<>''--- '';';
            EXECUTE 'UPDATE epreis' || _tabnameendung || ' SET e_id=nextval(''epreis_e_id_seq''), dbrid = nextval(''db_id_seq''), e_aknr=' || _ak_nr_new || ', e_mcv=art__standard_mgc_id(' || _ak_nr_new || '), e_ep=0, e_rab=NULL, e_lfzt = 0,  e_best = epreis' || _tabnameendung || '.e_id, e_stk = 1, e_gdatum = NULL, e_bewer = null, e_folgeap_op_ix__disabled = false;';
            EXECUTE 'INSERT INTO epreis SELECT * FROM epreis' || _tabnameendung || ';';
            EXECUTE 'CREATE TEMP TABLE epreisabzu' || _tabnameendung || ' AS SELECT * FROM epreisabzu WHERE eaz_e_id IN (SELECT e_id FROM epreis WHERE e_aknr = ' || _ak_nr_old || ' AND e_lkn<>''--- '');';
            EXECUTE 'UPDATE epreisabzu' || _tabnameendung || ' SET eaz_id=nextval(''epreisabzu_eaz_id_seq''), dbrid = nextval(''db_id_seq'');';
            EXECUTE 'INSERT INTO epreisabzu  (eaz_id, eaz_type,eaz_pos, eaz_abz_id, eaz_e_id, eaz_anz, eaz_betr, eaz_proz, eaz_canskonto, eaz_steucode, eaz_steuproz, eaz_konto, eaz_visible, eaz_zutxt, eaz_zutxt_rtf, eaz_zutxt_int , eaz_source_table, eaz_source_dbrid, dbrid, insert_date, insert_by, modified_date, modified_by) SELECT eaz_id, eaz_type, eaz_pos, eaz_abz_id, ep2.e_id, eaz_anz, eaz_betr, eaz_proz, eaz_canskonto, eaz_steucode, eaz_steuproz, eaz_konto, eaz_visible, eaz_zutxt, eaz_zutxt_rtf, eaz_zutxt_int , eaz_source_table, eaz_source_dbrid, epreisabzu' || _tabnameendung || '.dbrid, epreisabzu' || _tabnameendung || '.insert_date, epreisabzu' || _tabnameendung || '.insert_by,  epreisabzu' || _tabnameendung || '.modified_date, epreisabzu' || _tabnameendung || '.modified_by FROM epreisabzu' || _tabnameendung || ' join epreis ep1 on eaz_e_id = ep1.e_id join epreis ep2 on ep1.e_lkn = ep2.e_lkn and ep2.e_aknr = ' || _ak_nr_new || ' and ep2.e_best = ep1.e_id;';
            EXECUTE 'UPDATE epreis SET e_best=null WHERE e_aknr =' || _ak_nr_new || ';';
        END IF;

        IF _mitstv THEN
            EXECUTE 'CREATE TEMP TABLE stv_copy' || _tabnameendung || ' AS SELECT * FROM stv WHERE st_zn = ' || _ak_nr_old || ';';
            EXECUTE 'UPDATE stv_copy' || _tabnameendung || ' SET st_id = nextval(''stv_st_id_seq''), st_zn = ' || _ak_nr_new || ', dbrid = nextval(''db_id_seq'');';
            EXECUTE 'INSERT INTO stv SELECT * FROM stv_copy' || _tabnameendung || ';';
        END IF;

        IF _mitask THEN
            IF _copy_all_ask_variants THEN
                EXECUTE 'CREATE TEMP TABLE copy_ASK_output' || _tabnameendung || ' AS SELECT TArtikel.opl__copy__ASK( op_ix, ' || _ak_nr_new || '::VARCHAR, op_vi, null, op_standard, true, false, false )::VARCHAR FROM opl WHERE op_n = ' || _ak_nr_old || ' ORDER BY op_ix;';
            ELSE
                EXECUTE 'CREATE TEMP TABLE copy_ASK_output' || _tabnameendung || ' AS SELECT TArtikel.opl__copy__ASK(' || coalesce( _op_ix, 0 ) || ', ' || _ak_nr_new || ', ''1'', null, ' || _chkfert::TEXT || ', true, false, false )::VARCHAR;';
            END IF;
        END IF;

        IF _mitparam THEN
            EXECUTE 'DELETE FROM recnokeyword WHERE r_dbrid = (SELECT dbrid FROM art WHERE ak_nr = ' || _ak_nr_new || ') AND r_descr IS DISTINCT FROM ''keywordsearch'';';
            EXECUTE 'SELECT TRecnoParam.Set(r_reg_pname, (SELECT dbrid FROM art WHERE ak_nr=' || _ak_nr_new || '), r_value, r_unit, r_tablename, r_descr)
                     FROM (SELECT r_reg_pname, r_value, r_tablename, r_unit, r_descr FROM recnokeyword WHERE r_dbrid=(SELECT dbrid FROM art WHERE ak_nr=' || _ak_nr_old || ') AND r_tablename=''art'' AND r_descr IS DISTINCT FROM ''keywordsearch'' AND r_reg_pname IS DISTINCT FROM ''art.status.cad'') AS sub;';
        END IF;

        RETURN;
    END $$ LANGUAGE plpgsql;
  ---

-- #6263 Berechnung von Materialgewicht pro Längeneinheit, Gewichtsberechnung in AVOR
CREATE OR REPLACE FUNCTION tartikel.me__op6__menge_in_kg__by__o6_id(in_o6_id INTEGER) RETURNS NUMERIC AS $$
 BEGIN
       -- ak_gewicht - Materialghewicht (Artikelstamm)
       -- o6_m    - Anzahl Zuschnitte
       -- m_uf   - Mengeneinheit Umrechnungsfaktor
   RETURN (SELECT art.ak_gewicht*op6.o6_m/artmgc.m_uf
  FROM artmgc
  JOIN art ON ak_nr = m_ak_nr
  JOIN op6 ON o6_mce = m_id
  WHERE  o6_id = in_o6_id)::NUMERIC(8,3);
 END $$ LANGUAGE plpgsql;
--

-- Baugruppenkalkulation anhand ASK mit spez. Menge
-- Rückgabe: Selbstkosten, Verkaufspreisbasis, Grenzkosten jeweils (gesamt, Einzelpreis)
SELECT tsystem.function__drop_by_regex( 'art__calc_bgkost', _commit => true );
CREATE OR REPLACE FUNCTION tartikel.art__calc_bgkost(
    IN  _aknr VARCHAR,
    IN  _menge NUMERIC DEFAULT NULL,
    IN  _askix INTEGER DEFAULT NULL,
    IN  _resid_add VARCHAR DEFAULT NULL,
    OUT _selbstko NUMERIC,
    OUT _vkpbas NUMERIC,
    OUT _greko NUMERIC,
    OUT _selbstkoEP NUMERIC,
    OUT _vkpbasEP NUMERIC,
    OUT _grekoEP NUMERIC,
    OUT _calc_stat varchar
    )
    AS $$
    DECLARE _resid VARCHAR;
          _domenge NUMERIC;
    BEGIN
      IF _aknr IS NULL THEN RETURN; END IF;

      IF _menge IS NULL THEN
          SELECT op_lg INTO _domenge FROM opl JOIN art ON ak_nr = op_n WHERE op_n = _aknr AND IFTHEN(_askix IS NULL, op_kalku AND ak_fertigung, op_ix = _askix);
      ELSE
          _domenge:=_menge;
      END IF;

      _resid:= _aknr || COALESCE(_resid_add, '');

      IF     EXISTS(SELECT true FROM stv WHERE st_zn = _aknr) -- Stückliste vorhanden
          OR EXISTS(SELECT true FROM opl JOIN art ON ak_nr = op_n WHERE op_n = _aknr AND IFTHEN(_askix IS NULL, op_kalku AND ak_fertigung, op_ix = _askix)) -- oder Stammkarte vorhanden
      THEN
        _calc_stat := 'stueckl__do_stueckl';
        PERFORM tartikel.stueckl__do_stueckl(_resid, _aknr, _domenge, false, true, _askix, true); -- Hauptbaugruppe, hier kann ein fixer ASK-Index angegeben sein, ansonsten wird immer die Fertigungsvariante gewählt.

        -- Selbstkosten, Verkaufspreisbasis
        SELECT
          COALESCE(selbstkobg, IFTHEN(optart AND NOT artisoptart(aknr), 0, ak_hest)),   -- _selbstko
          COALESCE(vkpbasbg,   IFTHEN(optart AND NOT artisoptart(aknr), 0, ak_vkpbas))  -- _vkpbas
        INTO _selbstko, _vkpbas
        FROM stvtrs JOIN art ON ak_nr = aknr
        WHERE resid = _resid AND pos = -1 AND stv_str_revnr IS NULL;
        --

        -- Grenzkosten
        SELECT SUM(
                 CASE WHEN op_ix IS NOT NULL THEN -- Grenzkosten über op2_kost-Funkionen, wenn ASK vorhanden
                     stm * (tartikel.op2_rkost(op_ix, stm, true) + tartikel.op2_mkost(op_ix, true) + tartikel.op2_akost(op_ix, stm, true))
                 ELSE selbstko END                -- sonst Selbstkosten bei Kaufteilen, Rohmaterialien ausgeschlossen laut stvtrs
               )
          INTO _greko
          FROM stvtrs
          LEFT JOIN opl ON op_n = aknr AND op_standard
         WHERE resid = _resid
           AND stv_str_revnr IS NULL;
        --
      ELSIF EXISTS(SELECT true FROM artoption_arts WHERE aoa_g_ak_nr = _aknr) THEN -- Optionsartikel
        _calc_stat := 'artoption_arts';
        SELECT max((bgkost)._selbstko), -- _selbstko
               max((bgkost)._vkpbas),   -- _vkpbas
               max(                     -- _greko
                 CASE WHEN op_ix IS NOT NULL THEN -- s.o.
                     _domenge * (tartikel.op2_rkost(op_ix, _domenge, true) + tartikel.op2_mkost(op_ix, true) + tartikel.op2_akost(op_ix, _domenge, true))
                 ELSE (bgkost)._selbstko END
               )
          INTO _selbstko, _vkpbas, _greko
          FROM artoption_arts
          LEFT JOIN LATERAL tartikel.art__calc_bgkost(aoa_ak_nr, _domenge) AS bgkost ON true -- Berechnung für aoa_ak_nr Optionen
          LEFT JOIN opl ON op_n = aoa_ak_nr AND op_standard                         -- Berechnung für aoa_ak_nr Optionen
         WHERE aoa_g_ak_nr = _aknr; -- Optionsartikel
      ELSE
          _calc_stat := 'art';
          SELECT ak_hest * _domenge, ak_vkpbas * _menge, ak_hest * _domenge INTO _selbstko, _vkpbas, _greko FROM art WHERE ak_nr = _aknr;
      END IF;
      -- Einzelpreise
      _selbstkoEP := _selbstko / Do1If0( coalesce(_menge, _domenge) );
      _vkpbasEP   := _vkpbas   / Do1If0( coalesce(_menge, _domenge) );
      _grekoEP    := _greko    / Do1If0( coalesce(_menge, _domenge) );
      --
      RETURN;
    END $$ LANGUAGE plpgsql; --ACHTUNG - KEIN STABLE! => WIESO?! Wird hier in einem Statement für eine Menge die Werte geändert?!

/*
CREATE OR REPLACE FUNCTION tartikel.art__calc_bgkost__cached(
    IN  _aknr VARCHAR,
    IN  _menge NUMERIC DEFAULT NULL,
    IN  _askix INTEGER DEFAULT NULL,
    IN  _resid_add VARCHAR DEFAULT NULL,
    OUT _selbstko NUMERIC,
    OUT _vkpbas NUMERIC,
    OUT _greko NUMERIC,
    OUT _selbstkoEP NUMERIC,
    OUT _vkpbasEP NUMERIC,
    OUT _grekoEP NUMERIC
    )
    AS $$
    DECLARE _resid VARCHAR;
          _domenge NUMERIC;
    BEGIN
      -- NOT EXISTS IN temp TABLE
      -- INSERT INTO temp TABLE
      -- RETURN FROM temp TABLE
      RETURN;
    END $$ LANGUAGE plpgsql STABLE;
*/
--

--
CREATE OR REPLACE FUNCTION tartikel.art__calcartvkp(_aknr VARCHAR) RETURNS BOOL AS $$
    DECLARE artrec RECORD;
            vpbtrec RECORD;
            fixv NUMERIC;
            total NUMERIC;
            fixn NUMERIC;
            nvkp NUMERIC;
            stvvkp NUMERIC;
            _op7rec  record;
    BEGIN
     SELECT * INTO artrec
       FROM art, artcod
      WHERE ak_nr = _aknr AND ac_n = ak_ac;

     IF EXISTS(SELECT true FROM stv WHERE st_zn = _aknr) THEN
       artrec.ak_vkpbas := (tartikel.art__calc_bgkost(_aknr))._vkpbasEP;
     ELSE
       artrec.ak_vkpbas := artrec.ak_hest * coalesce(artrec.ak_vkpfaktor, artrec.ac_vkpfaktor);
     END IF;

     -- Rundungsfaktor
     IF coalesce(artrec.ak_vkprund, artrec.ac_vkprund, 0) > 0 THEN
            artrec.ak_vkpbas :=  round(artrec.ak_vkpbas / coalesce(artrec.ak_vkprund, artrec.ac_vkprund))
                               * coalesce(artrec.ak_vkprund, artrec.ac_vkprund);
     END IF;

     -- Ergebnis übertragen
     UPDATE art
        SET ak_vkpbas = artrec.ak_vkpbas
      WHERE ak_nr = artrec.ak_nr
        AND ak_vkpbas IS DISTINCT FROM artrec.ak_vkpbas;

     -- Fixpreisbetrachtung für Kundenklassenpreise!
     IF coalesce(artrec.ak_vkpbasfix, 0) <> 0 THEN --es gibt einen Preis im Artikelstamm
           stvvkp := artrec.ak_vkpbasfix;
     ELSE
           stvvkp := artrec.ak_vkpbas;
     END IF;


     FOR vpbtrec IN SELECT * FROM vpbt WHERE vp_prkl = artrec.ak_pknr LOOP

            fixv  := vpbtrec.vp_fixv;
            total := 1+vpbtrec.vp_proz/100;
            fixn  := vpbtrec.vp_fixn;

            nvkp  := ((stvvkp + coalesce(fixv, 0)) * coalesce(total, 1)) + coalesce(fixn, 0);

            -- Preis-Rundung
            nvkp  :=  round(nvkp / coalesce(artrec.ak_vkprund, artrec.ac_vkprund))
                    * coalesce(artrec.ak_vkprund, artrec.ac_vkprund);

            -- artvkp
              --alten Preis abschalten
              UPDATE artvkp
                 SET vkp_bisdat = current_date
               WHERE vkp_bisdat IS NULL
                 AND vkp_aknr   = artrec.ak_nr
                 AND vkp_kukl   = vpbtrec.vp_kukl
                 AND vkp_vondat < current_date;
  
              --neuen Preis eintragen
              IF nvkp IS NOT NULL THEN
                  IF NOT EXISTS(SELECT true FROM artvkp
                                 WHERE vkp_aknr   = artrec.ak_nr
                                   AND vkp_kukl   = vpbtrec.vp_kukl
                                   AND vkp_vondat = current_date)
                  THEN
                    INSERT INTO artvkp
                                (vkp_aknr, vkp_kukl,
                                 vkp_vkp,
                                 vkp_vondat)
                         VALUES (artrec.ak_nr, vpbtrec.vp_kukl,
                                 nvkp,
                                 current_date);
                  ELSE
                    UPDATE artvkp
                       SET vkp_vkpold = vkp_vkp,
                           vkp_vkp    = nvkp
                     WHERE vkp_aknr = artrec.ak_nr
                       AND vkp_kukl = vpbtrec.vp_kukl
                       AND vkp_vondat = current_date;
                  END IF;
              END IF;
            --  
            -- artstp
            FOR _op7rec IN SELECT op7.* FROM op7 JOIN opl ON o7_op_ix = op_ix WHERE op_n = _aknr AND op_kalku LOOP
            
              UPDATE artstp
                 SET astp_datgb = current_date
               WHERE astp_datgb IS NULL
                 AND astp_aknr  = artrec.ak_nr
                 AND astp_kukl  = vpbtrec.vp_kukl
                 AND astp_datgv < current_date
                 AND astp_menge = _op7rec.o7_m;           
              --
              --neuen Preis eintragen
              IF nvkp IS NOT NULL THEN
                  IF NOT EXISTS(SELECT true FROM artstp
                                 WHERE astp_aknr   = artrec.ak_nr
                                   AND astp_kukl   = vpbtrec.vp_kukl
                                   AND astp_datgv  = current_date
                                   AND astp_menge  = _op7rec.o7_m)
                  THEN
                    INSERT INTO artstp
                                (astp_aknr, 
                                 astp_kukl, 
                                 astp_menge,
                                 astp_vkp,
                                 astp_datgv)
                         VALUES (artrec.ak_nr, 
                                 vpbtrec.vp_kukl,
                                 _op7rec.o7_m,
                                 nvkp * _op7rec.o7_korr,
                                 current_date);
                  ELSE
                    UPDATE artstp
                       SET astp_vkp = nvkp * _op7rec.o7_korr
                     WHERE astp_aknr = artrec.ak_nr
                       AND astp_kukl = vpbtrec.vp_kukl
                       AND astp_datgv = current_date
                       AND astp_menge  = _op7rec.o7_m;
                  END IF;
              END IF;
            END LOOP;  
     END LOOP;
     RETURN true;
    END $$ LANGUAGE plpgsql;
--

/*STUECKLISTENAUFLÖSUNG*/

--
CREATE OR REPLACE FUNCTION tartikel.stueckl__do_stueckl_list(_resid VARCHAR, _aknr VARCHAR, _menge NUMERIC, _mit_romat BOOL DEFAULT FALSE, _kalkVar BOOL DEFAULT FALSE, OUT stn VARCHAR(40), OUT stk NUMERIC(12,2), OUT ebene VARCHAR(5)) RETURNS SETOF RECORD AS $$
  DECLARE stvtrs_rec RECORD;
  BEGIN
    PERFORM tartikel.stueckl__do_stueckl(_resid, _aknr, _menge, _mit_romat, true, NULL::INTEGER /*MainArtASK(NULL)*/, _kalkVar);
    FOR stvtrs_rec IN SELECT * FROM stvtrs WHERE resid=_resid AND stv_str_revnr IS NULL ORDER BY id LOOP --Revisionen ausschließen #5024
        stn:=stvtrs_rec.aknr;
        stk:=stvtrs_rec.stm;
        ebene:=stvtrs_rec.ebene;
        RETURN NEXT;
    END LOOP;
    RETURN;
  END $$ LANGUAGE plpgsql STRICT;
--


-- Einstiegsfunktion in die rekursive Stücklistenauflösung
CREATE OR REPLACE FUNCTION tartikel.stueckl__do_stueckl(
    _resid                VARCHAR,              -- Auflösungs-ID dieser Stücklistenauflösung
    _aknr                 VARCHAR,              -- Artikelnummer des Hauptartikels
    _menge                NUMERIC,              -- Menge für die die Stückliste auflöst wurde
    _mit_romat            BOOL DEFAULT FALSE,   -- Rohmaterial mit auflösen?
    _mitUngueltigeArtikel BOOL DEFAULT TRUE,    -- Ungültige Artikel mit auflösen?
    _mainArtikelASK       INTEGER DEFAULT NULL, -- Fertigungsvariante für den Hauptartikel (kann sich z.Bsp. im Rohmaterial unterscheiden)
    _kalkVar              BOOL DEFAULT FALSE,   -- Für alle Artikel (Einschließlich Wurzel) soll die Kalkulations- statt der Fertigungsvariante der ASK verwendet werden.
    _mitKalku             BOOL DEFAULT TRUE     -- Soll Baugruppenkalkulation ausgeführt werden oder nur Stücklistenauflösung
  ) RETURNS BOOLEAN AS $$
  BEGIN
    RETURN tartikel.stueckl__do_stueckl_int(_resid, _aknr, _menge, _mit_romat, _mitUngueltigeArtikel, /*_parent INTEGER DEFAULT*/ 0, /*_parent_stvtrs_dbrid*/ NULL, /*_ebene INTEGER DEFAULT*/ 0, /*_isRomat BOOL DEFAULT*/ FALSE, _mainArtikelASK, _kalkVar, /*_resIsBGCalc BOOL DEFAULT FALSE*/ FALSE, _mitKalku);
  END $$ LANGUAGE plpgsql;
--

-- Optionsartikel, welche sich selbst enthalten. https://redmine.prodat-sql.de/issues/18299?tab=notes#note-34
CREATE OR REPLACE FUNCTION tartikel.stvtrs__artoption_arts__aknr__recursive__exists(
    IN _resid   varchar,
    IN _parent  integer,
    IN _aknr    varchar
    )
    RETURNS boolean
    AS $$
    DECLARE _r record;
    BEGIN
        SELECT parent, aknr INTO _r
          FROM stvtrs
         WHERE resid = _resid
           AND id = _parent;

        IF _aknr = _r.aknr THEN
           RETURN true;
        END IF;

        IF _r.parent IS NULL THEN
           RETURN false;
        ELSE
           RETURN tartikel.stvtrs__artoption_arts__aknr__recursive__exists(_resid, _r.parent, _aknr);
        END IF;
    END $$ LANGUAGE plpgsql STRICT;


-- Rekursive Hauptfunktion der Stücklistenberechnung. Löst jeweils eine Ebene des Baumes mit den gegebenen Optionen auf.
  -- [X]=Weitergegebener Parameter aus stueckl__do_stueckl
CREATE OR REPLACE FUNCTION tartikel.stueckl__do_stueckl_int(
    IN _resid                varchar,              -- [X] Auflösungs-ID dieser Stücklistenauflösung
    IN _aknr                 varchar,              -- [X] Artikelnummer der Baugruppe -- RESID=AKNR: Baugruppenauflösung aus Stückliste
    IN _menge                numeric,              -- [X] Menge für die die Stückliste auflöst wurde
    IN _mit_romat            boolean,                 -- [X] Rohmaterial mit auflösen?
    IN _mitUngueltigeArtikel boolean,                 -- [X] Ungültige Artikel mit auflösen?
    IN _parent               integer,              -- ID (stvtrs.id) des übergeordneten Knoten, Wurzel = 0
    IN _parent_stvtrs_dbrid  varchar,              -- DBRID des übergeordneten Knotens,         Wurzel = NULL
    IN _ebene                integer,              -- Ebene von der Wurzel aus gezählt,         Wurzel = 0
    IN _isRomat              boolean,                 -- Flag: Row ist Rohmaterial (kommt aus op6)
    IN _mainArtikelASK       integer,              -- [X] Fertigungsvariante des Hauptartikels (kann sich z.Bsp. im Rohmaterial unterscheiden)
    IN _kalkVar              boolean,                 -- [X] Für alle Artikel (Einschließlich Wurzel) soll die Kalkulations- statt der Fertigungsvariante der ASK verwendet werden
    IN _resIsBGCalc          boolean DEFAULT FALSE,   -- Die Stücklistenauflösung kommt aus der Baugruppenkalkulation. Damit werden auch BL und KS Artikel aufgelöst. ACHTUGNG: wir beim Einstieg/ebene 0 ermittelt anhand _resid=aknr
    IN _mitKalku             boolean DEFAULT TRUE     -- Soll Baugruppenkalkulation ausgeführt werden oder nur Stücklistenauflösung
  )
  RETURNS boolean
  AS $$
  DECLARE I                 integer;
          I1                integer;
          myid              integer;
          stns              record; -- Artikeloptionen
          stnsvkpfix        numeric;
          stnsaskix         integer;
          isbgcalc          boolean;
          stns_stvtrs_dbrid varchar;
          parent_x          integer;              -- Verflachte Stückliste: Parent wird innerhalb der Ebene ermittelt.
          parent_stvtrs_dbrid_x  varchar;            -- Verflachte Stückliste
          EXCEPTION_TEXT    varchar;
          EXCEPTION_DETAIL  varchar;
          EXCEPTION_HINT    varchar;
  BEGIN
   BEGIN -- Abbruchbedingung: mehr als 30 Ebenen=Rekursion
    IF _ebene > 30 THEN
        INSERT INTO stvtrs (id, resid, parent, parent_stvtrs_dbrid, aknr, stm, ebene)
             VALUES (nextval('stvtrsid_seq'::TEXT), _resid, _parent, _parent_stvtrs_dbrid, 'ERROR', -999, _ebene);
        RETURN false;
    END IF;
    -- Einstieg : kein Parent => Parentartikel!
    IF _parent = 0 THEN
        EXECUTE 'DROP SEQUENCE IF EXISTS stvtrsid_seq';
        EXECUTE 'CREATE TEMP SEQUENCE stvtrsid_seq START 100 INCREMENT 100';
        DELETE FROM stvtrs WHERE resid = _resid AND stv_str_revnr IS NULL;

        _resIsBGCalc := _resid = _aknr;

        IF _mitKalku THEN -- Nur bei Kalkulation, nicht bei nur Auflösen
        -- aktuelles Log für Artikelpreis-Probleme vorbereiten
            -- TSystem.Settings__Set('BGCALC_CURRENT_RESID', _resid::VARCHAR) geht nicht wegen impliziten Cast bei _resid ist Integer (dann Feldüberlauf), daher nachgebaut.
            IF NOT EXISTS (SELECT true FROM settings WHERE s_vari = 'BGCALC_CURRENT_RESID') THEN
                INSERT INTO settings (s_vari, s_inha) SELECT 'BGCALC_CURRENT_RESID', _resid;
            ELSE
                UPDATE settings SET s_inha = _resid WHERE s_vari = 'BGCALC_CURRENT_RESID' AND s_inha IS DISTINCT FROM _resid;
            END IF;
            --
            DELETE FROM stvtrs_res_log WHERE strl_resid = _resid AND strl_res_object_type = 'art_ekpreis'; --log Artikelpreisprobleme
        --
        END IF;

        stnsaskix := _mainArtikelASK; --von aussen vorgegeben ASK für Hauptartikel
        IF stnsaskix IS NULL THEN
            stnsaskix := op_ix FROM opl WHERE op_n = _aknr AND CASE WHEN _kalkVar THEN op_kalku ELSE op_standard END; --keine ASK => dann StandardASK
        END IF;
        IF TSystem.Settings__GetBool('bgcalc_vkpfix:'||current_user, true) THEN
           stnsvkpfix := ak_vkpbasfix FROM art WHERE ak_nr = _aknr;--wenn Festpreis, dann wird dieser genommen, die Unterpositionen sind dann wie Rohmat
        END IF;
        INSERT INTO stvtrs (id, resid, aknr, askix, stm, stmgc, ebene, pos, romat) VALUES (0, _resid, _aknr, stnsaskix, _menge, tartikel.me__art__artmgc__m_id__by__ak_standard_mgc(_aknr), -1, -1, false /*_resid=_aknr AND stnsaskix IS NULL AND stnsvkpfix IS NULL*/) RETURNING dbrid INTO _parent_stvtrs_dbrid;
                                                                                        --Hauptdatensatz: Id=0, Parent: kein
                                                                                        --resid=aknr AND... : wenn wir eine Stücklistenkalkulation durchführen, dann sieht die Stückliste wie ein Rohmat aus => kein Preis, wenn der Hauptartikel keine AVOR hat!
    END IF;
    --
    isbgcalc := _resid = aknr FROM stvtrs WHERE resid = _resid AND id = 0 AND stv_str_revnr IS NULL;
    --den angegebenen Artikel auflösen
    FOR stns IN SELECT
                       stv.*, ac_i,
                       (TSystem.Settings__GetBool('bgcalc_vkpfix:'||current_user, true) AND ak_vkpbasfix IS NOT NULL)
                         AS arthasfixp
                       --, op_ix --Performace: LEFT JOIN macht Statement um >100ms langsamer mit dem Resultat, das große Stücklisten Minuten länger brauchen
                       , (SELECT op_ix FROM opl WHERE op_n = st_n AND CASE WHEN _kalkVar THEN op_kalku ELSE op_standard END)
                         AS op_ix
                  FROM stv
                  JOIN art ON ak_nr = st_n
                  JOIN artcod ON ak_ac = ac_n
                  --LEFT JOIN opl ON op_n=st_n AND CASE WHEN _kalkVar THEN op_kalku ELSE op_standard END --> siehe Kommentar oben bei , op_ix
                WHERE st_zn=_aknr
                  AND IfThen(_mitUngueltigeArtikel, true, coalesce(ak_auslauf, current_date) >= current_date)
/*STATUS#20827...*/
                  AND IfThen(_resIsBGCalc, true, NOT TSystem.ENUM_ContainsValue(st_stat, 'KS,BL,AM') ) --//ACHTUNG: auflösungsid=artikelnummer > damit wissen wir das alles aufgelöst wird, auch die "KS"- Artikel. http://pg.prodat-erp.de:212/stv_status_beistell.html
                      -- BL wird hier ausgefiltert -> weil???? Dieser Bedarf erst bei Erstellung des Lieferanteneinkauf dort ausgelöst wird!?
                ORDER BY st_pos
    LOOP
        -- Aktuelle Ebene eintragen.
        -- RAISE NOTICE '%', stns.st_n;
        myid := nextval('stvtrsid_seq'::TEXT);
        --Stückliste verflacht, aber dennoch Bezug zu Position (Struktur)
         IF stns.st_pos_parent IS NOT NULL THEN --diese Position hat innerhalb der verflachten Stückliste einen Bezug (Parent) angegeben
            SELECT id, dbrid INTO parent_x, parent_stvtrs_dbrid_x
              FROM stvtrs
             WHERE resid = _resid
               AND stv_str_revnr IS NULL
               AND pos = stns.st_pos_parent
               AND ebene = _ebene; --in der Auflösung den Parent ermitteln und die Bezüge setzen. Dabei darauf achten, das wir uns immer in der gleichen Ebene befinden (die Stücklistenpos 20 kann es bei Strukturauflösng in unterschiedlichen Ebenen mehrfach geben
         ELSE
            parent_x := NULL;
            parent_stvtrs_dbrid_x := NULL;
         END IF;
         parent_x:=coalesce(parent_x, _parent);
         parent_stvtrs_dbrid_x := coalesce(parent_stvtrs_dbrid_x, _parent_stvtrs_dbrid);
        --Stückliste verflacht
        INSERT INTO stvtrs (id, resid, parent, parent_stvtrs_dbrid, aknr, askix, stm, stmgc, stv_dbrid, ebene, pos, romat, kalku)
        VALUES (myid, _resid, parent_x, parent_stvtrs_dbrid_x, stns.st_n, stns.op_ix, stns.st_m_uf1*IFTHEN(stns.st_m_fix, 1, _menge), tartikel.me__art__artmgc__m_id__by__ak_standard_mgc(stns.st_n), stns.dbrid, _ebene, stns.st_pos,
                                                _isRomat
                                                OR (isbgcalc -- Baugruppencalc: die Resid=ST_ZN!
                                                    AND (
                                                         (_parent=0 AND (/*stnsaskix IS NULL OR */stnsvkpfix IS NOT NULL)) --Topbaugruppe hat zwar Unterbauteile, aber selbst keine ASK oder einen Festpreis=>Preise Unterbaugruppen sind irrelevant
                                                         /*OR (stns.op_ix IS NULL AND EXISTS(SELECT true FROM stv WHERE st_zn=stns.st_n) AND NOT stns.arthasfixp)*/ --wir selbst haben Unterbauteile, aber keine ASK und auch keinen Festpreis
                                                        )
                                                    ),
                                                _mitKalku
                ) RETURNING dbrid INTO stns_stvtrs_dbrid;
        --

        -- Strukturelement weiter auflösen.
        IF -- 'STR'  -- Verflachte Stückliste ausschließen.
           -- 'BK'   -- Stückliste, welche als Beistellung durch Kunden gekennzeichnet ist, ausschließen, siehe #11313.
           -- 'KS' und 'AM' können hier eigentlich nicht ankommen, da oben bereits ausgefiltert! Mindestens KS aber müßte hier eigentlich ankommen!
           --  ACHTE somit auf Auffilterungen am LOOP start!
/*STATUS#20827...*/
           NOT TSystem.ENUM_ContainsValue(stns.st_stat, 'STR,BK,KS,AM')
        THEN
            IF NOT tartikel.stueckl__do_stueckl_int(_resid, stns.st_n, CAST(stns.st_m_uf1*IFTHEN(stns.st_m_fix, 1, _menge) AS NUMERIC), _mit_romat, _mitUngueltigeArtikel, myid, stns_stvtrs_dbrid, _ebene + 1,
                                                _isRomat
                                                OR (isbgcalc--Baugruppencalc: die Resid=ST_ZN!
                                                    AND (stns.arthasfixp
                                                         OR (_parent = 0 AND (/*stnsaskix IS NULL OR*/ stnsvkpfix IS NOT NULL)) --Topbaugruppe hat zwar Unterbauteile, aber selbst keine ASK oder einen Festpreis=>Preise Unterbaugruppen sind irrelevant
                                                         OR (/*stns.op_ix IS NULL AND EXISTS(SELECT true FROM stv WHERE st_zn=stns.st_n) AND NOT*/ stns.arthasfixp) --wir selbst haben Unterbauteile, aber keine ASK und auch keinen Festpreis
                                                        )
                                                   )
                                                , NULL /*MainArtikelASK(NULL)*/
                                                , _kalkVar
                                                , _resIsBGCalc
                                                , _mitKalku
                                            )
            THEN --arthasfixp => wenn Artikel Fixpreis, dürfen die Unterartikel keine eigenen Preise in den Einzelsummen mitrechnen, da der Fixpreis des Kopfartikels die Unterpreise enthält!
                   RETURN false;--tritt nur ein, wenn Strukturtiefe zu tief und Abbruchbedingung
            END IF;
        END IF;
        --

        -- Rohmaterialien eintragen.
        -- Fertigungsartikel, welcher als Beistellung durch Kunden gekennzeichnet ist, ausschließen, siehe #11313.
/*STATUS#20827...*/
        IF NOT TSystem.ENUM_ContainsValue(stns.st_stat, 'STR,BK,KS,AM') THEN
            PERFORM tartikel.stueckl__do_romat(_resid,
                                               stns.st_n,
                                               CAST(stns.st_m_uf1 * IFTHEN(stns.st_m_fix, 1, _menge) AS NUMERIC),
                                               _mit_romat,
                                               _mitUngueltigeArtikel,
                                               myid,
                                               stns_stvtrs_dbrid,
                                               _ebene + 1,
                                               _resIsBGCalc,
                                               _mitKalku
                                               );
        END IF;
        -- RAISE NOTICE '%', stns.st_n;
    END LOOP;
    --Dies ist ein Optionsartikel, Platzhalter!
    FOR stns IN SELECT aoa_ak_nr
                  FROM artoption_arts
                  JOIN art ON aoa_ak_nr = ak_nr
                 WHERE aoa_g_ak_nr = _aknr
                   AND IfThen(_mitUngueltigeArtikel, true, coalesce(ak_auslauf, current_date) >= current_date)
                 ORDER BY aoa_pos, aoa_ak_nr
    LOOP
        IF tartikel.stvtrs__artoption_arts__aknr__recursive__exists(_resid, _parent, stns.aoa_ak_nr)  -- gleiche Option existiert bereit über mir => https://redmine.prodat-sql.de/issues/18299
        THEN
          CONTINUE;
        END IF;

        myid := nextval('stvtrsid_seq'::text);
        INSERT INTO stvtrs (id,     resid,  parent,  parent_stvtrs_dbrid,           aknr,    stm,                                                               stmgc,  ebene, optart,     romat, kalku)
             VALUES        (myid,  _resid, _parent, _parent_stvtrs_dbrid, stns.aoa_ak_nr, _menge, tartikel.me__art__artmgc__m_id__by__ak_standard_mgc(stns.aoa_ak_nr), _ebene,   true, _isRomat ,_mitKalku)
          RETURNING dbrid
               INTO stns_stvtrs_dbrid;
        PERFORM tartikel.stueckl__do_stueckl_int(_resid, stns.aoa_ak_nr, _menge, _mit_romat, _mitUngueltigeArtikel, myid, stns_stvtrs_dbrid, _ebene + 1, _isRomat, NULL /*MainArtikelASK(NULL)*/, _kalkVar, _resIsBGCalc, _mitKalku);
    END LOOP;
    --Hauptartikel: Evtl haben wir in unserer ASK ein Rohmaterial, welches aufgelöst werden kann/muß
    IF _parent = 0 THEN
        PERFORM tartikel.stueckl__do_romat(_resid, _aknr, _menge, _mit_romat, _mitUngueltigeArtikel, 0, stns_stvtrs_dbrid, _ebene, _kalkVar, _resIsBGCalc, _mitKalku);
    END IF;
    --
    IF _mitKalku THEN -- Nur bei Kalkulation, nicht bei nur Auflösen
      PERFORM execution_code__disable( _flagname => 'stvtrs' );

      --Zusammenrechnen der BG-Kosten.
      PERFORM tartikel.stueckl__calc_parent(_resid, _parent);
      IF _parent = 0 THEN
          -- Nochmal, da Hauptartikel und Artikel ebene 1 in einem Durchlauf nicht rekursiv ablaufen. Daher muss, um das BG-Erg. des Hauptartikels zu erhalten, zuerst Ebene 1 berechnet werden und dieses dann in den Hauptartikel übertragen werden.
          -- Insbesondere wichtig für einfache Artikel nur mit ASK (ohne Stückliste oder Vorprodukte), siehe tartikel.stueckl__calc_parent
          PERFORM tartikel.stueckl__calc_parent(_resid, _parent, true);

          --Behandlung von Konfigurations / Optionsartikeln
          --Übernahme des höchsten Preis in den Konfigurationsartikel aus den Optionen
          UPDATE stvtrs
             SET vkpbas    = coalesce(vkpbasbg, vkpbas),
                 selbstko  = coalesce(selbstkobg, selbstko),
                 roma      = coalesce(romabg, roma),
                 ruest     = coalesce(ruestbg, ruest),
                 auswaerts = coalesce(auswaertsbg, auswaerts)
           WHERE resid = _resid
             AND parent = _parent
             AND stm > 0
             AND (artisoptart(aknr) OR optart)
             AND stv_str_revnr IS NULL;
      END IF;
      --

      PERFORM execution_code__enable( _flagname => 'stvtrs' );
    END IF;
    --
    IF _parent = 0 THEN
        EXECUTE 'DROP SEQUENCE stvtrsid_seq';
        PERFORM TSystem.Settings__Set('BGCALC_CURRENT_RESID', '');
    END IF;

    RETURN true;

   EXCEPTION WHEN OTHERS THEN
       BEGIN
           GET STACKED DIAGNOSTICS EXCEPTION_TEXT = MESSAGE_TEXT
                                   ,EXCEPTION_DETAIL = PG_EXCEPTION_DETAIL
                                   ,EXCEPTION_HINT = PG_EXCEPTION_HINT
           ;
           RAISE EXCEPTION 'stueckl__do_stueckl_int: %, %, %, %', _aknr, EXCEPTION_TEXT, EXCEPTION_DETAIL, EXCEPTION_HINT;
       END;
   END;
  END $$ LANGUAGE plpgsql;
--

-- Rohmaterialien und Vorprodukte für Stücklisten einfügen
CREATE OR REPLACE FUNCTION tartikel.stueckl__do_romat(
        IN _resid                 varchar,
        IN _aknr                  varchar,
        IN _menge                 numeric,
        IN _mitRomat              boolean,
        IN _mitUngueltigeArtikel  boolean,
        IN _parent                integer,
        IN _parent_stvtrs_dbrid   varchar,
        IN _ebene                 integer,
        IN _kalkVar               boolean DEFAULT FALSE,
        IN _resIsBGCalc           boolean DEFAULT FALSE,
        IN _mitKalku              boolean DEFAULT TRUE
        )
  RETURNS boolean AS $$
  DECLARE r_op6             record;
          myid              integer;
          menge_material    numeric;
          stns_stvtrs_dbrid varchar;
          EXCEPTION_TEXT    varchar;
          EXCEPTION_DETAIL  varchar;
          EXCEPTION_HINT    varchar;
  BEGIN
   BEGIN
    FOR r_op6 IN
        SELECT op6.*, op_lg,
               ( SELECT op_ix
                   FROM opl AS o6opl
                   JOIN art AS op6art ON op6art.ak_nr = o6opl.op_n AND op6art.ak_fertigung
                  WHERE o6opl.op_n = o6_aknr
                    AND CASE WHEN _kalkVar THEN o6opl.op_kalku ELSE o6opl.op_standard END
                )
                AS op6ask, -- ASK des Materials => Vorproduktion
               EXISTS(SELECT true FROM stv WHERE st_zn = o6_aknr)
                AS stvart -- Material hat Stückliste
          FROM opl
          JOIN art ON ak_nr = op_n AND ak_fertigung
          JOIN op6 ON o6_ix = op_ix
         WHERE op_n = _aknr
           AND CASE WHEN _kalkVar THEN op_kalku ELSE op_standard END
/*STATUS#20827...*/
           AND NOT TSystem.ENUM_ContainsValue( o6_stat, 'STR,BK,AM' ) -- alternative MatPos herausfiltern, siehe #1538
    LOOP
        --RAISE NOTICE '1:%;2:%;3:%', r_op6.o6_aknr, r_op6.stvart, r_op6.op6ask;
        myid := nextval('stvtrsid_seq'::text);
        -- Berücksichtigung pro Los, pro Stück
        menge_material := r_op6.o6_m_uf1 * CASE WHEN r_op6.o6_m_stat = 1 THEN TArtikel.LosFaktor(_menge, r_op6.op_lg) ELSE _menge END; -- pro Los => mal LosFaktor (91 Stk Fertigungsmenge, ASK-Los 10 => 10 mal), pro Stück => mal Fertigungsmenge)

        -- Aktuelle Ebene eintragen.
        IF _mitRomat
           OR r_op6.op6ask IS NOT NULL
           OR r_op6.stvart
        THEN -- vorfertigungen werden (analog einer Stückliste) immer aufgelöst!
            INSERT INTO stvtrs(id, resid, parent, parent_stvtrs_dbrid, aknr, askix, stm, stmgc, romat, romat_o6_id, romatp, ebene, kalku)
            VALUES (myid, _resid, _parent, _parent_stvtrs_dbrid, r_op6.o6_aknr, r_op6.op6ask, menge_material, r_op6.o6_mce, r_op6.op6ask IS NULL AND NOT r_op6.stvart, -- als Rohmaterial(romat), wenn keine ASK und keine Stückliste
                r_op6.o6_id, r_op6.o6_artpr, _ebene, _mitKalku) RETURNING dbrid INTO stns_stvtrs_dbrid;
        END IF;

        -- Strukturelement weiter auflösen.
        -- Vorprodukt, welches als Beistellung durch Kunden gekennzeichnet ist, ausschließen, siehe #11313.
/*STATUS#20827...*/
        IF NOT TSystem.ENUM_ContainsValue( r_op6.o6_stat, 'STR,BK,KS,AM' ) THEN
            IF r_op6.stvart THEN -- prüfen ob Vorfertigung eine Stückliste ist
                PERFORM tartikel.stueckl__do_stueckl_int(_resid, r_op6.o6_aknr, menge_material, true, _mitUngueltigeArtikel, myid, stns_stvtrs_dbrid, _ebene+1, False /*IsRohmat*/, NULL/*mainArtikelASK(NULL)*/, _kalkVar, _resIsBGCalc, _mitKalku); -- Vorfertigung auflösen
            END IF;
            -- Rohmaterialien eintragen.
            IF r_op6.op6ask IS NOT NULL THEN -- prüfen ob Vorfertigung evtl. eine andere ASK ist
                PERFORM tartikel.stueckl__do_romat(_resid, r_op6.o6_aknr, menge_material, _mitRomat, _mitUngueltigeArtikel, myid, _parent_stvtrs_dbrid, _ebene+1, _kalkVar, _resIsBGCalc, _mitKalku);
                IF _mitKalku THEN -- Nur bei Kalkulation, nicht bei nur Auflösen
                  PERFORM tartikel.stueckl__calc_parent(_resid, _parent); -- In Rekursion die Kosten des Vorprodukts nach oben geben
                END IF;
            END IF;
        END IF;
    END LOOP;

    RETURN true;

   EXCEPTION WHEN OTHERS THEN
       BEGIN
           GET STACKED DIAGNOSTICS EXCEPTION_TEXT = MESSAGE_TEXT
                                  ,EXCEPTION_DETAIL = PG_EXCEPTION_DETAIL
                                  ,EXCEPTION_HINT = PG_EXCEPTION_HINT
           ;
           RAISE EXCEPTION 'stueckl__do_romat: %, %, %, %', _aknr, EXCEPTION_TEXT, EXCEPTION_DETAIL, EXCEPTION_HINT;
       END;
   END;
  END $$ LANGUAGE plpgsql;
--

-- Berechnet und schreibt die Ergebnisse der childs zurück in parent.
-- Option _main ist für direkte Berechnung des Hauptartikels. Insbesondere wichtig für einfache Artikel nur mit ASK (ohne Stückliste oder Vorprodukte), s.u..
CREATE OR REPLACE FUNCTION tartikel.stueckl__calc_parent(_resid VARCHAR, _parent INTEGER, _main BOOLEAN DEFAULT false) RETURNS VOID AS $$
  DECLARE _fixpreise bool = TSystem.Settings__GetBool('bgcalc_vkpfix:'||current_user, true);
  BEGIN
    /*RAISE NOTICE '%>countut=%>romabg=%>roma=%', _parent, count(1) FROM stvtrs WHERE resid=_resid AND parent=0,
                                                        SUM(romabg) FROM stvtrs WHERE resid=_resid AND parent=0,
                                                          SUM(roma) FROM stvtrs WHERE resid=_resid AND parent=0;*/

    -- Baugruppe: BEACHTE askix: darüber wird bestimmt, ob und wie Unterbauteile summiert werden, Bachte Stückliste mit Beistellung (Kaufteil - Stückliste)

    UPDATE stvtrs SET
                      vkpbasbg =    COALESCE(IFTHEN(_fixpreise, ak_vkpbasfix*stm, NULL)
                                                    ,NullIf((COALESCE((SELECT MAX(COALESCE(vkpbasbg, vkpbas)) FROM stvtrs s1 WHERE s1.parent=stvtrs.id AND s1.optart AND s1.resid=stvtrs.resid AND NOT s1.romat AND stv_str_revnr IS NULL),0)
                                                            +COALESCE((SELECT SUM(COALESCE(vkpbasbg, vkpbas)) FROM stvtrs s1 WHERE s1.parent=stvtrs.id AND NOT s1.optart AND s1.resid=stvtrs.resid AND NOT s1.romat AND stv_str_revnr IS NULL),0)
                                                            +IFTHEN(askix IS NULL, 0, vkpbas)
                                                            )
                                                            ,0
                                                           )
                                             , vkpbas
                                            ),
                      selbstkobg =  COALESCE(IFTHEN(_fixpreise, ak_vkpbasfix*stm/COALESCE(nullif(ak_vkpfaktor, 0), nullif(ac_vkpfaktor, 0), 1),NULL)
                                             ,NullIf((COALESCE((SELECT MAX(COALESCE(selbstkobg, selbstko)) FROM stvtrs s1 WHERE s1.parent=stvtrs.id AND s1.optart AND s1.resid=stvtrs.resid AND NOT s1.romat AND stv_str_revnr IS NULL),0)
                                                     +COALESCE((SELECT SUM(COALESCE(selbstkobg, selbstko)) FROM stvtrs s1 WHERE s1.parent=stvtrs.id AND NOT s1.optart AND s1.resid=stvtrs.resid AND NOT s1.romat AND stv_str_revnr IS NULL),0)
                                                     +IFTHEN(askix IS NULL, 0, selbstko)
                                                     )
                                                    ,0
                                                    )
                                             , selbstko
                                            ),
                      romabg =      COALESCE(
                                             NullIf((COALESCE((SELECT MAX(COALESCE(romabg, roma)) FROM stvtrs s1 WHERE s1.parent=stvtrs.id AND s1.optart AND s1.resid=stvtrs.resid AND NOT s1.romat AND stv_str_revnr IS NULL),0)
                                                    +COALESCE((SELECT SUM(COALESCE(romabg, roma)) FROM stvtrs s1 WHERE s1.parent=stvtrs.id AND NOT s1.optart AND s1.resid=stvtrs.resid AND NOT s1.romat AND stv_str_revnr IS NULL),0)
                                                    +IFTHEN(askix IS NULL, 0, roma)
                                                    )
                                                   ,0
                                                   )
                                             , roma
                                            ),
                      montagebg =   COALESCE(
                                             NullIf((COALESCE((SELECT MAX(COALESCE(montagebg, montage)) FROM stvtrs s1 WHERE s1.parent=stvtrs.id AND s1.optart AND s1.resid=stvtrs.resid AND NOT s1.romat AND stv_str_revnr IS NULL),0)
                                                    +COALESCE((SELECT SUM(COALESCE(montagebg, montage)) FROM stvtrs s1 WHERE s1.parent=stvtrs.id AND NOT s1.optart AND s1.resid=stvtrs.resid AND NOT s1.romat AND stv_str_revnr IS NULL),0)
                                                    +IFTHEN(askix IS NULL, 0, montage)
                                                    )
                                                    ,0
                                                   )
                                             , montage
                                            ),
                      ruestbg =     COALESCE(
                                             NullIf((COALESCE((SELECT MAX(COALESCE(ruestbg, ruest)) FROM stvtrs s1 WHERE s1.parent=stvtrs.id AND s1.optart AND s1.resid=stvtrs.resid AND NOT s1.romat AND stv_str_revnr IS NULL),0)
                                                    +COALESCE((SELECT SUM(COALESCE(ruestbg, ruest)) FROM stvtrs s1 WHERE s1.parent=stvtrs.id AND NOT s1.optart AND s1.resid=stvtrs.resid AND NOT s1.romat AND stv_str_revnr IS NULL),0)
                                                    +IFTHEN(askix IS NULL, 0, ruest)
                                                    )
                                                    ,0
                                                   )
                                             , ruest
                                            ),
                      auswaertsbg = COALESCE(
                                             NullIf((COALESCE((SELECT MAX(COALESCE(auswaertsbg, auswaerts)) FROM stvtrs s1 WHERE s1.parent=stvtrs.id AND s1.optart AND s1.resid=stvtrs.resid AND NOT s1.romat AND stv_str_revnr IS NULL),0)
                                                    +COALESCE((SELECT SUM(COALESCE(auswaertsbg, auswaerts)) FROM stvtrs s1 WHERE s1.parent=stvtrs.id AND NOT s1.optart AND s1.resid=stvtrs.resid AND NOT s1.romat AND stv_str_revnr IS NULL),0)
                                                    +IFTHEN(askix IS NULL, 0, auswaerts)
                                                    )
                                                    ,0
                                                   )
                                             , auswaerts
                                            )
      FROM art JOIN artcod ON ak_ac=ac_n
     WHERE resid=_resid AND stm>0 AND stv_str_revnr IS NULL AND ak_nr=aknr -- Summe Unterbauteile laden
       AND (
            (   NOT _main -- Standard für Artikel mit Unterbauteilen
                AND parent=_parent
                AND EXISTS(SELECT true FROM stvtrs s1 WHERE s1.parent=stvtrs.id AND s1.resid=stvtrs.resid AND NOT romat AND stv_str_revnr IS NULL)
            ) OR ( -- den Kopfartikel zusammenrechnen. Dies passiert mit Option _main, da der Kopfartikel inkl. Unterartikel in einem Durchlauf und nicht rekursiv gemacht wird. Daher müssen zuerst die direkten Unterartikel BGCalc durchgeführt werden und dann das Ergebnis im Kopfartikel übernommen werden.
                _main AND id=_parent AND _parent=0 -- wenn der Artikel keine Unterteile hat, muss für bg_calc trotzdem das feld baugruppenkosten gefüllt sein!
            )
           );
    RETURN;
  END $$ LANGUAGE plpgsql VOLATILE STRICT;
--

--
CREATE OR REPLACE FUNCTION tartikel.stueckl__mostexpensive(VARCHAR) RETURNS SETOF VARCHAR AS $$
  DECLARE myrow RECORD;
  BEGIN
    FOR myrow IN SELECT aknr FROM stvtrs WHERE resid=$1 GROUP BY aknr ORDER BY sum(selbstko) DESC LIMIT 10 LOOP
        RETURN NEXT myrow.aknr;
    END LOOP;
    RETURN;
  END $$ LANGUAGE plpgsql STABLE RETURNS NULL ON NULL INPUT;
--

--
CREATE OR REPLACE FUNCTION tartikel.stueckl__stvtrs_konstrstv_get_parent(IN_stvtrs_dbrid VARCHAR, recursive BOOL, OUT parent_stid INTEGER, OUT parent_stvtrs_dbrid VARCHAR) RETURNS SETOF RECORD AS $$
 DECLARE r RECORD;
 BEGIN
   SELECT stvtrsp.dbrid, st_id INTO parent_stvtrs_dbrid, parent_stid -- AND COALESCE(stv_str_revnr,'')='';
    FROM stvtrs stvtrsp JOIN stvtrs stvtrsc ON stvtrsp.dbrid=stvtrsc.parent_stvtrs_dbrid
                        JOIN stv ON stv.dbrid=stvtrsp.stv_dbrid --Achtung, durch diesen Join wird die stvtrsdbrid des root nie zurückgegeben. der root haut keine stv und damit weg
    WHERE stvtrsc.dbrid=IN_stvtrs_dbrid;
   --
   IF FOUND THEN
    RETURN next;
   END IF;
   --
   IF recursive AND parent_stvtrs_dbrid IS NOT NULL THEN
      FOR r IN SELECT * FROM tartikel.stueckl__stvtrs_konstrstv_get_parent(parent_stvtrs_dbrid, true) LOOP
            parent_stid:=r.parent_stid;
            parent_stvtrs_dbrid:=r.parent_stvtrs_dbrid;
            RETURN NEXT;
      END LOOP;
   END IF;
   --
   RETURN;
 END $$ LANGUAGE plpgsql STABLE STRICT;
--

--Konstruktions/Fertigungsstückliste: Anzeige, wenn ich in einer Fertigungsstückliste verbaut werde, oder wenn ich Fertigungsstückliste bin, aus welcher Konstruktionsstückliste meine Teile kommen
-- http://redmine.prodat-sql.de/projects/prodat-v-x/wiki/Art
CREATE OR REPLACE FUNCTION tartikel.stueckl__fertstv_get_konstrstv_ident(IN_st_kstv_st_id INTEGER) RETURNS VARCHAR(100) AS $$
 BEGIN
  RETURN st_zn||'~P.'||st_pos :: VARCHAR(100) FROM stv su WHERE su.st_id=IN_st_kstv_st_id AND (tartikel.art__artikelstatus__by__ak_nr(su.st_zn)).artstatus = 'G';
 END $$ LANGUAGE plpgsql STABLE;
--

--Semm-Separierte Liste: wenn ein Konstruktionsartikel 5 mal, kann dieser in 5 verschiedenen Montagestufen=Fertigungsstücklisten verbaut werden
--Semm-separierte Liste von Fertigungsstücklisten
--Variantenstücklisten
-->> http://redmine.prodat-sql.de/projects/prodat-v-x/wiki/Art
CREATE OR REPLACE FUNCTION tartikel.stueckl__konstrstv_get_fertstv_usage(IN_st_id INTEGER, IN vererben_my_stvtrs_dbrid VARCHAR DEFAULT NULL) RETURNS VARCHAR AS $$
 DECLARE result VARCHAR;
         my_stvvari_array VARCHAR[]; --hält array_agg der eigenen ebene. wichtig für vererbung um den Array mit den übergeordneten elementen vergleichen zu können
         result_tmp VARCHAR;
         r RECORD;
         stvtrsrec RECORD;
 BEGIN
  --Konstruktions/Fertigungsstückliste
  result := string_agg(DISTINCT st_zn, ';') FROM stv su WHERE su.st_kstv_st_id=IN_st_id AND (tartikel.art__artikelstatus__by__ak_nr(su.st_zn)).artstatus = 'G';
  --Variantenstücklisten
   --erstens: unsere eigenen varianten suchen.
   my_stvvari_array := array_agg(DISTINCT stvv_v) FROM stv_vari WHERE stvv_st_id=IN_st_id;
   --
   --zweitens: wenn wir abhängig von der Baumstruktur sind, dann sind unsere eigenen Varianten nur gültig, wenn die Parents auch die Varianten enthalten
   --weiterhin hat der Kopfartikel automatisch alle Varianten der ersten position
   IF vererben_my_stvtrs_dbrid IS NOT NULL THEN
        --
        SELECT parent_stvtrs_dbrid, id, parent, dbrid INTO stvtrsrec FROM stvtrs WHERE dbrid=vererben_my_stvtrs_dbrid;
        --
        FOR r IN SELECT (SELECT array_agg(stvv_v) AS parentarr FROM stv_vari WHERE stvv_st_id=parent_stid) /*id's aller Parents aus der rekursiven Funktion*/
                    FROM tartikel.stueckl__stvtrs_konstrstv_get_parent(vererben_my_stvtrs_dbrid, True) LOOP
                 --alle vorgänger durchlaufen. wir selbst sind nur gültig, wenn alle vorgänger uns selbst enthalten
                 my_stvvari_array:=array_agg(unnest) FROM (SELECT unnest(my_stvvari_array) INTERSECT SELECT unnest(r.parentarr)) AS t;
        END LOOP;
        --
        --drittens: der oberste Knoten erbt immer die ebene 0, da er selbst nie eine Option ist
        IF (stvtrsrec.parent IS NULL) THEN --rootnode
           --gehe nach unten durch und hole die Optionen von den unteren. Nur notwendig für Kopfebene, da diese als einzige selbst keine Optionen enthält
           result_tmp:=string_agg(DISTINCT tartikel.stueckl__konstrstv_get_fertstv_usage(st_id), ';')::VARCHAR
                       FROM stvtrs JOIN stv ON stv.dbrid=stv_dbrid
                       WHERE parent_stvtrs_dbrid=vererben_my_stvtrs_dbrid; --wir selbst sind der parent der ersten ebene
           result := concat_ws(';', result, result_tmp);
        END IF;
   END IF;
   --übriggebliebenen array im falle von manipulation ist der gänert wurden nun in einen string überführen
   result := concat_ws(';', result, array_to_string(my_stvvari_array, ';'));
   --Record zusammenfassen
   SELECT string_agg(unnest,';') INTO result FROM (SELECT DISTINCT unnest::VARCHAR FROM unnest(string_to_array(result, ';'))
           WHERE COALESCE(unnest,'')<>'' ORDER BY unnest) AS t WHERE unnest IS NOT NULL;
   --Result richtige Ausgabesyntax
    IF result='' THEN
       result:=NULL;
    END IF;
    --
    IF result<>'' THEN
       result:=result||';'; --Achtung, schliessendes Semmikolon wichtig wegen Filter im ABK auslössen (LIKE %;) > siehe Delphi: TFormAbkSelect
    END IF;
   --
  --Varianten
  RETURN result;
 END $$ LANGUAGE plpgsql STABLE;
--

-- Liste der IDs und Nummern aller Stücklistenrevisionen, includeCurrent=true -> Ergänzt per Union um 'Aktuell' Eintrag für noch nicht revisionierten Arbeitsstand
CREATE OR REPLACE FUNCTION TArtikel.Stueckl__Get_Revisionen(IN resid VARCHAR(50), IN includeCurrent BOOLEAN DEFAULT TRUE, OUT str_id INTEGER, OUT str_revnr VARCHAR(40) ) RETURNS SETOF RECORD AS $$
 DECLARE rec RECORD;
 BEGIN
   FOR rec IN SELECT * FROM (      SELECT -1 AS id, lang_text(26057) AS str_revnr                              -- Aktuelle Stückliste, noch nicht als Revision abgelegt / archiviert und daher ohne Revisionnummer
                             UNION SELECT str.str_id, str.str_revnr FROM stvrevision str WHERE str_resid=resid -- Abgelegte Revisionen zu dem Artikel
                            ) AS strData
              WHERE includeCurrent OR (id >=0)
              ORDER BY str_id LOOP
     str_id:= rec.id;
     str_revnr:= rec.str_revnr;
     RETURN NEXT;
   END LOOP;
   RETURN;
 END $$ LANGUAGE plpgsql;
--

-- Vergleichsfunktion für Stücklisten und Revisionen
  -- DROP FUNCTION IF EXISTS TArtikel.Stueckl__Compare(VARCHAR,VARCHAR,VARCHAR,VARCHAR,integer,integer, boolean);
CREATE OR REPLACE FUNCTION TArtikel.Stueckl__Compare(
   IN resid1       VARCHAR,                -- Artikelnummer laut Stücklisten-Revisionstabelle (stvrevision.resid)
   IN revNr1       VARCHAR,                -- Revisions-Nr. laut Stücklisten-Revisionstabelle (stvrevision.stv_str_revnr)
   IN resid2       VARCHAR,
   IN revNr2       VARCHAR,
   IN ebenenanzahl INTEGER DEFAULT 1,      -- 1 = Artikel unter Kopfartikel, 2 = Artikel unter Kopfartikel und deren Unterartikel ...
   IN compareMode  INTEGER DEFAULT 0,      -- 0 = Struktur+Mengenvergleiche, 1 = Mengenübersichts-Stückliste aufsummiert
   IN mitRohmat     BOOLEAN DEFAULT false, -- Flag ob Rohmaterialeinträge verglichen werden sollen
   --
   OUT cmpState     VARCHAR,                -- Änderungsstatus
   OUT lAknr        VARCHAR,                -- Artikel auf 'linker Seite' aus ResID1 | RevNr1
   OUT lDbrids      VARCHAR[],              -- DBrids der Stvtrs-Datensätze, mehrere da der Artikel in einem Parentknoten mehrfach enthalten sein kann
   OUT rAknr        VARCHAR,                -- Artikel auf 'rechter Seite'
   OUT rDbrids      VARCHAR[]               -- DBrids der Stvtrs-Datensätze, mehrere da der Artikel in einem Parentknoten mehrfach enthalten sein kann
   ) RETURNS SETOF RECORD AS $$

   DECLARE ls        RECORD;    -- Linke Seite des Vergleichs, die Stückliste mit der verglichen werden soll, z.Bsp. aktuelle Version
     rs        RECORD;    -- Rechte Seite, die zu vergleichende Stückliste, z.Bsp. eine ältere Revision
           foundIDs  VARCHAR[]; -- Dbrids der rechten Seite, die wir beim Vergleich mit der linken Seite wiedergefunden haben
           lData     TEXT;      -- Konkatenierte Feld-Inhalte die verglichen werden sollen
           rData     TEXT;
   BEGIN
   
     -- Ansatz ist Aufsummieren und Gruppieren über Artikel die zu einem bestimmten Parent-Knoten gehören.
     -- Beispiel: Zu einem Gehäuse gehören 8 Schrauben. Es ist egal ob das Position 10 oder auch 2x4 Schrauben sind,
     -- solange der Parent-Artikel in beiden Stücklisten das Gehäuse ist.
     IF compareMode = 0 THEN
   
       -- Alle Artikel der 'linken' Seite nach Parent-Knoten aufsummiert durchlaufen
       FOR ls IN SELECT ebene, parent_stvtrs_dbrid, parent_aknr, aknr, SUM(stm) AS menge, stmgc, Array_Agg (stvtrs.dbrid) AS dbrids,
                        String_Agg( IfThen (romat, 'MAT', COALESCE(pos,0)::VARCHAR), '|' ORDER BY pos) AS pos
                 FROM stvtrs LEFT JOIN LATERAL ( SELECT aknr AS parent_aknr, dbrid FROM stvtrs ) AS ptrs ON pTrs.dbrid = parent_stvtrs_dbrid
                 WHERE (resid = resid1)
                   AND (COALESCE(stv_str_revnr,'') = COALESCE(revNr1,''))
                   AND (ebene+1 <= ebenenanzahl)
                   AND (MitRohmat OR NOT romat )
                 GROUP BY ebene, parent_stvtrs_dbrid, parent_aknr, aknr, stmgc
       LOOP
   
         rs := NULL;
         -- Prüfen ob es den auf der 'rechten' Seite ebenfalls gibt. Wir tolerieren Indexänderungen des Parentartikels und des Unterteils
         SELECT ebene, parent_stvtrs_dbrid, parent_aknr, aknr, SUM(stm) AS menge, stmgc, Array_Agg (stvtrs.dbrid) AS dbrids,
                String_Agg( IfThen (romat, 'MAT', COALESCE(pos,0)::VARCHAR), '|' ORDER BY pos) AS pos
         INTO rs
         FROM stvtrs LEFT JOIN LATERAL ( SELECT aknr AS parent_aknr, dbrid FROM stvtrs ) AS ptrs ON pTrs.dbrid = parent_stvtrs_dbrid
         WHERE (resid = resid2)
                   AND (COALESCE(stv_str_revnr,'') = COALESCE(revnr2,''))
                     -- Das Unterteil muss auf beiden Seiten am gleichen Parentartikel hängen ...
                   AND ( (tartikel.art__ak_nr__index(COALESCE(parent_aknr,''),FALSE)= tartikel.art__ak_nr__index(COALESCE(ls.parent_aknr,''),FALSE))
                     -- ... oder wir haben es mit den Elementen erster Ebene zu tun. Dann darf der Parent unterschiedlich sein, wir wollen die vom Parent aufgespannten Bäume ja miteinander vergleichen.
                      OR ( (ebene = 0) AND (ls.ebene=0)) )
                   AND (ebene = ls.ebene)
                   AND (tartikel.art__ak_nr__index(aknr,FALSE) = tartikel.art__ak_nr__index(ls.aknr,FALSE))
                   AND (ebene+1 <= ebenenanzahl)
                   AND (MitRohmat OR NOT romat )
         GROUP BY ebene, parent_stvtrs_dbrid, parent_aknr, aknr, stmgc;
   
         -- Datensätze merken, die wir aus der 'rechtsseitigen' Stückliste matchen konnten ...
         IF array_length(rs.dbrids,1) > 0 THEN
           foundIDs:=foundIDs || rs.dbrids;
         END IF;
   
         -- Artikel über Artikelnummer, Menge und Mengeneinheit vergleichen
         lData := Concat_ws('<!>', COALESCE(ls.aknr,''), COALESCE(ls.menge::TEXT,''), COALESCE(ls.stmgc::TEXT,''));
         rData := Concat_ws('<!>', COALESCE(rs.aknr,''), COALESCE(rs.menge::TEXT,''), COALESCE(rs.stmgc::TEXT,''));
   
         cmpState := CASE WHEN rs.aknr IS NULL                             THEN 'dsNew'
                          WHEN ((lData = rData) AND (ls.pos = rs.Pos))     THEN 'dsEqual'
                          WHEN ((lData = rData) AND (ls.pos <> rs.Pos))    THEN 'dsChangedPos'
                          WHEN ((lData <> rData) AND (ls.aknr = rs.aknr))  THEN 'dsChangedMenge'
                          WHEN ((lData <> rData) AND (ls.aknr <> rs.aknr)) THEN 'dsChangedRevision'
                     ELSE 'dsError'
                     END;
         lAknr:=ls.Aknr; lDbrids:=ls.Dbrids; rAknr:=rs.Aknr; rDbrids:=rs.Dbrids;
         RETURN NEXT;
   
       END LOOP;
   
       -- Prüfen ob wir auf der 'rechten' Seite Artikel hatten, die wir noch nicht erwischt haben ...
       FOR rs IN SELECT ebene, parent_stvtrs_dbrid, parent_aknr, aknr, SUM(stm) AS menge, stmgc, Array_Agg (stvtrs.dbrid) AS dbrids
                FROM stvtrs LEFT JOIN LATERAL ( SELECT aknr AS parent_aknr, dbrid FROM stvtrs ) AS ptrs ON pTrs.dbrid = parent_stvtrs_dbrid
                WHERE (resid = resid2)
                   AND (COALESCE(stv_str_revnr,'') = COALESCE(revnr2,''))
                   AND (ebene+1 <= ebenenanzahl)
                   AND (MitRohmat OR NOT romat )
                   AND NOT (stvtrs.Dbrid = ANY(foundIDs))
                    GROUP BY ebene, parent_stvtrs_dbrid, parent_aknr, aknr, stmgc
       LOOP
         cmpState:='dsDeleted'; lAknr:=NULL; lDbrids:=NULL; rAknr:=rs.Aknr; rDbrids:=rs.Dbrids;
         RETURN NEXT;
       END LOOP;
     END IF;/*  */
   
     -- Ansatz ist Aufsummieren und Gruppieren über Artikel der gesamten Stückliste. Alle Knoten / Unterknoten aufsummiert, wie bei der Mengenübersichtsstückliste ...
     IF compareMode = 1 THEN
   
       FOR ls IN SELECT aknr, SUM(stm) AS menge, stmgc, Array_Agg (stvtrs.dbrid) AS dbrids FROM stvtrs
                 WHERE (resid = resid1) AND (COALESCE(stv_str_revnr,'') = COALESCE(revNr1,''))
                   AND (ebene+1 <= ebenenanzahl)
                   AND (MitRohmat OR NOT romat )
                 GROUP BY aknr, stmgc
       LOOP
   
         -- Prüfen ob es den auf der 'rechten' Seite ebenfalls gibt.
         SELECT aknr, SUM(stm) AS menge, stmgc, Array_Agg (stvtrs.dbrid) AS dbrids INTO rs FROM stvtrs
         WHERE (resid = resid2) AND (COALESCE(stv_str_revnr,'') = COALESCE(revnr2,''))
           AND (ebene+1 <= ebenenanzahl)
           AND (MitRohmat OR NOT romat )
           AND (tartikel.art__ak_nr__index(aknr,FALSE) = tartikel.art__ak_nr__index(ls.aknr,FALSE))
         GROUP BY aknr, stmgc;
   
         IF array_length(rs.dbrids,1) > 0 THEN
           foundIDs:=foundIDs || rs.dbrids;
         END IF;
   
         lData := Concat_ws('<!>', COALESCE(ls.aknr,''), COALESCE(ls.menge::TEXT,''), COALESCE(ls.stmgc::TEXT,''));
         rData := Concat_ws('<!>', COALESCE(rs.aknr,''), COALESCE(rs.menge::TEXT,''), COALESCE(rs.stmgc::TEXT,''));
   
         cmpState := CASE WHEN rs.aknr IS NULL                           THEN 'dsNew'
                        WHEN ((lData <> rData) AND (ls.aknr = rs.aknr))  THEN 'dsChangedMenge'
                        WHEN ((lData <> rData) AND (ls.aknr <> rs.aknr)) THEN 'dsChangedRevision'
                        WHEN lData = rData                               THEN 'dsEqual'
                     ELSE 'dsError'
                     END;
   
         lAknr   := ls.Aknr;
         lDbrids := ls.Dbrids;
         rAknr   := rs.Aknr;
         rDbrids := rs.Dbrids;
   
         RETURN NEXT;
       END LOOP;
   
       -- Prüfen ob wir auf der 'rechten' Seite Artikel hatten, die wir noch nicht erwischt haben ...
       FOR rs IN SELECT aknr, SUM(stm) AS menge, stmgc, Array_Agg (stvtrs.dbrid) AS dbrids FROM stvtrs
                WHERE (resid = resid2) AND (COALESCE(stv_str_revnr,'') = COALESCE(revnr2,''))
                   AND (ebene+1 <= ebenenanzahl)
                   AND (MitRohmat OR NOT romat )
                   AND NOT (stvtrs.Dbrid = ANY(foundIDs))
                GROUP BY aknr, stmgc
       LOOP
         cmpState:='dsDeleted'; lAknr:=NULL; lDbrids:=NULL; rAknr:=rs.Aknr; rDbrids:=rs.Dbrids;
         RETURN NEXT;
       END LOOP;
   
     END IF;
   
     RETURN;
   END $$ LANGUAGE plpgsql;
--
--- #11447 Kopierfunktion Stüli von Stückliste-Revision
CREATE OR REPLACE FUNCTION TArtikel.Stv__Copy(IN _stzn VARCHAR, IN _new_stzn VARCHAR, IN _append_pos INTEGER, IN _chkAppend BOOLEAN, IN _revnr VARCHAR DEFAULT null) RETURNS BOOLEAN AS $$
  DECLARE   result     BOOLEAN := false;
        myCount    INTEGER;
  BEGIN
    DROP TABLE IF EXISTS stv_copy;
    IF _revnr IS NULL OR UPPER(_revnr) = 'AKTUELL' THEN

        CREATE TEMP TABLE stv_copy (LIKE stv);
        -- Quellartikel
        INSERT INTO stv_copy SELECT * FROM stv WHERE st_zn=_stzn ORDER BY st_pos;
        DROP SEQUENCE IF EXISTS stv_tmp_seq_pos;
        CREATE TEMP SEQUENCE stv_tmp_seq_pos INCREMENT 10 MINVALUE 0 START WITH 10;
        PERFORM setval('stv_tmp_seq_pos', COALESCE(_append_pos, max(st_pos), 0)::SMALLINT) FROM stv WHERE st_zn=_new_stzn;
        -- auf Zielartikel und gewünschte Position setzen
        UPDATE stv_copy SET st_id=nextval('stv_st_id_seq'), st_pos=IFTHEN(_chkAppend, nextval('stv_tmp_seq_pos'), st_pos), st_zn=_new_stzn, dbrid=nextval('db_id_seq');
        -- Wenn angehängt wird (nach best. Position), Daten des Zielartikel vor gewünschte Position kopieren.
        INSERT INTO stv_copy SELECT * FROM stv WHERE st_zn=_new_stzn AND st_pos <= COALESCE(_append_pos, (SELECT max(st_pos) FROM stv WHERE st_zn=_new_stzn)) AND _chkAppend ORDER BY st_pos;
        -- Dementspr. Rest nach gewünschter Position.

        INSERT INTO stv_copy(st_id, st_zn, st_n, st_pos, st_mgc, st_m, st_m_uf1, st_m_fix, st_txt, st_ekenner_krz, dbrid, insert_by, insert_date, modified_by, modified_date)
          SELECT st_id, st_zn, st_n, nextval('stv_tmp_seq_pos') AS st_pos, st_mgc, st_m, st_m_uf1, st_m_fix, st_txt, st_ekenner_krz, dbrid, insert_by, insert_date, modified_by, modified_date
          -- Nach Position vorsortieren
          FROM (SELECT * FROM stv WHERE st_zn=_new_stzn AND st_pos > _append_pos AND _chkAppend AND _append_pos IS NOT NULL ORDER BY st_pos) AS sub;
          -- Daten übergeben
        DELETE FROM stv WHERE st_zn=_new_stzn;
        INSERT INTO stv SELECT * FROM stv_copy;
    ELSE  --- Kopie von Revision
      DROP SEQUENCE IF EXISTS stv_tmp_seq_pos;
        CREATE TEMP SEQUENCE stv_tmp_seq_pos INCREMENT 10 MINVALUE 0 START WITH 10;
        PERFORM setval('stv_tmp_seq_pos', COALESCE(_append_pos, max(st_pos), 0)::SMALLINT) FROM stv WHERE st_zn=_new_stzn;
      IF NOT _chkAppend THEN
          PERFORM setval('stv_tmp_seq_pos', 0);
          DELETE FROM stv WHERE st_zn = _new_stzn;
            INSERT INTO stv(st_zn    , st_n, st_pos                    , st_mgc, st_m, st_m_uf1                                               , insert_by   , insert_date , modified_by , modified_date)
              SELECT        _new_stzn, aknr, nextval('stv_tmp_seq_pos'), stmgc , stm , ROUND(tartikel.me__menge__in__menge_uf1(stmgc, stm), 2), current_user, current_date, current_user, current_date
              FROM (SELECT * FROM stvtrs WHERE resid iLIKE _stzn AND stv_str_revnr iLIKE _revnr AND NOT romat AND resid NOT iLIKE aknr AND ebene < 2 ORDER BY pos) AS sub;
      ELSE
          IF _append_pos > 0 THEN  --- st_pos überschreiben
            SELECT COUNT(*) INTO myCount FROM stvtrs WHERE resid iLIKE _stzn AND stv_str_revnr iLIKE _revnr AND NOT romat AND resid NOT iLIKE aknr AND ebene < 2;
            UPDATE stv SET st_pos = st_pos + ((myCount ) * 10) WHERE st_zn = _new_stzn AND st_pos > _append_pos;
            END IF;
            INSERT INTO stv(st_zn    , st_n, st_pos                    , st_mgc, st_m, st_m_uf1                                               , insert_by   , insert_date , modified_by , modified_date)
              SELECT        _new_stzn, aknr, nextval('stv_tmp_seq_pos'), stmgc , stm , ROUND(tartikel.me__menge__in__menge_uf1(stmgc, stm), 2), current_user, current_date, current_user, current_date
              FROM (SELECT * FROM stvtrs WHERE resid iLIKE _stzn AND stv_str_revnr iLIKE _revnr AND NOT romat AND resid NOT iLIKE aknr AND ebene < 2 ORDER BY pos) AS sub;
      END IF;
    END IF;
    result := true;
    RETURN result;
 END $$ LANGUAGE plpgsql;
---

CREATE OR REPLACE FUNCTION tartikel.ksv__ks_copy_exact__is(IN _ksv ksv) RETURNS boolean
  AS $$
    SELECT _ksv.ks_copy_exact IS true -- damit NULL false
  $$ LANGUAGE sql STABLE PARALLEL SAFE;

CREATE OR REPLACE FUNCTION tartikel.ksv__ks_copy_exact__is(IN _ks_abt varchar) RETURNS boolean
  AS $$
    SELECT (SELECT ks_copy_exact FROM ksv WHERE ks_abt = _ks_abt ) IS true -- damit NULL false
  $$ LANGUAGE sql STABLE PARALLEL SAFE;

CREATE OR REPLACE FUNCTION tartikel.ks_copy_exact__is(IN _op2 op2) RETURNS boolean
  AS $$
    SELECT tartikel.ksv__ks_copy_exact__is(_op2.o2_ks);
  $$ LANGUAGE sql STABLE PARALLEL SAFE;

CREATE OR REPLACE FUNCTION tartikel.ks_copy_exact__is(IN _ab2 ab2) RETURNS boolean
  AS $$
    SELECT tartikel.ksv__ks_copy_exact__is(_ab2.a2_ks);
  $$ LANGUAGE sql STABLE PARALLEL SAFE; 


/*Kosten Stücklistenauflösung*/

-- Fertigungszeiten
CREATE OR REPLACE FUNCTION tartikel.ask_fertzeit(opix INTEGER, anzahl NUMERIC) RETURNS NUMERIC AS $$
  BEGIN
    RETURN ROUND((SELECT SUM(COALESCE(o2_tr_sek, 0)) / 3600 + SUM((o2_th_sek + o2_tn_sek) * anzahl * (1 + COALESCE(o2_tv, 0) / 100) / 3600) FROM op2 WHERE o2_ix = opix), 4);
  END $$ LANGUAGE plpgsql STABLE STRICT;
--



CREATE OR REPLACE FUNCTION tartikel.ask_ksbelast(opix INTEGER, anzahl NUMERIC) RETURNS SETOF tartikel.ask_ksbelast_type  AS $$
    DECLARE op2rec RECORD;
            R tartikel.ask_ksbelast_type;
    BEGIN
     FOR op2rec IN SELECT SUM(COALESCE(o2_tr_sek,0))/3600+SUM((o2_th_sek+o2_tn_sek)*anzahl*(1+COALESCE(o2_tv,0)/100)/3600) AS kszeit, o2_ks FROM op2 WHERE o2_ix=opix GROUP BY o2_ks LOOP
            R.ks:=op2rec.o2_ks;
            R.zeit_stu:=CAST(op2rec.kszeit AS NUMERIC(10,2));
            If R.zeit_stu>0 THEN
                    RETURN NEXT R;
            END IF;
     END LOOP;
     RETURN;
    END $$ LANGUAGE plpgsql;


--prüft, ob Artikel Vorproduktion oder Stückliste hat

CREATE OR REPLACE FUNCTION tartikel.has_vorproduktion_stv( _aknr varchar )
  RETURNS bool AS $$
  DECLARE
      _rohmaterialien varchar[] :=
          array_agg( o6_aknr )
          FROM op6
          JOIN opl ON o6_ix = op_ix and op_standard
          WHERE op_n = _aknr
      ;
  BEGIN

      RETURN
          -- Artikel hat selbst eine Stückliste
          EXISTS( SELECT true FROM stv WHERE st_zn = _aknr )

          -- Artikel hat eine Vorproduktion, das heißt:
          --  1. das Rohmaterial enthält ein Vorprodukt einer AVOR
       OR EXISTS( SELECT true FROM opl WHERE op_n = any( _rohmaterialien ) )

          --  2. das Rohmaterial enhält selbst wieder eine Stückliste
       OR EXISTS( SELECT true FROM stv WHERE st_zn = any( _rohmaterialien ) );

  END $$ LANGUAGE plpgsql STABLE PARALLEL SAFE;

-----------------------------------------------------------------------------------------------------
-----------------------------------------------------------------------------------------------------

-- wenn ein Material=Vorprodukt, dann wird dieses zuerst ausgeschlossen
-- wenn Vorprodukt, wird versucht die reinen Materialkosten des Vorprodukts hinzuzuaddieren.
-- o6_m_stat = pro Los oder pro stck

-- Kalkulationsfunktionen jeweils inkl. aller Zwischenwerte
  -- grenz_kost:            Grenzkosten
  -- norm_kost:             Normkosten inkl. Gemeinkosten-Zuschlägen
  -- norm_kost_ohne_gemko:  Normkosten ohne Gemeinkosten-Zuschläge
  -- gemko_proz:            Prozentsatz der Gemeinkosten
  -- gemko_wert:            Wert der Gemeinkosten
  -- sonder_kost:           Sonderkosten

-- ASK-Rüstkosten pro Stück
CREATE OR REPLACE FUNCTION tartikel.op2_rkost_extended(
  IN opix                      integer,
  IN menge                     numeric = null,

  OUT grenz_kost            numeric,
  OUT norm_kost             numeric,
  OUT norm_kost_ohne_gemko  numeric,
  OUT gemko_proz            numeric,
  OUT gemko_wert            numeric,
  OUT sonder_kost           numeric
  ) AS $$
  DECLARE
      oplg        numeric;
      kalk_menge  numeric;
  BEGIN

    -- Rüstkosten/Stück über alle KS/AG mit allen Zwischenwerten

    -- Werte initialisieren
    grenz_kost           := 0;
    norm_kost            := 0;
    norm_kost_ohne_gemko := 0;
    gemko_proz           := 0;
    gemko_wert           := 0;

    -- ohne Angabe von Menge raus
    IF menge = 0 THEN   RETURN;   END IF;

    -- Grenzkosten und Normkosten bestimmen
    -- Sonderkosten weiter unten
    SELECT
      -- Grenzkosten
      sum(
          o2_tr_sek / 3600 -- Rüstzeit (in h)
          * coalesce(ks_gssr, o2_sts, ks_stsr)  -- Grenzkostenstundensatz der KS bevorzugen
                                                -- ohne Rüstgemeinkosten
      ),

      -- Normkosten
      sum(
          o2_tr_sek / 3600 -- Rüstzeit (in h)
          * coalesce(o2_sts, ks_stsr)           -- Stundensatz der Stammkarte vor KS bevorzugen
          * (1 + coalesce(op_rgk, 0) / 100)     -- plus prozentuale Rüstgemeinkosten
      ),

      -- Normkosten ohne Rüstgemeinkosten
      sum(
          o2_tr_sek / 3600 -- Rüstzeit (in h)
          * coalesce(o2_sts, ks_stsr)           -- Stundensatz der Stammkarte vor KS bevorzugen
      ),

      -- Prozentsatz der Rüstgemeinkosten
      coalesce(op_rgk, 0),

      -- Wert der Rüstgemeinkosten
      sum(
          o2_tr_sek / 3600 -- Rüstzeit (in h)
          * coalesce(o2_sts, ks_stsr)           -- Stundensatz der Stammkarte vor KS bevorzugen
          * (coalesce(op_rgk, 0) / 100)         -- prozentuale Rüstgemeinkosten
      )
    FROM op2
      JOIN tartikel.ksv__data__by__table__get( op2 ) ON true
      JOIN opl ON op_ix = o2_ix
    WHERE
          o2_ix = opix
      AND NOT o2_aw
      AND coalesce(ks_stsr, 0) > 0
    GROUP BY op_rgk -- ist immer eindeutig pro ASK und daher unproblematisch
    INTO
      grenz_kost,
      norm_kost,
      norm_kost_ohne_gemko,
      gemko_proz,
      gemko_wert
    ;

    -- Sonderkosten bestimmen
    SELECT
      sum(coalesce(o3_preis, 0))
    FROM op3
    WHERE o3_ix = opix
    INTO
      sonder_kost
    ;

    sonder_kost := coalesce(sonder_kost, 0);

    -- Norm- und Grenzkosten um Sonderkosten ergänzen
    grenz_kost := coalesce(grenz_kost, 0) + sonder_kost;
    norm_kost  := coalesce(norm_kost, 0)  + sonder_kost;

    -- Kalkulationsmenge bestimmen
        -- Losgröße der ASK bestimmen
        oplg := op_lg FROM opl WHERE op_ix = opix;

        -- initial nach Eingangsmenge kalkulieren
        kalk_menge := menge;

        -- keine Menge angg. bzw. bei Baugruppen-Kalkulation nach Losgrößen
        -- Setting 'BGKOST_LOSGR' erzwingt Kalkulation mind. in Menge >= Losgröße der ASK
        IF ( menge IS NULL OR TSystem.Settings__GetBool('BGKOST_LOSGR') ) THEN

            -- keine Menge angg. oder Menge ist kleiner ASK-Losgröße
            -- dann mind. ASK-Losgröße
            IF ( menge IS NULL OR menge < oplg ) THEN
                kalk_menge := oplg;
            ELSE
                kalk_menge := menge; -- sinnfrei?
            END IF;

        -- Menge ist angg. bzw. keine Baugruppen-Kalkulation nach Losgrößen
        ELSE

            -- Bei Kalkulationsmenge kleiner 1 werden die Kosten auf 1 normiert.
            -- Faktor anhand ASK-Losgröße nicht implementiert. Implizit also immer Stück.
            IF kalk_menge < 1 THEN -- 0.005 Meter
                kalk_menge := 1;
            END IF;
        END IF;
    --

    -- Kosten pro Stück auf 4 NK gerundet
    -- Teilen aller mengenabhängiger Werte durch die Kalkulationsmenge
    grenz_kost           := grenz_kost               / do1if0(kalk_menge);
    norm_kost            := norm_kost                / do1if0(kalk_menge);
    norm_kost_ohne_gemko := norm_kost_ohne_gemko     / do1if0(kalk_menge);
    gemko_wert           := coalesce(gemko_wert, 0)  / do1if0(kalk_menge);

    RETURN;
  END $$ LANGUAGE plpgsql STABLE;
--

-- ASK-Maschinenkosten pro Stück
CREATE OR REPLACE FUNCTION tartikel.op2_mkost_extended(
  IN opix                      integer,

  OUT grenz_kost            numeric,
  OUT norm_kost             numeric,
  OUT norm_kost_ohne_gemko  numeric,
  OUT gemko_proz            numeric,
  OUT gemko_wert            numeric
  ) AS $$
  DECLARE
      pers_grenz_kost           numeric;
      pers_norm_kost            numeric;
      pers_norm_kost_ohne_gemko numeric;
      pers_gemko_wert           numeric;
  BEGIN

    -- Maschinenkosten/Stück über alle KS/AG mit allen Zwischenwerten

    -- Maschinenkosten
    SELECT
      -- Grenzkosten
      sum(
        coalesce(
            (o2_th_sek + o2_tn_sek) * (1 + o2_tv / 100) / 3600  -- Zeiten: Hauptzeit + Nebenzeit + prozentuale Verteilzeit = (in h)
            * coalesce(ks_gss, o2_sts, ks_sts)                  -- Grenzkostenstundensatz der KS bevorzugen
                                                                -- ohne Fertigungsgemeinkosten
        , 0)
      ),

      -- Normkosten
      sum(
        coalesce(
            (o2_th_sek + o2_tn_sek) * (1 + o2_tv / 100) / 3600  -- Zeiten: Hauptzeit + Nebenzeit + prozentuale Verteilzeit = (in h)
            * coalesce(o2_sts, ks_sts)                          -- Stundensatz der Stammkarte vor KS bevorzugen
            * (1 + coalesce(op_fgk, 0) / 100)                   -- plus prozentuale Fertigungsgemeinkosten
        , 0)
      ),

      -- Normkosten ohne Fertigungsgemeinkosten
      sum(
        coalesce(
            (o2_th_sek + o2_tn_sek) * (1 + o2_tv / 100) / 3600  -- Zeiten: Hauptzeit + Nebenzeit + prozentuale Verteilzeit = (in h)
            * coalesce(o2_sts, ks_sts)                          -- Stundensatz der Stammkarte vor KS bevorzugen
        , 0)
      ),

      -- Prozentsatz der Fertigungsgemeinkosten
      coalesce(op_fgk, 0),

      -- Wert der Fertigungsgemeinkosten
      sum(
        coalesce(
            (o2_th_sek + o2_tn_sek) * (1 + o2_tv / 100) / 3600  -- Zeiten: Hauptzeit + Nebenzeit + prozentuale Verteilzeit = (in h)
            * coalesce(o2_sts, ks_sts)                          -- Stundensatz der Stammkarte vor KS bevorzugen
            * (coalesce(op_fgk, 0) / 100)                       -- plus prozentuale Fertigungsgemeinkosten
        , 0)
      )
    FROM op2
      JOIN tartikel.ksv__data__by__table__get( op2 ) ON true
      JOIN opl ON op_ix = o2_ix
    WHERE
          o2_ix = opix
      AND NOT o2_aw
    GROUP BY op_fgk -- ist immer eindeutig pro ASK und daher unproblematisch
    INTO
      grenz_kost,
      norm_kost,
      norm_kost_ohne_gemko,
      gemko_proz,
      gemko_wert
    ;

    -- Personalzeitkosten
    SELECT
      -- Grenzkosten
      sum(
        coalesce(
            o2_tm_sek / 3600                                    -- Personalzeit (in h)
            * coalesce(ks_gssm, ks_stsm)                        -- Grenzkostenstundensatz der KS bevorzugen
        , 0)
      ),

      -- Normkosten
      sum(
        coalesce(
            o2_tm_sek / 3600                                    -- Personalzeit (in h)
            * ks_stsm                                           -- Normstundensatz der KS
            * (1 + coalesce(op_fgk, 0) / 100)                   -- plus prozentuale Fertigungsgemeinkosten
        , 0)
      ),

      -- Normkosten ohne Fertigungsgemeinkosten
      sum(
        coalesce(
            o2_tm_sek / 3600                                    -- Personalzeit (in h)
            * ks_stsm                                           -- Normstundensatz der KS
        , 0)
      ),

      -- Prozentsatz der Fertigungsgemeinkosten
      -- coalesce(op_fgk, 0), => bereits im Teil für die Maschinenkosten ermittelt

      -- Wert der Fertigungsgemeinkosten
      sum(
        coalesce(
            o2_tm_sek / 3600                                    -- Personalzeit (in h)
            * ks_stsm                                           -- Normstundensatz der KS
            * (coalesce(op_fgk, 0) / 100)                       -- plus prozentuale Fertigungsgemeinkosten
        , 0)
      )
    FROM op2
      JOIN tartikel.ksv__data__by__table__get( op2 ) ON true
      JOIN opl ON op_ix = o2_ix
    WHERE
          o2_ix = opix
      AND NOT o2_aw
    INTO
      pers_grenz_kost,
      pers_norm_kost,
      pers_norm_kost_ohne_gemko,
      pers_gemko_wert
    ;

    -- Kosten pro Stück auf 4 NK gerundet
    -- Maschinen und Personalkosten addieren
    grenz_kost           := coalesce(grenz_kost, 0)           + coalesce(pers_grenz_kost, 0);
    norm_kost            := coalesce(norm_kost, 0)            + coalesce(pers_norm_kost, 0);
    norm_kost_ohne_gemko := coalesce(norm_kost_ohne_gemko, 0) + coalesce(pers_norm_kost_ohne_gemko, 0);
    gemko_wert           := coalesce(gemko_wert, 0)           + coalesce(pers_gemko_wert, 0);

    RETURN;
  END $$ LANGUAGE plpgsql STABLE;
--

-- ASK-Auswärtskosten pro Stück
CREATE OR REPLACE FUNCTION tartikel.op2_akost_extended(
  IN opix                      integer,
  IN menge                     numeric = null,

  OUT grenz_kost            numeric,
  OUT norm_kost             numeric,
  OUT norm_kost_ohne_gemko  numeric,
  OUT gemko_proz            numeric,
  OUT gemko_wert            numeric
  ) AS $$
  DECLARE
      oplg              numeric;
      kalk_menge        numeric;
      epreisstaff       bool;
      awpreis           numeric;
      awpreisfix        numeric;
      awpreis_source    varchar(40);
      r                 record;
      stk_kosten_pro_ag numeric;
  BEGIN

    -- Auswärtskosten/Stück über alle KS/AG mit allen Zwischenwerten

    --  Werte initialisieren
    grenz_kost           := 0;
    norm_kost            := 0;
    norm_kost_ohne_gemko := 0;
    gemko_wert           := 0;

    -- Auswärtsgemeinkostenzuschlag bestimmen
    SELECT
      op_agk
    FROM opl
    WHERE op_ix = opix
    INTO
      gemko_proz
    ;

    -- ohne Angabe von Menge raus
    IF menge = 0 THEN   RETURN;   END IF;

    -- Kalkulationsmenge bestimmen
        -- Losgröße der ASK bestimmen
        oplg := op_lg FROM opl WHERE op_ix = opix;

        -- initial nach Eingangsmenge kalkulieren
        kalk_menge := menge;

        -- keine Menge angg. bzw. bei Baugruppen-Kalkulation nach Losgrößen
        -- Setting 'BGKOST_LOSGR' erzwingt Kalkulation mind. in Menge >= Losgröße der ASK
        IF ( menge IS NULL OR TSystem.Settings__GetBool('BGKOST_LOSGR') ) THEN

            -- keine Menge angg. oder Menge ist kleiner ASK-Losgröße
            -- dann mind. ASK-Losgröße
            IF ( menge IS NULL OR menge < oplg ) THEN
                kalk_menge := oplg;
            ELSE
                kalk_menge := menge; -- sinnfrei?
            END IF;
        END IF;
    --

    -- Preise anhand Staffeln berechnen
    epreisstaff := TSystem.Settings__GetBool('BGCALC_EPREIS_STAFF');

    -- über alle Auswärts-AG summieren
    FOR r IN
        SELECT
          o2_awpreis,
          o2_awpreisfix,
          o2_min,
          o2_aknr,
          op_n
        FROM op2
          JOIN opl ON op_ix = o2_ix
        WHERE
              o2_ix = opix
          AND o2_aw
    LOOP
        -- Initialisierung
        awpreis           := null;
        awpreisfix        := null;
        stk_kosten_pro_ag := 0;

        -- Staffelpreis der Auswärtsbearbeitung suchen
        IF epreisstaff THEN
            SELECT preis_uf1_basisw,  abzubetrag_uf1_basisw * kalk_menge, coalesce(source_table, 'ask') -- Die Fixkosten werden in Abhängigkeit E/M bereits in der Preissuche auf die angegebene Menge heruntergrochen. Daher muss das hier wieder multipliziert werden.
            INTO   awpreis,           awpreisfix,                         awpreis_source
            FROM
              TWawi.Search_EKPreis(
                  r.o2_aknr,  -- Arbeitspaket
                  kalk_menge, -- Menge
                  r.op_n,     -- Fertigungsartikel
                  '%',        -- alle Lieferanten
                  ''          -- keine besonderen Suchoptionen
              )
            ;
        END IF;

        -- wenn Preissuche nichts findet, Avor-Wert nehmen!
        awpreis     := coalesce(awpreis,    r.o2_awpreis,     0);
        awpreisfix  := coalesce(awpreisfix, r.o2_awpreisfix,  0);

        -- Log für Artikelpreis-Probleme
        PERFORM
          create_stvtrs_res_log(
              TSystem.Settings__Get('BGCALC_CURRENT_RESID'),
              r.o2_aknr,
              'art_ekpreis',
              (awpreis + awpreisfix)::varchar,
              awpreis_source,
              r.op_n
          )
        ;

        -- Stückkosten des AG
        -- Auswärts-Mindestkosten berücksichtigen
        IF awpreis * kalk_menge + awpreisfix > r.o2_min THEN

            -- AW-Preis ist schon pro Stück, Fixkosten (Zuschläge) nicht
            stk_kosten_pro_ag := awpreis + awpreisfix / kalk_menge;
        ELSE

            -- Bei Unterschreitung der Mindestkosten auf diese zurückfallen
            stk_kosten_pro_ag := r.o2_min / kalk_menge;
        END IF;

        -- Summen
        grenz_kost           := coalesce(grenz_kost , 0)            + stk_kosten_pro_ag;
        norm_kost            := coalesce(norm_kost , 0)             + stk_kosten_pro_ag * (1 + gemko_proz / 100);
        norm_kost_ohne_gemko := coalesce(norm_kost_ohne_gemko , 0)  + stk_kosten_pro_ag;
        gemko_wert           := coalesce(gemko_wert , 0)            + stk_kosten_pro_ag * (gemko_proz / 100);

    END LOOP;

    -- Kosten pro Stück auf 4 NK gerundet
    grenz_kost           := coalesce(grenz_kost , 0);
    norm_kost            := coalesce(norm_kost , 0);
    norm_kost_ohne_gemko := coalesce(norm_kost_ohne_gemko , 0);
    gemko_wert           := coalesce(gemko_wert , 0);
    gemko_proz           := coalesce(gemko_proz , 0);

    RETURN;
  END $$ LANGUAGE plpgsql STABLE;
--

-- ASK-Materialkosten pro Stück
-- Materialkosten pro Stück des Fertigungsartikel über alle KS/AG/Materialien unter Berücksichtigung von Losgrößen und aktuellen Einkaufspreisen
CREATE OR REPLACE FUNCTION tartikel.op6_kost_extended(
  IN opix                      integer,
  IN menge                     numeric = null,

  OUT grenz_kost            numeric,
  OUT norm_kost             numeric,
  OUT norm_kost_ohne_gemko  numeric,
  OUT gemko_proz            numeric,
  OUT gemko_wert            numeric
  ) AS $$
  DECLARE
      result        numeric;
      mat_menge     numeric;
      mat_preis     numeric; -- Einzelpreis für Rohmaterial per ME
      mat_abzu      numeric; -- Fixkostenanteil, Zuschläge
      pos_preis     numeric;
      ekp_suche     boolean;
      oplg          numeric;
      rpreis_source varchar(40);
      r             record;
  BEGIN

    -- Materialkosten/Stück

    -- Werte initialisieren
    grenz_kost           := 0;
    norm_kost            := 0;
    norm_kost_ohne_gemko := 0;
    gemko_proz           := 0;
    gemko_wert           := 0;

    -- ohne Angabe von Menge raus
    IF menge = 0 THEN   RETURN;   END IF;

    -- Einkaufs-Preissuche benutzen. (Haken 'Rahmen / Lieferanten / Staffelpreise, z.Bsp. im Stücklisten-Form)
    ekp_suche := TSystem.Settings__GetBool('BGCALC_EPREIS_STAFF');

    -- Kalkulationsmenge bestimmen
        -- Losgröße der Stammkarte holen
        oplg := op_lg FROM opl WHERE op_ix = opix;

        -- keine Menge angg. bzw. bei Baugruppen-Kalkulation nach Losgrößen
        -- Setting 'BGKOST_LOSGR' erzwingt Kalkulation mind. in Menge >= Losgröße der ASK
        IF ( menge IS NULL OR ( TSystem.Settings__GetBool('BGKOST_LOSGR') AND oplg > menge ) ) THEN
            menge := do1if0(oplg);
        END IF;
    --

    -- ASK-Materialien durchlaufen
    FOR r IN
        SELECT
          o6_aknr,
          o6_m_uf1,
          o6_m_stat,
          op_lg,
          o6_artpr_uf1,
          o6_min,
          op_mgk,
          o6_mgk
        FROM op6
          JOIN opl ON op_ix = o6_ix
        WHERE
              o6_ix = opix
          -- Wenn Material eigene Stammkarte hat -> Vorproduktion, wird ausgeschlossen  [CASE WHEN _kalkVar THEN op_kalku ELSE END] ?
          AND NOT EXISTS(SELECT true FROM opl WHERE op_n = o6_aknr AND op_standard)
/*STATUS#20827...*/
          -- AM alternative MatPos herausfiltern, siehe #1538
          -- BK keine Beistellung durch Kunden, siehe #11316
          AND NOT TSystem.ENUM_ContainsValue(o6_stat, 'AM,BK')
        ORDER BY o6_pos
    LOOP
        -- Initialisierung
        mat_preis := null;
        mat_abzu  := null;
        pos_preis := null;

        -- Benötigte Materialmenge ausrechnen.
        -- Per Fertigungslos (o6_m_stat=1), Anzahl der Fertigungslose, sonst brauchen wir angegebene Menge pro Fertigungsteil.
        mat_menge := r.o6_m_uf1 * ifthen( r.o6_m_stat = 0, menge, ceil(menge/oplg) );

        IF ekp_suche THEN
            -- EK-Preise
            SELECT preis_uf1_basisw,  abzubetrag_uf1_basisw,  source_table
            INTO   mat_preis,         mat_abzu,               rpreis_source
            FROM
              TWawi.Search_EKPreis(
                    r.o6_aknr,  -- Fertigungsartikel
                    mat_menge,  -- Menge
                    '',         -- leer (nur bei Auswärts)
                    '%',        -- alle Lieferanten
                    ''          -- keine besonderen Suchoptionen
              )
            ;

            -- Fallback auf Stammkarte, wenn kein Preis gefunden wurden
            rPreis_Source := coalesce(nullif(rpreis_source, ''), 'ask');
        END IF;

        mat_preis := coalesce(nullif(mat_preis, 0), r.o6_artpr_uf1, 0); -- Auf Stammkartenpreis zurückgehen, wenn keiner gefunden.
        mat_abzu  := coalesce(mat_abzu, 0);
        pos_preis := mat_menge * (mat_preis + mat_abzu);
        pos_preis := greatest(pos_preis, coalesce(r.o6_min, 0)); -- Mindestpreis muss überschritten sein.

        -- RAISE NOTICE 'DEBUG TArtikel.op6_kost: Material=%, Fert.Menge=%, Mat.Menge=%, mat_preisProStk=%, mat_abzuProStk=%, Matpos_preis=%, Mindestbetrag=%, Preisquelle=%',
        --     r.o6_aknr, fertMenge::NUMERIC(12,4), mat_menge::NUMERIC(12,4), mat_preis::NUMERIC(12,4), mat_abzu::NUMERIC(12,4), pos_preis::NUMERIC(12,4), r.o6_min, rpreis_source;

        -- Log für Artikelpreis-Probleme
        PERFORM
          create_stvtrs_res_log(
              TSystem.Settings__Get('BGCALC_CURRENT_RESID'),
              r.o6_aknr,
              'art_ekpreis',
              (pos_preis)::varchar,
              rpreis_source
          )
        ;

        -- Gesamtpreis für Material auf Stück der Fertigungsmenge aufteilen dann AVOR- und Materialgemeinkosten einrechnen.
        grenz_kost           := coalesce(grenz_kost, 0)           + ( pos_preis / menge );
        norm_kost            := coalesce(norm_kost, 0)            + ( pos_preis / menge * (1 + r.op_mgk / 100) * (1 + r.o6_mgk / 100) );
        norm_kost_ohne_gemko := coalesce(norm_kost_ohne_gemko, 0) + ( pos_preis / menge );

    END LOOP;

    -- Materialgemeinkosten rückrechnen
    -- Erläuterung:
      -- Rückrechnen ist notwendig, da ein Fertigungsteil (ohne Baugruppe) mehrere Einträge in der Materialliste haben kann.
      -- Diese Einträge in der Materialliste können unterschiedliche Materialgemeinkostenzuschläge haben o6_mgk.
      -- Ein Verrechnen der Prozentsätze direkt untereinander ist damit nicht möglich.
    gemko_wert := norm_kost - norm_kost_ohne_gemko;

    -- Prozentwert aus Wert rückrechnen
    gemko_proz := coalesce(gemko_wert, 0) / ( do1if0(norm_kost) - coalesce(gemko_wert, 0) ) * 100;

    -- Kosten pro Stück auf 4 NK gerundet
    grenz_kost           := coalesce(grenz_kost, 0);
    norm_kost            := coalesce(norm_kost,  0);
    norm_kost_ohne_gemko := coalesce(norm_kost_ohne_gemko, 0);
    gemko_proz           := coalesce(gemko_proz, 0);
    gemko_wert           := coalesce(gemko_wert, 0);

    RETURN;
  END $$ LANGUAGE plpgsql STABLE;
--

--Rüstkosten/Stück über alle KS/AG
CREATE OR REPLACE FUNCTION tartikel.op2_rkost(
  IN opix  integer,
  IN m     numeric = null,
  IN gk    boolean = false
  ) RETURNS numeric AS $$
  BEGIN
    IF gk THEN
        RETURN  grenz_kost  FROM tartikel.op2_rkost_extended(opix, m);
    ELSE
        RETURN  norm_kost   FROM tartikel.op2_rkost_extended(opix, m);
    END IF;
  END $$ LANGUAGE plpgsql STABLE;
--

-- Maschinenkosten/Stück über alle KS/AG
CREATE OR REPLACE FUNCTION tartikel.op2_mkost(
  IN opix  integer,
  IN gk    boolean = false
  ) RETURNS numeric AS $$
  BEGIN
    IF gk THEN
        RETURN  grenz_kost  FROM tartikel.op2_mkost_extended(opix);
    ELSE
        RETURN  norm_kost   FROM tartikel.op2_mkost_extended(opix);
    END IF;
  END $$ LANGUAGE plpgsql STABLE;
--

--Auswärtskosten/Stück über alle KS/AG
CREATE OR REPLACE FUNCTION tartikel.op2_akost(
  IN opix  integer,
  IN m     numeric = null,
  IN gk    boolean = false
  ) RETURNS numeric AS $$
  BEGIN
    IF gk THEN
        RETURN  grenz_kost  FROM tartikel.op2_akost_extended(opix, m);
    ELSE
        RETURN  norm_kost   FROM tartikel.op2_akost_extended(opix, m);
    END IF;
  END $$ LANGUAGE plpgsql STABLE;
--

-- Materialkosten/Stück
CREATE OR REPLACE FUNCTION tartikel.op6_kost(
  IN opix      integer,
  IN fertmenge numeric = null,
  IN gk        boolean = false
  ) RETURNS numeric AS $$
  BEGIN
    IF gk THEN
        RETURN  grenz_kost  FROM tartikel.op6_kost_extended(opix, fertmenge);
    ELSE
        RETURN  norm_kost   FROM tartikel.op6_kost_extended(opix, fertmenge);
    END IF;
  END $$ LANGUAGE plpgsql STABLE;
--

/*  Eingangsparameter:  in_op_ix        - ASK - Stammtabelle
                        in_menge        - Fertigungsmenge / für diese Menge kalkulieren
    Ausgangsparameter:  oplDC_bez       - Kostenbezeichnung
                        oplDC_stdsql    - Bezeichnung zum Aufruf für die Standard-SQLs
                        oplDC_kostLos   - Kosten/Stck. für Losgröße
                        oplDC_kostMng   - Kosten/Stck. für Fertigungsmenge

    Erste Zeile ist als Info: Losgröße und Fertigungsmenge
*/

-- die Funktion wurde leider zum Entwicklungszeitpunkt unter diesem unwiederfindbaren Namen (opl_kalk_zf) angelegt, daher das DROP
-- DROP FUNCTION IF EXISTS tartikel.opl_kalk_zf(INTEGER, NUMERIC, BOOL);

-- DROP FUNCTION IF EXISTS TArtikel.opl_DynCalc(INTEGER, NUMERIC, BOOL);
-- Dynamische Kalkulation, #7151, #8533
CREATE OR REPLACE FUNCTION TArtikel.opl_DynCalc(
  IN in_op_ix INTEGER,
  IN in_menge NUMERIC DEFAULT NULL,
  IN in_gk BOOL DEFAULT false,
  OUT oplDC_bez VARCHAR,
  OUT oplDC_stdsql VARCHAR,
  OUT oplDC_kostLos NUMERIC,
  OUT opldc_mehLos VARCHAR,
  OUT oplDC_kostMng NUMERIC,
  OUT opldc_mehMng VARCHAR
  ) RETURNS SETOF RECORD AS $$
  DECLARE los                   NUMERIC;
          summe_los             NUMERIC;
          summein_menge         NUMERIC;
          hptwhrng              VARCHAR(5);
          rec                   RECORD;
          zuschlagsumme_los     NUMERIC(12,2);
          zuschlagsumme_menge   NUMERIC(12,2);
          msg               TEXT;
          context1              TEXT;
          vkpfaktor             NUMERIC;
          rnd                   INTEGER;
  BEGIN
    rnd              := 8; --Preise aufgrund der Rechengenauigkeit auf acht Stellen runden
    los              := (SELECT op_lg FROM opl WHERE op_ix = in_op_ix);
    summe_los        := 0;
    summein_menge    := 0;
    hptwhrng         := (SELECT TSystem.Settings__Get('BASIS_W'));

    oplDC_bez        := Lang_Text(555); --Menge
    oplDC_stdsql     := NULL;
    oplDC_kostLos    := los;
    oplDC_MehLos     := (SELECT standardmgc(op_n, prodat_languages.curr_lang()) FROM opl WHERE op_ix =  in_op_ix);
    oplDC_kostMng    := in_menge;
    oplDC_MehMng     := oplDC_MehLos;
    RETURN NEXT;

    oplDC_bez        := Lang_Text(680); --Rüstkosten
    oplDC_stdsql     := 'ASK.DynCalc.TArtikel.op2_rkost';
    oplDC_kostLos    := tartikel.op2_rkost(in_op_ix, los, in_gk) * los; -- Funktion berechnet R-Kosten pro Stück UND hängt insb. ab vom TSystem.Settings__GetBool('BGKOST_LOSGR') (mit optimalem Los fertigen)
                                                                        -- daher MUSS R-Kosten anhand Los * Los durchgeführt werden. Siehe auch stvtrs__b_i__calcprices Feld new.ruest
    oplDC_MehLos     := hptwhrng;
    oplDC_kostMng    := tartikel.op2_rkost(in_op_ix, in_menge, in_gk) * in_menge; -- ebenso, R-Kosten anhand Menge * Menge
    oplDC_MehMng     := oplDC_MehLos;
    summe_los        := summe_los + oplDC_kostLos;
    summein_menge    := summein_menge + oplDC_kostMng;
    RETURN NEXT;

    oplDC_bez        := Lang_Text(394); --Fertigungskosten
    oplDC_stdsql     := 'ASK.DynCalc.TArtikel.op2_mkost';
    oplDC_kostLos    := tartikel.op2_mkost(in_op_ix, in_gk) * los;
    oplDC_MehLos     := hptwhrng;
    oplDC_kostMng    := tartikel.op2_mkost(in_op_ix, in_gk) * in_menge;
    oplDC_MehMng     := oplDC_MehLos;
    summe_los        := summe_los + oplDC_kostLos;
    summein_menge    := summein_menge + oplDC_kostMng;
    RETURN NEXT;

    oplDC_bez        := Lang_Text(2810); --Auswährtskosten
    oplDC_stdsql     := 'ASK.DynCalc.TArtikel.op2_akost';
    oplDC_kostLos    := tartikel.op2_akost(in_op_ix, los, in_gk) * los;
    oplDC_MehLos     := hptwhrng;
    oplDC_kostMng    := tartikel.op2_akost(in_op_ix, in_menge, in_gk) * in_menge;
    oplDC_MehMng     := oplDC_MehLos;
    summe_los        := summe_los + oplDC_kostLos;
    summein_menge    := summein_menge + oplDC_kostMng;
    RETURN NEXT;

    oplDC_bez        := Lang_Text(546); --Materialkosten
    oplDC_stdsql     := 'ASK.DynCalc.TArtikel.op6_kost';
    oplDC_kostLos    := tartikel.op6_kost(in_op_ix, los, in_gk) * los;
    oplDC_MehLos     := hptwhrng;
    oplDC_kostMng    := tartikel.op6_kost(in_op_ix, in_menge, in_gk) * in_menge;
    oplDC_MehMng     := oplDC_MehLos;
    summe_los        := summe_los + oplDC_kostLos;
    summein_menge    := summein_menge + oplDC_kostMng;
    RETURN NEXT;

    zuschlagsumme_los     := 0;
    zuschlagsumme_menge   := 0;
    IF ((SELECT COUNT(*) FROM op7zko WHERE o7zk_ix = in_op_ix) <> 0) THEN
      oplDC_bez        := Lang_Text(26009); --Zwischensumme
      oplDC_stdsql     := NULL;
      oplDC_kostLos    := summe_los;
      oplDC_MehLos     := hptwhrng;
      oplDC_kostMng    := summein_menge;
      oplDC_MehMng     := oplDC_MehLos;
      RETURN NEXT;

        FOR rec IN SELECT o7zk_krc_bez, o7zk_proz::NUMERIC(8,2) FROM op7zko WHERE o7zk_ix = in_op_ix LOOP -- Zuschläge
            oplDC_bez            := ' + ' || rec.o7zk_krc_bez || ' (' || rec.o7zk_proz || ' %)';
            oplDC_stdsql         := NULL;
            --oplDC_kostLos        := ROUND(summe_los * rec.o7zk_proz / los / 100, rnd);
            oplDC_kostLos        := ROUND(summe_los * rec.o7zk_proz / 100, rnd);
            --zuschlagsumme_los    := zuschlagsumme_los + ROUND(summe_los  * rec.o7zk_proz / los / 100, rnd);
            zuschlagsumme_los    := zuschlagsumme_los + ROUND(summe_los  * rec.o7zk_proz / 100, rnd);

            oplDC_MehLos         := hptwhrng;
            --oplDC_kostMng        := ROUND(summein_menge / in_menge * rec.o7zk_proz / 100, rnd);
            oplDC_kostMng        := ROUND(summein_menge * rec.o7zk_proz / 100, rnd);
            --zuschlagsumme_menge  := zuschlagsumme_menge + ROUND(summein_menge  * rec.o7zk_proz / in_menge / 100 , rnd);
            zuschlagsumme_menge  := zuschlagsumme_menge + ROUND(summein_menge  * rec.o7zk_proz / 100 , rnd);
            oplDC_MehMng         := oplDC_MehLos;
            RETURN NEXT;
        END LOOP;
    END IF;

    oplDC_bez        := Lang_Text(15652); --Gesamtkosten
    oplDC_stdsql     := NULL;
    oplDC_kostLos    := ROUND(summe_los + zuschlagsumme_los, rnd);
    oplDC_MehLos     := hptwhrng;
    oplDC_kostMng    := ROUND(summein_menge + zuschlagsumme_menge, rnd);
    oplDC_MehMng     := oplDC_MehLos;
    summe_los        := oplDC_kostLos;
    summein_menge    := oplDC_kostMng;
    RETURN NEXT;

    oplDC_bez        := Lang_Text(29045); --Selbstkosten pro Stück
    oplDC_stdsql     := NULL;
    oplDC_kostLos    := ROUND(summe_los / los, rnd);
    oplDC_MehLos     := hptwhrng;
    oplDC_kostMng    := ROUND(summein_menge / in_menge, rnd);
    oplDC_MehMng     := oplDC_MehLos;
    summe_los        := oplDC_kostLos;
    summein_menge    := oplDC_kostMng;
    RETURN NEXT;

    SELECT COALESCE(ak_vkpfaktor, ac_vkpfaktor) INTO vkpfaktor FROM opl JOIN art ON ak_nr = op_n JOIN artcod ON ak_ac = ac_n WHERE op_ix = in_op_ix;
    IF (vkpfaktor IS NOT NULL) AND (vkpfaktor <> 1) THEN
        oplDC_bez        := ' + ' || Lang_Text(376) || ' (' || vkpfaktor ||')'; --Faktor
        oplDC_kostLos    := ROUND(summe_los * (vkpfaktor -1), rnd);
        oplDC_MehLos     := hptwhrng;
        oplDC_kostMng    := ROUND(summein_menge * (vkpfaktor -1), rnd);
        oplDC_MehMng     := oplDC_MehLos;
        RETURN NEXT;

        oplDC_bez        := Lang_Text(30125); --Verkaufspreisbasis pro Stück
        oplDC_stdsql     := NULL;
        oplDC_kostLos    := ROUND(summe_los * vkpfaktor, rnd);
        oplDC_MehLos     := hptwhrng;
        oplDC_kostMng    := ROUND(summein_menge * vkpfaktor, rnd);
        oplDC_MehMng     := oplDC_MehLos;
        RETURN NEXT;
    END IF;

    IF TSystem.Settings__GetBool('IsEnplanActive') THEN  -- Wenn Engerieberechnung aktiviert, dann zwei weitere Zeilen, zum Thema TechPlan anhängen
      BEGIN
        oplDC_bez        := NULL; -- Leerzeile
        oplDC_stdsql     := NULL;
        oplDC_kostMng    := NULL;
        oplDC_MehLos     := NULL;
        oplDC_kostLos    := NULL;
        oplDC_MehMng     := oplDC_MehLos;
        RETURN NEXT;

        oplDC_bez        := 'Energieverbrauch lt. TechPlan:';  -- Todo: Xtt
        oplDC_stdsql     := 'ASK.DynCalc.TArtikel.op2_EnergieVerbrauch';
        oplDC_kostLos    := x_800_enplan.GetEnergie(in_op_ix, los);
        oplDC_MehLos     := 'kWh';
        oplDC_kostMng    := x_800_enplan.GetEnergie(in_op_ix, in_menge);
        oplDC_MehMng     := oplDC_MehLos;
        RETURN NEXT;

      EXCEPTION WHEN OTHERS THEN
        GET STACKED DIAGNOSTICS msg = PG_EXCEPTION_CONTEXT;
        --- #7543
        PERFORM TSystem.LogError(
                    TSystem.LogFormat(        -- Message
                        'Energieberechnung fehlerhaft.'
                      , true    -- Zeilenumbruch
                      ,  'ASK-Index', coalesce( in_op_ix::varchar, '' )
                      ,  'Message', coalesce( SQLERRM, '' )
                    )
                )
        ;

        RAISE WARNING '%', msg;
        PERFORM PRODAT_HINT(msg);
      END;

    END IF;
  END $$ LANGUAGE plpgsql VOLATILE;
--

-----------------------------------------------------------------------------------------------------
-----------------------------------------------------------------------------------------------------
-----------------------------------------------------------------------------------------------------


/*BEDARFSENTWICKLUNG*/

CREATE TABLE do_artikel_bedarf
 (
  dab_aknr       VARCHAR PRIMARY KEY,
  dab_bestabgl   BOOL DEFAULT FALSE, --true, wenn Bestandsabgleich berechnet werden soll (bei Mengenänderungen)
  dab_done       BOOL DEFAULT FALSE
  -- System (tables__generate_missing_fields)
  --   kein automatisches dbrid, insert_date, insert_by, modified_by, modified_date und table_delete-Trigger (tables__fieldInfo__fetch)
 );

CREATE INDEX do_artikel_bedarf_dab_aknr ON do_artikel_bedarf(dab_aknr) WHERE NOT dab_done;
CREATE INDEX do_artikel_bedarf_dab_done ON do_artikel_bedarf(dab_done) WHERE dab_done IS false; -- Index ist für Abfrage WHERE dab_done IS false relevant (PG13 viel schneller, erster Index wird *nicht* verwendet für diese Abfrage)

CREATE OR REPLACE FUNCTION do_artikel_bedarf__b_i() RETURNS TRIGGER AS $$
  DECLARE rows INTEGER;
  BEGIN
   UPDATE do_artikel_bedarf SET dab_done=FALSE, dab_bestabgl=dab_bestabgl OR new.dab_bestabgl WHERE dab_aknr=new.dab_aknr;
   GET DIAGNOSTICS rows = ROW_COUNT;
   IF rows=0 THEN
          RETURN new;
   ELSE
          RETURN NULL;--verwerfen insert: den artikel gibts schonmal
   END IF;
  END $$ LANGUAGE plpgsql;

  CREATE TRIGGER do_artikel_bedarf__b_i
    BEFORE INSERT
    ON do_artikel_bedarf
    FOR EACH ROW
    EXECUTE PROCEDURE do_artikel_bedarf__b_i();

CREATE OR REPLACE FUNCTION tartikel.prepare_artikel_bedarf(aknr VARCHAR, bestabgl BOOL DEFAULT FALSE) RETURNS VOID AS $$
  BEGIN
   INSERT INTO do_artikel_bedarf (dab_aknr, dab_bestabgl) VALUES (aknr, bestabgl);
   RETURN;
  END $$ LANGUAGE plpgsql;



DROP FUNCTION IF EXISTS do_artikel_bedarf();
DROP FUNCTION IF EXISTS do_artikel_bedarf(character varying);


CREATE OR REPLACE FUNCTION do_artikel_bedarf(aknr VARCHAR DEFAULT '%', ignoredisableflag boolean DEFAULT false) RETURNS VOID AS $$
  DECLARE r RECORD;
  BEGIN
   --IgnoreDisableFlag : bei Prognose werden die Stücklisten aufgelöst. Der Unterartikel muß aber wissen, ob sein Oberartikel zum Zeitpunkt Verfügbar ist, oder nicht
   --daher muß in diesem Fall sofort eine Bedarfsaktualisierung/Prüfung stattfinden!
   --BEACHTE bedarf__getbestand zur einfachen Erklärung!_
   IF execution_code__is_disabled( _flagname => 'bedarfberech' ) AND NOT IgnoreDisableFlag THEN
     RETURN;
   END IF;
   --
   PERFORM execution_code__disable( _flagname => 'bedarfberech' ); --Bestandabgleich_Intern ruft sonst evtl rekursiv auf!
   --
   FOR r IN SELECT dab_aknr, dab_bestabgl FROM do_artikel_bedarf WHERE dab_aknr LIKE aknr AND dab_done IS false LOOP
          UPDATE do_artikel_bedarf SET dab_done=TRUE, dab_bestabgl=False WHERE dab_aknr=r.dab_aknr;
            IF current_user='root' THEN
                  RAISE NOTICE 'do_artikel_bedarf - %', r.dab_aknr;
            END IF;
          IF r.dab_bestabgl THEN--bestandsabgleich bei mengenänderungen
                  PERFORM tartikel.bestand_abgleich_intern(r.dab_aknr);
          END IF;
          PERFORM tartikel.bedarf__make_bedarf(r.dab_aknr);
   END LOOP;
   --
   PERFORM execution_code__enable( _flagname => 'bedarfberech' );
   --
   RETURN ;
  END $$ LANGUAGE plpgsql;


--CREATE VIEW bedarf_view AS SELECT bedarf.* FROM bedarf JOIN do_artikel_bedarf(b_aknr) ON true;

CREATE TABLE bedarf
 (
  b_id           serial PRIMARY KEY,
  b_aknr         varchar(40) NOT NULL,
  b_bestdat      date,
  b_date_liefer  date, -- Lieferdatum für Lieferanten: Bei ABK Materialliste mit Puffer zwischen eigentlichen Bedarfsdatum und Solltermin für Lieferanten
  b_date         date, -- Bedarfsdatum
  b_bestand      numeric(12,4) DEFAULT 0,
  b_zuab         numeric(12,4) DEFAULT 0,
  b_nbestand     numeric(12,4) DEFAULT 0,
  b_auftg        varchar(1000),
  b_ag_id        integer,
  b_ldsauf       varchar(1000),
  b_ld_id        integer,
  b_bap_id       integer,
  b_endofday     boolean DEFAULT FALSE

  -- System (tables__generate_missing_fields)
  --   kein automatisches dbrid, insert_date, insert_by, modified_by, modified_date und table_delete-Trigger (tables__fieldInfo__fetch)
 );

CREATE INDEX bedarf_aknr_date ON bedarf(b_aknr, b_date, b_endofday);
CREATE INDEX bedarf_date      ON bedarf(b_date);
CREATE INDEX bedarf_bestdat   ON bedarf(b_bestdat);
CREATE INDEX bedarf_bestdat_date__coalesce ON bedarf( coalesce(bedarf.b_bestdat, bedarf.b_date) ); -- FUNCTION TEinkauf.bestellvorschlag__generate__from__Bedarf
CREATE INDEX bedarf_b_ag_id   ON bedarf(b_ag_id) WHERE b_ag_id IS NOT null;
CREATE INDEX bedarf_b_ld_id   ON bedarf(b_ld_id) WHERE b_ld_id IS NOT null;
CREATE INDEX bedarf_b_bap_id  ON bedarf(b_bap_id) WHERE b_bap_id IS NOT null;

CREATE OR REPLACE FUNCTION tartikel.bedarf__getbestand(
    IN  _aknr varchar,
    IN  _bdt date
    )
    RETURNS numeric
    AS $$
    DECLARE
      I   numeric;
    BEGIN
      IF _bdt  < current_date THEN
         _bdt := current_date;
      END IF;

      --evtl steht der Artikel zur Aktualisierung an!
      IF EXISTS(SELECT true FROM do_artikel_bedarf
                           WHERE NOT dab_done
                             AND dab_aknr = _aknr
                )
      THEN
         PERFORM do_artikel_bedarf(_aknr, true);
      END IF;
      --

      I := b_nbestand FROM bedarf
                     WHERE b_aknr  = _aknr
                       AND b_date <= _bdt
                     ORDER BY
                           b_date DESC,
                           b_id DESC
                     LIMIT 1;--damit haben wir den letzten Satz an diesem Tag!
      --
      RETURN coalesce(I, 0);
    END $$ LANGUAGE plpgsql STABLE;



/*  BEDARFBERECHNUNG FÜR ARTIKEL
Erstellt den Bedarfsverlauf für den Artikel, wie er beispielsweise in der Antenne im Artikelstamm angezeigt wird.
Berücksichtigt werden Lager- / Mindestbestand, offene Bestellungen (inkl.Rahmen) , offene Aufträge (inkl. Rahmen) und
Bestellanforderungs-Positionen, für die ein Termin gesetzt ist.

Arbeitsweise:

- Alle Einträge für den Artikel aus der Tabelle Bedarf löschen
- Prüfung ob Lagerverwaltet und Artikel überhaupt noch vorhanden
- Aufbau der anstehenden Bedarf mit folgender Reihenfolge:

1.Aktueller Lagerbestand und Bedarf aus Mindestbestand (soweit vorhanden) mit Bedarfsdatum "Heute"
2.Alle Bestellungen ohne Termin oder mit Termin in der Vergangenheit werden mit Bedarfsdatum "Heute" eingetragen
3.Alle Aufträge ohne Termin oder mit Termin in der Vergangenheit werden mit Bedarfsdatum "Heute" eingetragen.
  => Ausnahme: Rahmenaufträge, die werden immer zum Liefertermin angezeigt
4. Alle bedarfsverursachenden Bestellanforderungen (das sind die mit Termin) werden bei Termin in der Vergangenheit mit Bedarfsdatum "Heute" eingetragen
5. Alle Bestellungen, Aufträge und Banf-Positionen werden nach Termin sortiert eingetragen. Innerhalb eines Tages kommen Bestellungen immer vor Aufträgen und diese vor Bestellanforderungen
6. Zum Schluss, offene Menge von Rahmenbestellungen (mit Bedarfsdatum 01-01-2099), dann offene Rahmenaufträge ohne Termin (auch mit 01-01-2099)

Siehe Wiki, bei Änderung dort nachziehen.
http://redmine.prodat-sql.de/projects/prodat-v-x/wiki/Bestandsabgleich_und_Bedarfsberechnung
*/


    CREATE OR REPLACE FUNCTION tartikel.bedarf__make_bedarf(_aknr varchar) RETURNS void
      AS $$
      DECLARE artrec record;
              _start_time time;
      BEGIN

        _start_time := clock_timestamp()::time;

        --Alte Bedarfe zum Artikel entfernen, die werden bei jeder Änderung komplett neu aufgebaut
        DELETE FROM bedarf WHERE b_aknr = _aknr;

        --Grunddaten zur Prüfung holen.
        SELECT ak_nr, ak_lag, ac_i, CAST(round( coalesce(ak_bfr, 0) ) AS integer) AS ak_bfr 
          INTO artrec 
          FROM art JOIN artcod ON ak_ac = ac_n 
         WHERE ak_nr = _aknr;

        IF NOT artrec.ak_lag OR artrec.ac_i=50 THEN  RETURN;  END IF; -- nicht lagerverwaltet => raus
        IF artrec.ak_nr IS NULL THEN  RETURN;  END IF; -- kein Artikel gefunden => raus

        INSERT INTO bedarf ( b_aknr, b_date, b_bestand, b_zuab , b_nbestand, b_ldsauf , b_auftg, b_ld_id  , b_ag_id, b_bap_id, b_bestdat, b_date_liefer)
        SELECT
          _aknr,                                                                             -- Artikelnummer aus Parameter
          bdate,                                                                            -- Bedarfsdatum
          ak_tot - bzuab +  (sum(bzuab) OVER ( ORDER BY bdate, orderby, bldsauf, bauftg)) , -- Bestand vor dieser Zeile  (= Lagermenge + Über Zeit kummulierte Änderung - letzte Änderung)
          bzuab,                                                                            -- Änderung durch diese Zeile
          ak_tot         +  (sum(bzuab) OVER ( ORDER BY bdate, orderby, bldsauf, bauftg)) , -- Bestand nach dieser Zeile (= Lagermenge + Über Zeit kummulierte Änderung)
          bldsauf, bauftg, ldid, agid, bapid,                                               -- Verknüpfungen und Textbeschreibung
          bbestdat,                                                                         -- zu diesem Datum muss bestellt werden (Lieferdatum an Lieferant - Beschaffungsfrist)
          date_liefer
        FROM (

            --------------- Mindestbestand und Lagerbestand -----------------------------------------------------------------------------------------

            SELECT 0                             AS OrderBy, -- Mindestbestand bzw. Lagerbestand immer als erstes anzeigen
                   current_date                  AS bdate,   -- Bedarfsdatum Mindestbestand immer heute
                   -1 * coalesce(ak_min,0)       AS bzuab,   -- Von -1 * Mindestbestand ausgehen oder 0 nehmen. Wenn 0 und nichts aus anderen Queries kommt, wird der Satz nicht eingefügt.
                   IfThen(coalesce(ak_min,0)>0,
                       lang_text(564),
                       lang_text(505))           AS bldsauf, -- "Lagerbestand" bzw. "Mindestbestand"
                   null::varchar                 AS bauftg,  -- Text woher das kommt z.Bsp: ORDER E 23000123 10
                   null::integer                 AS ldid,    -- Bedarfswirksame Bestellung
                   null::integer                 AS agid,    -- Bedarfswirksamer Auftrag
                   null::integer                 AS bapid,   -- Bedarfswirksame Banf (also mit angegebenem Termin und keine Anfrage)
                   current_date                  AS bbestdat,-- Vorgezogenes Bestelldatum (Liefertermin - Beschaffungsfrist aus art)
                   null::date                    AS date_liefer -- Lieferdatum an Lieferanten
              FROM art AS akmintot
             WHERE ak_nr = _aknr
               AND (    (round(coalesce(ak_tot, 0), 8) <> 0)
                    OR  (round(coalesce(ak_min, 0), 8) <> 0)
                   )
            --

            -- UNION  --------- Sperrlager abziehen -------------------------------------------------------------------------------
            -- Sperrlager (die verfügbar sind) nicht mehr abziehen aufgrund von ausschließlicher Berücksichtigung der Verfügbarkeit (ist schon in ak_tot), siehe #7381.
            --

            UNION  ---------Bestellungen (Intern, Extern und Rahmen) -------------------------------------------------------------------------------

            SELECT 10, -- Bestellung = Reihenfolge 1, d.h. vor Auftrag und BANF. Da Rahmenbestellungen mit '2099-01-01' angelegt werden, kommen die automatisch immer als letztes

                   -- Kein Bestelltermin oder Termin schon vergangen => Heute nehmen.
                   -- Bei Rahmenbestellung in Zukunft, damit Bestellvorschlag immer nur Abrufe berücksichtigt.
                   CASE WHEN (ld_pos = 0 OR ld_code = 'R') THEN
                             '2099-01-01'::date
                        ELSE
                              greatest(
                                coalesce(
                                    -- falls Teillieferungen angegeben sind, dann Termine der Teillieferpositionen nehmen
                                    coalesce(ldl_terml,
                                             ldl_term),
                                    -- ... sonst Termin der Bestellposition nehmen
                                    coalesce(ld_termv,
                                             ld_terml,
                                             ld_term,
                                             termweek_to_date( coalesce(ld_termweekl, ld_termweek) ),
                                             current_date)
                                  ),
                                  current_date
                              )
                   END,

                   -- Offene Menge der Bestellposition oder Restmenge des Rahmens
                   CASE WHEN (ld_pos = 0 OR ld_code = 'R') THEN
                             (rahmen_stk_ldsdok_offen(ld_auftg || '/' || ld_pos)).stko
                        ELSE
                              numeric_larger( (coalesce(
                                                  -- falls Teillieferungen angegeben sind, dann zugehörige Mengen nehmen
                                                  tartikel.me__menge__in__menge_uf1(ld_mce, ldl_stk),
                                                  -- ... sonst Menge der Bestellposition
                                                  ld_stk_soll_uf1,
                                                  ld_stk_uf1)
                                               -
                                               coalesce(
                                                  -- falls Teillieferungen angegeben sind, dann zugehörige gelieferte Mengen nehmen
                                                  tartikel.me__menge__in__menge_uf1(ld_mce, ldl_stkl),
                                                  -- ... sonst gelieferte Menge der Bestellposition
                                                  ld_stkl) ), 0 )
                   END,

                   'ORDER  ' || ld_code || '  ' || ld_auftg || '  ' || ld_pos,

                   ld_auftg, ld_id, null, null, 
                   null,
                   null
              FROM ldsdok
              LEFT JOIN ldslieferung ON ldl_ld_id = ld_id
                                    AND NOT ldl_done
                                    AND ld_pos <> 0
                                    AND ld_code <> 'R'
             WHERE ld_aknr = _aknr
               AND NOT ld_done
               AND NOT ld_nbedarf
               AND ld_stk <> 0
               AND ld_stk_uf1 > ld_stkl
              -- AND ((ld_code IN ('E', 'I') AND ld_pos>0) OR twawi.ldsdok__ld_pos0defini())
            --

            UNION  ---------Aufträge (Intern, Extern und Rahmen) -------------------------------------------------------------------------------

            SELECT 20, -- Aufträge werden nach Bestellungen einsortiert (wenn die am gleichen Tag Bedarf verursachen)

                   -- Normale Aufträge immer für heute, wenn kein Liefertermin gegeben ist.
                   -- Rahmenaufträge zum Liefertermin. Oder in Zukunft, damit Bestellvorschlag immer nur Abrufe berücksichtigt.
                   CASE WHEN (ag_pos = 0 OR ag_astat = 'R' ) THEN
                             '2099-01-01'::date --Rahmen
                        ELSE
                             greatest(
                                 coalesce(-- ag_termv, > ist im Verkauf das zuerst bestätigte Lieferdatum
                                          ag_aldatum,
                                          ag_ldatum,
                                          ag_kdatum,
                                          termweek_to_date(ag_twa)
                                 ),
                                 current_date
                             ) --normale Pos
                   END,

                   -- Offene Menge der Auftragsmenge oder Restmenge des Rahmens, als negativer Betrag
                   CASE WHEN (ag_pos = 0 OR ag_astat = 'R' )
                   THEN -1 * tauftg.auftgr__rahmen_info__stko_offen__by__ag_id__get(ag_id)
                   ELSE -1 * numeric_larger( (ag_stk_uf1 - ag_stkl), 0 )
                   END,

                   -- Keine übergeordnete ABK => Als Auftrag kennzeichnen, sonst als Projekt-ABK
                   CASE WHEN (ag_parentabk) IS null THEN
                             'AUFTG  ' || ag_astat || '  ' || ag_nr || '  ' || ag_pos
                        ELSE
                             coalesce('P ' || ag_an_nr || '  |  ', '') || lang_text(105) || ' ' || ag_parentabk
                   END,

                   ag_nr, null, ag_id, null,

                   -- Bestelldatum: Liefertermin abzüglich der Beschaffungsfrist
                   CASE WHEN (ag_pos = 0 OR ag_astat = 'R' ) THEN
                             '2099-01-01'::date
                        ELSE
                             timediff_substdays(
                                  coalesce(least(ag_aldatum,
                                                 ag_ldatum,
                                                 ag_kdatum,
                                                 termweek_to_date(ag_twa)
                                           ),
                                           current_date
                                  ),
                                  artrec.ak_bfr,
                                  true
                             )
                   END
                   -- Liefertermin an Lieferant
                   ,
                   IFTHEN(ag_astat = 'I', ag_kdatum, null)
              FROM auftg LEFT JOIN auftgmatinfo ON agmi_ag_id = ag_id 
                         LEFT JOIN abk ON ab_ix = ag_parentabk
                      -- LEFT JOIN art artrec ON ak_nr = ag_aknr -- rauskopieren und direkt debug im sql abfragen
             WHERE ag_aknr = _aknr
               AND (ag_astat IN ('E', 'I', 'R'))  --keine Angebote!
               AND coalesce(ab_doeinkauf AND ( (NOT EXISTS (SELECT true FROM ab2 WHERE a2_ab_ix = ab_ix)) OR ab_inplantaf ), true) -- keine AG bei Beistellung usw.
               AND NOT coalesce(agmi_beistell, false)
               AND NOT ag_done
               AND NOT ag_nbedarf
               AND ag_stk <> 0
               AND ag_stk_uf1 >= ag_stkl
            --

            UNION  ---------Bestellanforderungen (nur die mit Liefertermin) -------------------------------------------------------------------------------

            SELECT 30,  -- Banf werden nach Bestellungen und Aufträgen einsortiert (wenn die am gleichen Tag Bedarf verursachen)
                   -- Hinweis: Rahmen werden bei BANF nicht auf 2099 gesetzt, da Rahmen durch den BV bestellt werden!
                   CASE WHEN bap_rahmen THEN
                             '2099-01-01'::date
                        ELSE
                             greatest(
                                  coalesce(
                                      bap_termin,
                                      termweek_to_date(bap_termweek)
                                  ),
                                  current_date
                             )
                   END,
                   -- Menge geht negativ ein
                   -1 * coalesce(bap_menge_uf1, bap_menge),
                   --
                   'BANF  ' || bap_banr || '  ' || bap_pos,
                   --
                   bap_agnr, null, null, bap_id,
                   -- Bestelldatum
                   timediff_substdays(
                        CASE WHEN bap_rahmen THEN
                             '2099-01-01'::date
                        ELSE
                              coalesce(
                                  bap_termin,
                                  termweek_to_date(bap_termweek)
                              )
                        END,
                        -- Beschaffungsfrist abziehen
                        artrec.ak_bfr,
                        true
                   ),
                   null
              FROM BestAnfPos JOIN BestAnfTxt ON bap_banr = ba_nr
             WHERE     bap_aknr = _aknr
               AND NOT bap_done
               AND bap_doeinkauf
               -- es gehen nur banfen mit Termin ein! TODO: alternativ wie alles 2099?
               AND NOT (bap_termin IS null AND bap_termweek IS null)
               AND     bap_menge <> 0
               AND NOT bap_anfrage
               AND NOT ba_prognose --Bestellanforderungen ohne Prognosen, diese errechnen sich auf Monatszyklus-eben als nächstes
            --

            UNION  ---------Bestellanforderungen (nur die mit Liefertermin), welche Prognosen sind! -------------------------------------------------------

            SELECT type, --40 in Funktion, kann hierher verlagert werden!
                   date,
                   bewegung AS zuab,
                   descr AS bldsauf,
                   null, --bauftg
                   null, --ldid
                   null, --agid
                   bapid,
                   timediff_substdays(date, artrec.ak_bfr, true), --bestdat
                   null
              FROM tartikel.bedarf_prognose(_aknr)
        ) AS bedarfe

          LEFT JOIN art ON ak_nr = _aknr

        -- Damit fischen wir die Sätze raus, für die kein Bedarfseintrag da ist, d.h. also auch keine Lagerbestände oder Mindestbestände vorhanden.
        WHERE (ROUND(COALESCE(bzuab,0),8) <> 0) OR (ROUND(COALESCE(ak_tot,0),8)<>0)

        /* ACHTUNG: Wenn das ORDER BY  hier angepasst wird müssen UNBEDINGT BEID"(sum(bzuab) OVER ( ORDER BY  ... " mit angepasst werden,
        sonst geht alles auf die schlimmstmögliche Weise kaputt, der Himmel sich verdunkeln, es beginnen Frösche zu regnen etc. pp.*/
        ORDER BY bdate, orderby, bldsauf, bauftg;


        RAISE NOTICE 'End.TArtikel.Bedarf__make_bedarf: %, Duration:%, Start:%, Leave:%', _aknr, clock_timestamp()::time - _start_time, _start_time, clock_timestamp()::time;

        RETURN;
      END $$ LANGUAGE plpgsql;
--


CREATE OR REPLACE FUNCTION tartikel.artoption_arts__aknr__get(
  IN _aknr varchar,
  IN _with_alternative_art boolean = false
  ) 
  RETURNS SETOF varchar 
  AS $$
  
    -- ermittelt alle Alternativen zum übergebene Artikel
    -- einschließlich des Artikels selbst
  
    SELECT aoa_ak_nr FROM (
      SELECT
        1 AS sort,
        _aknr AS aoa_ak_nr
  
      UNION
  
      SELECT
        2 AS sort,
        aoa_ak_nr
      FROM artoption_arts
      WHERE aoa_g_ak_nr = _aknr AND _with_alternative_art
    ) AS x
    ORDER BY sort ASC, aoa_ak_nr ASC;
  
  $$ LANGUAGE sql STRICT STABLE;
--

-- Rückgabetyp für tartikel.art__lag__lg_anztot__by__inputparams
CREATE TYPE tartikel.art__lag__lg_anztot__result_type AS (
    lgid          integer,
    lgort         varchar,
    lgchnr        varchar,
    lganztot      numeric
);


CREATE OR REPLACE FUNCTION tartikel.art__lag__auftg__bedarf__is( _lag lag, _ag_id integer ) RETURNS integer AS $$
  DECLARE
    _ld_id integer;
    _la_ag_ids integer[];
  BEGIN
  
    -- #19648 prüft, ob der gelagerte Artikel zur Deckung des Bedarfs des Auftrags vorgesehen ist
    -- mögliche Rückgabewerte:
    --    1 : Lagerposition gehört zur Bedarfsdeckung des übergebenen Auftrags
    --    0 : Lagerposition gehört zu keiner Bedarfsdeckung
    --   -1 : Lagerposition gehört nicht zur Bedarfsdeckung dieses Auftrags, aber zu der eines anderen
  
    IF _lag IS null OR _ag_id IS null THEN
      RETURN 0;
    END IF;
  
    -- Suche alle Aufträge heraus, für welche diese Lagerposition zur Bedarfsdeckung vorgesehen ist.
    _ld_id := _lag.lg_ld_id;
    _la_ag_ids := array_agg( la_ag_id ) FROM ldsauftg WHERE la_ld_id = _ld_id AND la_ag_id IS NOT null;
  
    -- Keine Aufträge als Bedarfsverursacher? Dann gib 0 zurück.
    IF _la_ag_ids IS null THEN
      RETURN 0;
    END IF;
  
    -- Ist der übergebene Auftrag in der Liste der Bedarfsverursacher, dann gib 1 zurück.
    -- Gibt es zwar bedarfsverursachende Aufträge zur Lagerposition, der übergebene ist aber nicht dabei, dann gib -1 zurück.
    IF _ag_id = ANY( _la_ag_ids ) THEN
      RETURN 1;
    ELSE
      RETURN -1;
    END IF;
  
  END $$ LANGUAGE plpgsql STABLE;
--

-- Sucht einen passenden Lagerort nach Lagerstrategie
-- Berücksichtigt sämtliche Logiken: Zwischenlagerort, Direktversand, automatisches Buchen (bevorzugt auf ABK) etc
CREATE OR REPLACE FUNCTION tartikel.art__lag__lg_anztot__by__inputparams(
    IN  _aknr         varchar,
    IN  _beistell     bool    = false,  -- > agmi_beistell obsolet wenn _auftg_ag_id richtig aufgebaut wird
    IN  _direktlief   bool    = false,  -- > auftgmatinfo...v_stat obsolet wenn _auftg_ag_id richtig aufgebaut wird
    IN  _agnr_for_zwischenlagerort varchar = null, -- > ab_nr??? obsolet wenn _auftg_ag_id richtig aufgebaut wird
    IN  _forcelgort   varchar = null,
    IN  _preferABK    integer = null, -- > ag_ownabk obsolet wenn _auftg_ag_id richtig aufgebaut wird
        -- Materiallistenposition Auftrag. zB für Lagerabgang UE um Chargennummer zu erzwingen, also das Teil auszubuchen was auch zur Materialliste gehört!
    IN  _auftg_ag_id  integer = null,
    IN  _blacklist    integer[] = null, -- Parameter, der bestimmte Lagerorte von der Suche ausschließen soll, siehe tartikel.art__lag__lg_anztot__by__inputparams_all
    IN  _vorzug_bedarfsverursacher_gebunden boolean = true -- Sollen Lagerorte zu gebundenen Bedarfsverursachen bevorzugt werden?
    )
    RETURNS tartikel.art__lag__lg_anztot__result_type
    AS $$
    DECLARE
        _zwilagort        varchar;
        _preferABK_lg_id  integer;
        _agmi_lg_chnr     varchar;
        _isuebuchung      boolean = false;
        _lgid             integer;
        _lgort            varchar;
        _lgchnr           varchar;
        _lganztot         numeric;
    BEGIN
      IF _aknr IS null THEN
         RETURN null;
      END IF;

      _forcelgort := NullIf(_forcelgort, '');

      --1.: wenn wir für eine bestimmte ABK suchen, versuchen wir das Material als erstes zu nehmen, was auch innerhalb der ABK generiert wurde
      IF _preferABK IS NOT null THEN
          --wir versuchen, ob für den gewünschten Artikel ein Lagerbestand unter der angegebenen ABK existiert
          SELECT lg_id INTO _preferABK_lg_id
            FROM lag
           WHERE lg_ld_id = (SELECT ld_id
                               FROM ldsdok
                              WHERE ld_abk = _preferABK
                             )
             AND lg_anztot > 0
        ORDER BY lg_lagzudat ASC,
                 lg_chnr ASC
           LIMIT 1;
      END IF;

      -- Vorgabecharge holen
      IF _auftg_ag_id IS NOT NULL THEN
         SELECT agmi_lg_chnr,  TSystem.ENUM_GetValue(ag_stat, 'UE')
           INTO _agmi_lg_chnr, _isuebuchung
           FROM auftg JOIN auftgmatinfo ON agmi_ag_id = ag_id
          WHERE ag_id = _auftg_ag_id;
      END IF;

      -- es soll ein bestimmter lagerort benutzt werden => zB Montagelager
      IF _forcelgort IS NOT null THEN
         _zwilagort := _forcelgort;
      ELSE
          IF _agnr_for_zwischenlagerort IS NOT null THEN --Zwischenlagerort suchen
              SELECT lg_ort INTO _zwilagort
                FROM lag JOIN lagerortUE ON lg_ort = lue_lgort AND lg_aknr = _aknr
               WHERE lue_agnr = _agnr_for_zwischenlagerort
               LIMIT 1;
          END IF;
      END IF;

      --
      SELECT lg_id, lg_ort, lg_chnr, lg_anztot INTO _lgid, _lgort, _lgchnr, _lganztot
        FROM lag
             JOIN art ON ak_nr = lg_aknr
        LEFT JOIN LATERAL (SELECT lagerorte__get_setup._beistell AS lgobeistell,
                                  lagerorte__get_setup._verfgbar AS lgoverfgbar
                             FROM lagerorte__get_setup(lg_ort)
                           ) AS lagerorte__get_setup ON true
       WHERE lg_aknr = _aknr
             -- vom Beistelllagerort vorschlagen
         AND ifthen(_beistell,  lg_ort LIKE ANY (SELECT lgo_name FROM lagerorte WHERE lgo_beistell), true)
             -- vom Diektlieferlager vorschlagen (Direktlieferung => direkt vom Lieferant zur Baustelle, intern nur virtuelles Buchungslager)
         AND ifthen(_direktlief, lg_ort = TSystem.Settings__Get('lgortdirekt'),   true)

         AND ifthen(_zwilagort IS NOT null, lg_ort LIKE _zwilagort, true)
         AND ifthen(_zwilagort IS null AND _preferABK_lg_id IS NOT null, lg_id LIKE _preferABK_lg_id, true)

             -- Vorgabecharge muss stimmen
         AND ifthen(_agmi_lg_chnr IS NOT NULL, lg_chnr = _agmi_lg_chnr, true)
         AND (    -- NICHT UE Buchungen NIE von Sperrlagern
                 (_isuebuchung IS false AND lg_sperr IS false)
                  -- UE Buchungen NUR von Sperrlagern
              OR (_isuebuchung          AND lg_sperr)
              )
         AND ( _blacklist IS null OR lg_id <> ALL( _blacklist ))
       ORDER BY
         NOT coalesce(lgobeistell, true),
         NOT coalesce(lgoverfgbar, false),
         lg_anztot = 0,

         -- zunächst Lagerorte verwenden, die keine Standardlagerorte des Artikels sind
         lg_ort IS DISTINCT FROM ak_slort,

         -- #19648 Lagerorte zur Bedarfsdeckung des Auftrags werden bevorzugt
         --        Lagerorte zur Bedarfsdeckung eines anderen Auftrags werden hintangestellt
         -- #20353 Dies aber nur, wenn gebundenen Bedarfsverursacher überhaupt eine Rolle spielen sollen.
         CASE WHEN coalesce( _vorzug_bedarfsverursacher_gebunden, true )
           THEN tartikel.art__lag__auftg__bedarf__is( lag, _auftg_ag_id )
           ELSE null
         END DESC,

         -- FIFO-Prinzip, älteste Einlagerung zuerst
         lg_lagzudat ASC,
         lg_chnr --Änderung DS: 2013-05-27: ODER BY lg_lagzudat DESC=>ASC, FIFO: ältester Lagerort zuerst ausbuchen
       LIMIT 1;

      --
      IF _lgort IS null AND _beistell THEN
          _lgort := TSystem.Settings__Get('lgortbeistell');
      END IF;
      IF _lgort IS null AND _direktlief THEN
          _lgort := TSystem.Settings__Get('lgortdirekt');
      END IF;
      -- Wenn kein Lagerort gefunden und _forcelgort, dann lieber nichts übergeben, damit gefüllt werden muss.
      -- Achtung! Lagerort '' gibts auch.
      -- zu überlegen wäre auch 'kein passenden Lagerort gefunden' oder so zu übergeben.
      -- Vgl. RBL
      -- IF r.lgort IS null AND _forcelgort IS NOT null THEN
      --     r.lgort:=_forcelgort;
      -- END IF;
      IF _lganztot IS null THEN
          _lganztot := 0;
      END IF;
      --

      RETURN ( _lgid, _lgort, _lgchnr, _lganztot ) :: tartikel.art__lag__lg_anztot__result_type;

    END $$ LANGUAGE plpgsql STABLE;
--

CREATE OR REPLACE FUNCTION tartikel.art__lag__lg_anztot__by__inputparams(
    IN _auftg auftg,
    IN _auftgmatinfo auftgmatinfo,
    IN _forcelgort varchar = null,
    IN _vorzug_bedarfsverursacher_gebunden boolean = true
    )
    RETURNS tartikel.art__lag__lg_anztot__result_type
    AS $$
       SELECT * FROM tartikel.art__lag__lg_anztot__by__inputparams(
                        _auftg.ag_aknr,
                        _auftgmatinfo.agmi_beistell,
                        -- direktlieferung
                        (SELECT v_stat = 'L' FROM versart WHERE v_id = _auftgmatinfo.agmi_v_id),
                        _auftg.ag_nr,
                        -- vorgabe lagerort
                        coalesce(_auftgmatinfo.agmi_lg_ort, _forcelgort),
                        _auftg.ag_ownabk,
                        _auftg.ag_id,
                        null,
                        _vorzug_bedarfsverursacher_gebunden
                     );
    $$ LANGUAGE sql STABLE;
--


-- gibt alle zum Lagerorte des Artikels zurück, Anordnung entsprechend der Lagerstrategie
CREATE OR REPLACE FUNCTION tartikel.art__lag__lg_anztot__by__inputparams_all(
  IN  _aknr         varchar,
  IN  _beistell     bool    = false,  -- > agmi_beistell obsolet wenn _auftg_ag_id richtig aufgebaut wird
  IN  _direktlief   bool    = false,  -- > auftgmatinfo...v_stat obsolet wenn _auftg_ag_id richtig aufgebaut wird
  IN  _agnr_for_zwischenlagerort varchar = null, -- > ab_nr??? obsolet wenn _auftg_ag_id richtig aufgebaut wird
  IN  _force_lgort  varchar = null,
  IN  _preferABK    integer = null, -- > ag_ownabk obsolet wenn _auftg_ag_id richtig aufgebaut wird
      -- Materiallistenposition Auftrag. zB für Lagerabgang UE um Chargennummer zu erzwingen, also das Teil auszubuchen was auch zur Materialliste gehört!
  IN  _auftg_ag_id  integer = null,
  IN _vorzug_bedarfsverursacher_gebunden boolean = true
  )
  RETURNS SETOF tartikel.art__lag__lg_anztot__result_type
  AS $$
  DECLARE
    _lag_result tartikel.art__lag__lg_anztot__result_type;
    _lagid_blacklist integer[];
    _count integer;
  BEGIN

    -- Die Ergebnismenge wird erstellt, indem wiederholt tartikel.art__lag__lg_anztot__by__inputparams aufgerufen wird.
    -- Und das solange, bis kein passender Lagerort mehr gefunden wird.
    -- Um zu vermeiden, dass bei einem erneuten Aufruf von tartikel.art__lag__lg_anztot__by__inputparams ein bereits gelieferter Lagerort
    --   erneut zurückgegeben wird, werden die bekannten Lagerorte in einer schwarzen Liste gesammelt.
    _lagid_blacklist := ARRAY[]::integer[];
    _count := 0;

    LOOP

      -- Absicherung gegen Endlosschleifen
      _count := _count + 1;
      IF _count >= 100 THEN
        EXIT;
      END IF;

      -- Lagerorte, die nicht in der Blacklist stehen, einsammeln
      _lag_result :=
        ( lgid, lgort, lgchnr, lganztot ) :: tartikel.art__lag__lg_anztot__result_type
        FROM tartikel.art__lag__lg_anztot__by__inputparams(
          _aknr,
          _beistell,
          _direktlief,
          _agnr_for_zwischenlagerort,
          _force_lgort,
          _preferABK,
          _auftg_ag_id,
          _lagid_blacklist,
          _vorzug_bedarfsverursacher_gebunden
        );

      -- Abbruch, wenn nichts mehr gefunden wird
      IF _lag_result IS null OR _lag_result.lgid IS null THEN
        EXIT;
      END IF;

      -- Blacklist ergänzen
      _lagid_blacklist := array_append( _lagid_blacklist, _lag_result.lgid );
      RETURN NEXT _lag_result;

    END LOOP;

    END $$ LANGUAGE plpgsql STABLE;
--


--
CREATE OR REPLACE FUNCTION tartikel.bestand_abgleich(aknr VARCHAR) RETURNS VOID AS $$
  BEGIN
    --LOCK TABLE art IN EXCLUSIVE MODE nowait;
    PERFORM disablemodified();

    PERFORM tartikel.bestand_abgleich_intern(aknr);-- FROM art WHERE ak_nr LIKE aknr;
    PERFORM tartikel.bedarf__make_bedarf(ak_nr) FROM art WHERE ak_nr LIKE aknr;

    PERFORM enablemodified();
    RETURN;
  END $$ LANGUAGE plpgsql;
--

--
CREATE OR REPLACE FUNCTION tartikel.bestand_abgleich_intern(aknr VARCHAR) RETURNS VOID AS $$
  DECLARE no_neg_lag BOOLEAN;
          _start_time time;
  BEGIN   
    PERFORM disablemodified();

    _start_time := clock_timestamp()::time;

    no_neg_lag:= TSystem.Settings__GetBool('no_neg_lag');

    UPDATE art SET
        -- Verkauft
        ak_res= COALESCE((
            SELECT SUM(CASE WHEN (ag_pos = 0 OR ag_astat = 'R') THEN tauftg.auftgr__rahmen_info__stko_offen__by__ag_id__get(ag_id) ELSE numeric_larger( (ag_stk_uf1 - ag_stkl), 0 ) END) -- CASE schneller als ifthen wegen inneren Funktionsaufruf
            FROM auftg LEFT JOIN auftgmatinfo ON agmi_ag_id = ag_id
            WHERE ag_aknr = ak_nr
              AND ag_astat <> 'A'
              AND (ag_astat <> 'R' OR twawi.auftg__ag_pos0defini())
              AND (ag_pos > 0 OR twawi.auftg__ag_pos0defini())
              AND NOT ag_done
              AND NOT ag_nbedarf
              AND NOT COALESCE(agmi_beistell, false)
              AND ag_stk_uf1 > ag_stkl
            )::NUMERIC(19,4), 0),
        -- Bestellt
        ak_bes = COALESCE((
            SELECT SUM(CASE WHEN (ld_pos = 0 OR ld_code = 'R') THEN (rahmen_stk_ldsdok_offen(ld_auftg || '/' || ld_pos)).stko ELSE numeric_larger( (coalesce(ld_stk_soll_uf1, ld_stk_uf1) - ld_stkl), 0 ) END)
            FROM ldsdok
              WHERE ld_aknr = ak_nr
              AND ld_code <> 'A'
              AND ld_code <> 'Z'
              AND (ld_code <> 'R' OR twawi.ldsdok__ld_pos0defini())
              AND (ld_pos > 0 OR twawi.ldsdok__ld_pos0defini())
              AND NOT ld_done
              AND NOT ld_nbedarf
              AND COALESCE(ld_stk_soll_uf1, ld_stk_uf1) > ld_stkl
            )::NUMERIC(19,4), 0),
        -- Lagernd
        ak_tot= COALESCE((
            SELECT SUM(lg_anztot) -- alle Lagermengen mit Verfügbarkeit
            FROM lag LEFT JOIN LATERAL lagerorte__get_setup(lg_ort) ON true
            WHERE lg_aknr = ak_nr
              AND CASE WHEN no_neg_lag THEN (lg_anztot > 0 OR lg_ort = 'MINUS') ELSE true END
              AND COALESCE(_verfgbar, NOT lg_sperr, true) -- vgl. TArtikel.art__lag__lg_anztot__get__nverfueg. Gesperrte LO ohne StandardLO-Bezug gelten als nicht verfügbar. Vgl. ebenso #7381.
            )::NUMERIC(19,4), 0)
        -- Verfügbar
        -- ak_verfueg wird per Trigger art__b_10_iu gesetzt (ak_tot + ak_bes - ak_res - ak_min).
    WHERE ak_nr LIKE aknr;

    PERFORM enablemodified();

    RAISE NOTICE 'bestand_abgleich_intern: %, Duration:%, Start:%, Leave:%', aknr, clock_timestamp()::time - _start_time, _start_time, clock_timestamp()::time;

    RETURN;
  END $$ LANGUAGE plpgsql;
--

-- Funktion führt Bestandsabgleich und Bedarfsberechnung für alles in 10 Threads aus. Wird von Application-Server aufgerufen, kann manuell aufgerufen werden
CREATE OR REPLACE FUNCTION tartikel.bestand_abgleich__all__background(
    IN _ak_nr                    varchar = '%'
    )
    RETURNS                      boolean
    AS $$
    DECLARE
        r                        record;
        e                        boolean;
        ident                    varchar;
        I                        integer;
        APPNAME                  varchar = 'PRODAT-ERP-ART-BESTANDABGL(' || current_database() || ')';
        ConnectionName_BaseName  varchar = 'bestand_abgleich__all__background_';
        ConnectionName_Free      varchar;
        num_connections          integer = 10;
        debug_s                  varchar;
    BEGIN
      e := true;

      PERFORM TSystem.LogDebug( 'BEGIN', logtype => 'pltProfiling' );

      PERFORM pg_terminate_backend(pid)
         FROM pg_stat_activity
        WHERE datname = current_database()
          AND application_name = APPNAME;

      --Connections aufbauen
      FOR i IN 0..num_connections-1 LOOP
          ConnectionName_Free := ConnectionName_BaseName || current_database() || '_' || chr(65 + I); -- Buchstaben A..D

          -- Falls Connection aus irgendeinem Grund noch vorhanden, jetzt hart schliessen
          IF ConnectionName_Free = ANY(dblink_get_connections()) THEN
              RAISE WARNING 'tartikel.bestand_abgleich__all__background: LOOP=%, Connection still active, closing:"%"    (Connections:%)', i, ConnectionName_Free, dblink_get_connections();
              BEGIN
                  PERFORM dblink_disconnect( ConnectionName_Free );
              EXCEPTION WHEN others THEN
                  RAISE WARNING 'tartikel.bestand_abgleich__all__background(): ERROR ON dblink_disconnect %', ConnectionName_Free USING DETAIL = SQLERRM;
              END;
          END IF;

          -- Connection aufbauen und Statement Timeout
          PERFORM dblink_connect_u(ConnectionName_Free, 'dbname=' || current_database() || /*' host='||inet_client_addr()||*/' port=' || inet_server_port() || ' user=APPS password=Application-Server application_name=' || quote_literal(APPNAME));
          PERFORM dblink_exec(ConnectionName_Free, 'SET statement_timeout=30000', true);
      END LOOP;

      -- durch alle View laufen und Refresh
      FOR r IN
          SELECT ak_nr
            FROM art
           WHERE ak_nr LIKE _ak_nr
           ORDER BY
                 ak_nr
      LOOP
          BEGIN
              -- Name Cached View, welche aktualisiert werden soll
              ident := r.ak_nr;

              -- Endlosschleife, wird durch EXIT verlassen. Connection abwarten und Asyncrones View Refresh aufrufen
              LOOP
                  FOR i IN 0..num_connections-1 LOOP -- versuchen eine freie Connection zu bekommen
                      ConnectionName_Free := ConnectionName_BaseName || current_database() || '_' || chr(65 + I);

                      IF dblink_is_busy(ConnectionName_Free) = 0 THEN
                          PERFORM * FROM dblink_get_result(ConnectionName_Free, false) AS CachedViews_Refresh(Result VARCHAR); -- GetResult

                          -- Once again >> This function must be called if dblink_send_query returned 1.
                          -- It must be called once for each query sent, and one additional time to obtain an empty set result, before the connection can be used again.
                          PERFORM * FROM dblink_get_result(ConnectionName_Free, false) AS CachedViews_Refresh(Result VARCHAR);

                          -- RAISE NOTICE 'TRY EXECUTE ON % - %', ConnectionName_Free, ident;

                          PERFORM dblink_send_query( ConnectionName_Free, 'SELECT tartikel.bestand_abgleich('||quote_literal(ident)||')' ) AS CachedViews_Refresh;

                          -- RAISE NOTICE 'EXECUTE ON %', ConnectionName_Free;

                          EXIT; -- Connection bekommen, Schleife verlassen
                      END IF;

                      ConnectionName_Free := 'X';
                  END LOOP;


                  -- Wenn keine Verbindung erhalten,
                  -- dann auf Ausführung der laufenden Refreshs warten (gemittelt) und erneut Connection versuchen.
                  IF ConnectionName_Free = 'X' THEN

                      RAISE NOTICE 'tartikel.bestand_abgleich__all__background: No Free Connection';

                      PERFORM pg_sleep( 0.02 );

                  -- Sonst Verbindung für async. Refresh des VIEWs erhalten und nächsten VIEW angehen.
                  ELSE
                      EXIT;
                  END IF;

              END LOOP; -- Endlosschleife, muss durch EXIT verlassen werden

          EXCEPTION WHEN others THEN
              RAISE WARNING 'bestand_abgleich__all__background(): ERROR ON REFRESH %', ident USING DETAIL = SQLERRM;
              e := false;
          END;
      END LOOP;

      -- alle Connections schließen
      FOR i IN 0..num_connections-1 LOOP
          ConnectionName_Free := ConnectionName_BaseName || current_database() || '_' || chr(65 + I);

          -- Ergebnis abrufen. False => Ignore Error
          PERFORM * FROM dblink_get_result(ConnectionName_Free, false) AS CachedViews_Refresh(Result VARCHAR); -- GetResult

          -- Once again >> This function must be called if dblink_send_query returned 1.
          -- It must be called once for each query sent, and one additional time to obtain an empty set result, before the connection can be used again.
          PERFORM * FROM dblink_get_result(ConnectionName_Free, false) AS CachedViews_Refresh(Result VARCHAR);

          PERFORM dblink_disconnect(ConnectionName_Free);
      END LOOP;

      PERFORM TSystem.LogDebug( 'END', logtype => 'pltProfiling' );

      RETURN e;
    END $$ LANGUAGE plpgsql;
--

-- Gibt Artikelnummer ohne Index zurück. Wenn Suchstring true, dann mit % am Ende, für Suche aller Artikel unabhängig des Index'.
CREATE OR REPLACE FUNCTION tartikel.art__ak_nr__index(IN ak_nr VARCHAR, IN searchstring BOOLEAN DEFAULT true) RETURNS VARCHAR AS $$
  DECLARE aknr VARCHAR;
          indexchar VARCHAR;
          posindexchar INTEGER;
  BEGIN
    indexchar := TSystem.sessionvar__get_varchar('akindex', 'NULL');

    IF indexchar = 'NULL' THEN
      indexchar := TSystem.Settings__Get('akindex');
      PERFORM TSystem.sessionvar__set_varchar('akindex', indexchar, _as_tx_var => False);
    END IF;

    IF COALESCE(indexchar, '') = '' THEN RETURN ak_nr; END IF;  -- Kein IndexChar definiert, dann raus.
    IF StrPos(ak_nr, '%') > 0       THEN RETURN ak_nr; END IF;  -- Wildcard für Suche in Artikel, dann raus.
    IF StrPos(ak_nr, 'Ø') > 0       THEN RETURN ak_nr; END IF;  -- Artikel mit Durchmesserzeichen (Material), dann raus.

    posindexchar:= StrPos(reverse(ak_nr), indexchar);

    IF (posindexchar = 0) OR (posindexchar > 3) THEN RETURN ak_nr; END IF; -- Kein Index in Artikelnummer, dann raus.

    IF posindexchar = 1 THEN -- Indextrenner ist letztes Zeichen, dass heißt der Index ist eingerahmt vom Trenner, z.B. 123'A'.
        posindexchar:= StrPos(reverse(SubStr(ak_nr, 1, Length(ak_nr)-1)), indexchar) + 1;
    END IF;

    aknr:= SubStr(ak_nr, 1, TSystem.IFTHEN(ak_nr LIKE '%' || indexchar || '%', Length(ak_nr) - posindexchar, 100)::INTEGER);

    IF searchstring THEN -- Wenn Suchstring gewünscht, dann anhängen.
        aknr:= aknr || indexchar || '%';
    ELSE
        aknr:= rtrim(aknr); -- sonst nur störende Leerzeichen rechts entfernen.
    END IF;

    RETURN aknr;
  END $$ LANGUAGE plpgsql IMMUTABLE; -- nur IMMUTABLE, wenn TSystem.Settings__Get('akindex') sich nicht ändert.

  CREATE OR REPLACE FUNCTION Z_99_Deprecated.artikel_index(IN ak_nr VARCHAR, IN searchstring BOOLEAN DEFAULT true) RETURNS VARCHAR AS $$
    SELECT tartikel.art__ak_nr__index(ak_nr, searchstring);
    $$ LANGUAGE sql;
-- Gibt Index der Länge 1 zurück
CREATE OR REPLACE FUNCTION tartikel.art__ak_nr__index__GetIndexString1(IN aknr VARCHAR) RETURNS VARCHAR AS $$
    SELECT SubStr(aknr, StrPos(aknr, TSystem.Settings__Get('akindex'))+1, 1);
   $$ LANGUAGE sql IMMUTABLE;
  CREATE OR REPLACE FUNCTION Z_99_Deprecated.artikel_index_char(IN aknr VARCHAR) RETURNS VARCHAR AS $$
   SELECT tartikel.art__ak_nr__index__GetIndexString1(aknr);
   $$ LANGUAGE sql;

-- Gibt Index beliebiger Länge zurück
CREATE OR REPLACE FUNCTION tartikel.art__ak_nr__index__GetIndexStringFull(IN aknr VARCHAR) RETURNS VARCHAR AS $$
  DECLARE indexchar VARCHAR;
          part INTEGER;
  BEGIN
    indexchar:= TSystem.Settings__Get('akindex');
    CASE strpos(reverse(aknr), indexchar)
        WHEN 0 THEN -- kein Indextrenner vorhanden
            RETURN '';
        WHEN 1 THEN -- Indextrenner ist letztes Zeichen. D.h. der Index ist eingerahmt vom Trenner, zB 123'A'.
            part:= 2;
        ELSE -- sonst Indexzeichen vor Index
            part:= 1;
    END CASE;

    RETURN reverse(split_part(reverse(aknr), indexchar, part));
  END $$ LANGUAGE plpgsql IMMUTABLE;
  CREATE OR REPLACE FUNCTION Z_99_Deprecated.artikel_index_full(IN aknr VARCHAR) RETURNS VARCHAR AS $$
   SELECT tartikel.art__ak_nr__index__GetIndexStringFull(aknr);
   $$ LANGUAGE sql;

-- allg. Funktion, die das xte Vorkommen der Zeichen zwischen einem Trennzeichen  zurückgibt.
-- ZB Index1 bzw. Index2 für ' bla ''Index1'' bla ''Index2'' bla ' mit TrennZ '
CREATE OR REPLACE FUNCTION getStr_btwDelim_byPos(IN inStr VARCHAR, IN delim VARCHAR, IN pos INTEGER) RETURNS VARCHAR AS $$
  BEGIN
   RETURN split_part(inStr, delim, pos * 2); -- Abbildung eindeutig, da zwischen 2 direkten delims Leerstrings kommen
  END $$ LANGUAGE plpgsql STABLE;
--

-- ermittelt den letzten passende Artikel zu einer Artikelnummer
CREATE OR REPLACE FUNCTION tartikel.art__ak_nr__index__max( _ak_nr varchar ) RETURNS varchar AS $$
DECLARE ar varchar;
BEGIN
 IF _ak_nr NOT LIKE '%' || tsystem.settings__get( 'akindex' ) || '%' THEN
    RETURN _ak_nr;
 ELSE
    RETURN ak_nr FROM art WHERE ak_nr LIKE tartikel.art__ak_nr__index( _ak_nr ) ORDER BY ak_nr DESC LIMIT 1;
 END IF;
END $$ LANGUAGE plpgsql STABLE;
--

CREATE OR REPLACE FUNCTION TArtikel.art__ak_ersatzaknr__by__ak_nr__getlist(aknr VARCHAR, stackdepth INTEGER DEFAULT 0) RETURNS SETOF VARCHAR AS $$
    DECLARE result VARCHAR;
                 r RECORD;
    BEGIN
     If stackdepth>99 THEN
        RETURN;
     END IF;
     result:=ak_ersatzaknr FROM art WHERE ak_nr=aknr;
     IF result IS NOT NULL OR stackdepth>0 THEN --wenn ebene 0 und ersatzartikel da, oder eben wir ein unter-ersatzartikel sind, der aber selbst keinen ersatzartikel mehr hat
        RETURN NEXT aknr;
     END IF;
     IF result IS NOT NULL THEN
        FOR r IN SELECT * FROM TArtikel.art__ak_ersatzaknr__by__ak_nr__getlist(result, stackdepth+1) LOOP
                RETURN NEXT r.art__ak_ersatzaknr__by__ak_nr__getlist;
        END LOOP;
     END IF;
     RETURN;
    END $$ LANGUAGE plpgsql STABLE;
--

--
CREATE OR REPLACE FUNCTION TArtikel.LosFaktor(
      menge         NUMERIC,
      los           NUMERIC,
      limit_menge   BOOLEAN = false
  ) RETURNS NUMERIC AS $$
  BEGIN
      -- Faktor für das Los bestimmen, um mindestens die Menge zu erreichen.
        -- Option limit_menge: Menge nicht überschreiten, sonst Menge mind. einhalten (ggf. 1 Los mehr).

      RETURN
        div(menge, los) +
        -- Menge nicht überschreiten
        CASE WHEN limit_menge THEN
            0
        -- Menge einhalten (überschreiten möglich)
        ELSE
            sign (menge % los)  -- sign: Rest negativ => -1; Rest = 0 => 0; Rest positiv => 1
                                -- D.h. bei Rest wird 1 Los mehr genommen.
        END
      ;
  END $$ LANGUAGE plpgsql IMMUTABLE STRICT;
--

--
CREATE OR REPLACE FUNCTION TArtikel.art__ak_los__qty_round(
      aknr          VARCHAR,
      menge         NUMERIC,
      limit_menge   BOOLEAN = false
  ) RETURNS NUMERIC AS $$
  DECLARE
      aklos NUMERIC;
  BEGIN
      -- Menge für Artikel runden auf Artikel-Los.
        -- aka RoundToAkLos
        -- Option limit_menge: Menge nicht überschreiten, sonst Menge mind. einhalten (ggf. 1 Los mehr).

      -- Artikel-Los
      aklos := ak_los FROM art WHERE ak_nr = aknr;

      RETURN TWawi.Round_ToLos(aklos, menge, limit_menge);
  END $$ LANGUAGE plpgsql STABLE;
--

-- abwärtskompatibel zur alten Funktion
CREATE OR REPLACE FUNCTION Z_99_Deprecated.RoundToAkLos(aknr VARCHAR, menge NUMERIC) RETURNS NUMERIC AS $$
    SELECT TArtikel.art__ak_los__qty_round(aknr, menge);
  $$ LANGUAGE sql STABLE;
--

--
CREATE OR REPLACE FUNCTION TArtikel.art__lagerbestand__max(aknr VARCHAR) RETURNS NUMERIC AS $$
  DECLARE
      art_rec RECORD;
  BEGIN
      -- maximal möglicher Lagerbestand für Artikel
      -- aktuell wird der max. Lagerbestand global per Artikel-Sollmenge (ak_soll per Option ak_soll_is_max) bestimmt.
      -- Erweiterung möglich für (mehrere) Lagerkonfigurationen des Artikels (lagartikelkonf)

      SELECT
        ak_soll,
        ak_soll_is_max  -- vgl. #13214
      INTO art_rec
      FROM art
      WHERE ak_nr = aknr;

      IF art_rec.ak_soll_is_max THEN
          -- Maximalbestand ausgeben.
          RETURN art_rec.ak_soll;

      ELSE
          -- oder NULL, wenn nicht gesetzt.
          RETURN NULL;
      END IF;
  END $$ LANGUAGE plpgsql STABLE STRICT;
--

--
CREATE OR REPLACE FUNCTION TArtikel.art__ak_los__lagerbestand_max__qty_round(
      aknr    VARCHAR,
      menge   NUMERIC,
      los     NUMERIC = NULL
  ) RETURNS NUMERIC AS $$
  DECLARE
      art__lagerbestand__max  NUMERIC;
      aklos                   NUMERIC;
      result                  NUMERIC;
  BEGIN
      -- Menge für Artikel runden auf eingegebenes Los oder per Artikel-Los
      -- mit Berücksichtigung vom ggf. maximal möglichen Lagerbestand.

      -- Maximal möglichen Lagerbestand holen.
        -- Max. mgl. Lagerbestand für Artikel ist NULL, wenn nicht gesetzt, siehe TArtikel.art__lagerbestand__max.
      art__lagerbestand__max := TArtikel.art__lagerbestand__max(aknr);

      -- Höchstens max. Lagerbestand ausgeben.
      menge := least(menge, art__lagerbestand__max);

      -- eingegebenes Los oder Artikel-Los berücksichtigen
      los :=
        COALESCE(
          los,
          (SELECT ak_los FROM art WHERE ak_nr = aknr)
        );

      -- Losrundung mit Berücksichtigung vom max. mgl. Lagerbestand.
      result := TWawi.Round_ToLos(los, menge);

      -- Bei max. Lagerbestand darf Menge durch Losrundung nicht überschritten werden.
      -- Ohne max. Lagerbestand kann Menge mind. eingehalten werden (ggf. 1 Los mehr).
      IF result > art__lagerbestand__max THEN
          result := TWawi.Round_ToLos(los, menge, true);
      END IF;

      RETURN result;
  END $$ LANGUAGE plpgsql STABLE;
--

-- letzten CAD-Status bzw. CAD-Dokument-Status aus artlog holen, ohne Angabe der category werden alle Kategorien (Dokumente, Status) geholt.
CREATE OR REPLACE FUNCTION TArtikel.Get_CAD_Status(IN in_aknr VARCHAR, INOUT category VARCHAR DEFAULT NULL, OUT event_time TIMESTAMP(0), OUT event_user VARCHAR, OUT event_old VARCHAR, OUT event_new VARCHAR, OUT plain_text VARCHAR) RETURNS SETOF RECORD AS $$
  DECLARE log_rec RECORD;
          event_plain_text VARCHAR;
  BEGIN
    FOR log_rec IN SELECT akl_time, to_char(akl_time, 'DD.MM.YY HH24:MI') AS formated_time, insert_by, akl_category, akl_cad_event_old, akl_cad_event_new FROM artlog
        WHERE akl_id IN (-- Dokumenteinträge
                         SELECT max(akl_id) FROM artlog
                         WHERE akl_aknr = in_aknr
                           AND akl_category ~ 'P[0-9][0-9]\\..+' -- Dokumenttypen
                           AND akl_category LIKE COALESCE(category, akl_category)
                           AND COALESCE(akl_cad_event_new, '') <> ''
                         GROUP BY akl_category -- letzter Event des Dokuments
                         -- CAD-Statuseinträge
                         UNION
                         SELECT max(akl_id) FROM artlog
                         WHERE akl_aknr = in_aknr
                           AND akl_category = 'art.status.cad'
                           AND akl_category LIKE COALESCE(category, akl_category)
                           AND (COALESCE(akl_cad_event_old, '') <> '' OR COALESCE(akl_cad_event_new, '') <> '')
                         -- Für jedes CAD-Ereignis muss letzter Log-Eintrag geholt werden. Besonderheit Checked In, Cleared bei new = '' und old = 'O' s.u.
                         GROUP BY akl_cad_event_new, COALESCE(akl_cad_event_new, '') = '' AND COALESCE(akl_cad_event_old, '') = 'O'
                        )
        ORDER BY akl_category, akl_cad_event_new, akl_cad_event_old
    LOOP
        category:=      log_rec.akl_category;
        event_time:=    log_rec.akl_time;
        event_user:=    log_rec.insert_by;
        event_old:=     COALESCE(log_rec.akl_cad_event_old, '');
        event_new:=     COALESCE(log_rec.akl_cad_event_new, '');

        -- Ausformulierung
        IF category = 'art.status.cad' THEN
            IF event_old = 'O' AND event_new = '' THEN
                event_plain_text:= lang_text(16569); -- Eingecheckt (Checked In)
            ELSIF event_old <> 'O' AND event_new = '' THEN
                event_plain_text:= lang_text(16570); -- Status entfernt (Cleared)
            ELSE
                event_plain_text:= COALESCE((SELECT rege_bez FROM RecnoEnums WHERE rege_reg_pname = 'art.status.cad' AND rege_code = event_new), event_new);
            END IF;
        ELSIF category ~ 'P[0-9][0-9]\\..+' THEN
            event_plain_text:= COALESCE((SELECT rege_bez FROM RecnoEnums WHERE rege_reg_pname = 'dms.status.cad' AND rege_code = event_new), event_new);
        ELSE
            event_plain_text:= lang_text(970); -- unbekannt
        END IF;

        plain_text:= event_plain_text || ' ' || lang_text(16568) || ' ' || log_rec.formated_time || ' ' || lang_text(981) || ' ' || COALESCE(nameAufloesen(event_user), lang_text(970));
        -- Freigegeben (Approved) am 28.09.16 20:10 von Dominik Gehlich

        RETURN NEXT;
    END LOOP;
  END $$ LANGUAGE plpgsql STABLE;

--- #9993 Rohmaterial-Artikelnummerngenerator
--- https://redmine.prodat-sql.de/issues/16328 Überarbeitung bzgl. Sonderzeichen

CREATE OR REPLACE FUNCTION tartikel.rohmaterial__ak_nr__generate(
    _materialnr            varchar DEFAULT null::varchar,
    _behandlungszust       varchar DEFAULT null::varchar,
    _geometrie             varchar DEFAULT null::varchar,
    _durchmesser           numeric DEFAULT null::numeric,
    _hoehe                 numeric DEFAULT null::numeric,
    _breite                numeric DEFAULT null::numeric,
    _laenge                numeric DEFAULT null::numeric,
    _zusatztxt             varchar DEFAULT null::varchar,
    _toleranzangabe        varchar DEFAULT null::varchar,
    _maxlength             integer DEFAULT 40,
    _anzkommastellen       integer DEFAULT null::integer
  ) RETURNS varchar AS $$
 DECLARE
    result           varchar;
    _to_char_format  varchar := '9999999990';
    _str_durchmesser varchar;
    _str_hoehe       varchar;
    _str_breite      varchar;
    _str_laenge      varchar;
    _str_null        varchar;
  BEGIN
    --Aufbereitung der Dezimalstellen für "Freie Eingabe" bzw. Nachkommastellen
    IF ( _anzKommastellen IS NOT null ) THEN
        IF ( _anzKommastellen >= 0 ) THEN
            _to_char_format := _to_char_format || 'D';
            FOR i IN 0.._anzKommastellen - 1 LOOP
                -- Nachkomastellen an das Format anbauen
                _to_char_format := _to_char_format || '9';
            END LOOP;
        END IF;

        _str_null        := trim( to_char( 0, _to_char_format ));
        _str_durchmesser := nullif( trim( to_char( _durchmesser, _to_char_format )), _str_null );
        _str_hoehe       := nullif( trim( to_char( _hoehe, _to_char_format )), _str_null );
        _str_breite      := nullif( trim( to_char( _breite, _to_char_format )), _str_null );
        _str_laenge      := nullif( trim( to_char( _laenge, _to_char_format )), _str_null );
    ELSE
        _str_durchmesser := ifthen( _durchmesser <> 0, _durchmesser :: varchar, null );
        _str_hoehe       := ifthen( _hoehe <> 0, _hoehe :: varchar, null );
        _str_breite      := ifthen( _breite <> 0, _breite :: varchar, null );
        _str_laenge      := ifthen( _laenge <> 0, _laenge :: varchar, null );
    END IF;

    -- Material
    result := trim( _materialnr );

    -- Behandlungszustand
    IF ( _behandlungszust IS NOT null ) AND ( char_length( trim( _behandlungszust )) > 0 ) THEN
        --z.B.: +A = Wärmebehandelt
        result := trim( result || ' +' || _behandlungszust );
    END IF;

    -- Durchmesser gibt es zweimal (einmal in der Geometrie, das zweite mal als Feld), je nach auswahl darf 'Ø' nur einmal erscheinen
    IF ( _durchmesser <> 0 ) AND ( _durchmesser IS NOT null ) THEN
        IF ( _geometrie IS null ) OR ( position( 'Ø' IN _geometrie ) = 0 ) THEN
            _geometrie := coalesce( _geometrie, '' ) || 'Ø';
        END IF;
    END IF;

    -- Geometrie
    result := result || ' ' || coalesce( _geometrie, '' );

    -- Durchmesser
    IF  ( _durchmesser <> 0 ) AND ( _durchmesser IS NOT null ) THEN
        result := trim( result || _str_durchmesser );
    END IF;

    -- Höhe/Breite/Länge
    IF ( _hoehe <> 0 ) AND ( _hoehe IS NOT null ) THEN
        result := trim( result || ifthen( _str_durchmesser IS null, '', ifthen( _str_hoehe IS null, '', 'X' ) ) || _str_hoehe );
    END IF;
    IF ( _breite <> 0 ) AND ( _breite IS NOT null ) THEN
        result := trim( result || ifthen(( coalesce( _str_durchmesser, _str_hoehe ) IS null ), '', 'X' ) || _str_breite );
    END IF;
    IF ( _laenge <> 0 ) AND ( _laenge IS NOT null ) THEN
        result := trim( result || ifthen(( coalesce( _str_durchmesser, _str_hoehe, _str_breite ) IS null ), '', 'X' ) || _str_laenge );
    END IF;

    -- #22095 Toleranzangabe
    IF ( _toleranzangabe IS NOT null ) AND ( char_length( trim( _toleranzangabe )) > 0 ) THEN
        result := trim( result || ' +' || _toleranzangabe );
    END IF;

    -- Ausführung/Oberfläche, sonstiges
    IF ( _zusatztxt IS NOT null ) AND ( char_length( trim( _zusatztxt )) > 0 ) THEN
        --z.B.: +SL = geschliffen
        result := trim( result || ' +' || _zusatztxt );
    END IF;

    -- auf Maximallenge zurecht stutzen
    IF _maxlength = 40 AND char_length( trim( result ) ) > 40 THEN
        PERFORM PRODAT_MESSAGE(lang_text(29996), 'Information'); -- #10822
    END IF;
    result := substring( trim( result ), 1, _maxlength );

    RETURN result;
 END $$ LANGUAGE plpgsql STABLE;


--- #22219
CREATE OR REPLACE FUNCTION tartikel.rohmaterial__ak_bez__generate(
      IN _materialnr      varchar DEFAULT null::varchar,   --- Material
      IN _behandlungszust varchar DEFAULT null::varchar,   --- Behandlungszustand
      IN _geometrie       varchar DEFAULT null::varchar,   --- Geometrie
      IN _durchmesser     numeric DEFAULT null::numeric,   --- Durchmesser
      IN _hoehe           numeric DEFAULT null::numeric,   --- Höhe
      IN _breite          numeric DEFAULT null::numeric,   --- Breite
      IN _laenge          numeric DEFAULT null::numeric,   --- Länge
      IN _zusatztxt       varchar DEFAULT null::varchar,   --- ist nicht in der Bezeichnung
      IN _toleranzangabe  varchar DEFAULT null::varchar,   --- ist nicht in der Bezeichnung
      IN _maxlength       integer DEFAULT 100
  ) RETURNS varchar AS $$
 DECLARE
       result                    varchar = '';
     _geometrie_Bez            varchar = '';
     _materialnr_Bez           varchar = '';
     _dimension_Bez            varchar = '';
     _behandlungszust_Bez      varchar = '';
   _zusatztxt_Bez            varchar = '';
     _concat_varchar           varchar = ' ';   --- Zwischenzeichen
  BEGIN

    --- Geometrie
    IF ( char_length( trim( coalesce( _geometrie, '' ) ) ) > 0 ) THEN
        SELECT upper( r_dim ) INTO _geometrie_Bez FROM art_rdim WHERE upper( r_krz ) = upper( _geometrie );
    END IF;

    --- Material
    IF ( char_length( trim( coalesce( _materialnr, '' ) ) ) > 0 ) THEN
        SELECT upper( r_bez ) INTO _materialnr_Bez FROM art_rmatbez WHERE upper( r_krz ) = upper( _materialnr );
    END IF;

    --- Dimension
    IF char_length( trim( coalesce( ( _durchmesser || _hoehe || _breite || _laenge ) , '' ) ) ) > 0
      AND NOT TSystem.Equals( ( _durchmesser || _hoehe || _breite || _laenge ), '0000') THEN
        SELECT concat_ws( 'x', 'Ø' ||
                 IfThen(TSystem.Equals( _durchmesser, '0'), null, _durchmesser),
                 IfThen(TSystem.Equals( _hoehe      , '0'), null, _hoehe      ),
                 IfThen(TSystem.Equals( _breite     , '0'), null, _breite     ),
                 IfThen(TSystem.Equals( _laenge     , '0'), null, _laenge     )
             ) || ' mm'
        INTO _dimension_Bez;
    END IF;

    --- Zustand
    IF ( char_length( trim( coalesce( _behandlungszust, '' ) ) ) > 0 ) THEN
        --- Behandlungszustand
        SELECT upper( r_krz ) INTO _behandlungszust_Bez FROM art_rbehandl WHERE upper( r_zustand ) = upper( _behandlungszust);
    END IF;
    --- Ausführung
    IF ( char_length( trim( coalesce( _zusatztxt, '' ) ) ) > 0 ) THEN
        --- Ausführung
        SELECT upper( r_krz ) INTO _zusatztxt_Bez FROM art_roberfl WHERE upper( r_oberfl ) = upper( _zusatztxt );
    END IF;

 --raise notice '_geometrie_Bez = "%", _materialnr_Bez = "%", _dimension_Bez = "%", _behandlungszust_Bez = "%"', _geometrie_Bez, _materialnr_Bez, _dimension_Bez, _behandlungszust_Bez;

      -- auf Maximallenge zurecht stutzen
    IF _maxlength = 100 AND char_length( trim( result ) ) > 100 THEN
        PERFORM PRODAT_MESSAGE( format( lang_text(29996), 'Artikelbezeichnung', '100' ), 'Information'); -- #10822
    END IF;

    result := substring( concat_ws( _concat_varchar, _geometrie_Bez, _materialnr_Bez, _dimension_Bez, _behandlungszust_Bez, _zusatztxt_Bez ), 1, _maxlength) ;

    RETURN result;
 END $$ LANGUAGE plpgsql STABLE;
---

CREATE OR REPLACE FUNCTION tartikel.art__artikel__pruefmittel__is( _pm_part varchar )
RETURNS boolean AS $$

  SELECT EXISTS (
      SELECT 1 FROM art
      JOIN artcod ON ac_n = ak_ac AND ac_i = 25
      WHERE _pm_part = ak_nr
  )

$$ LANGUAGE sql IMMUTABLE;


CREATE OR REPLACE FUNCTION tartikel.oplpm_data__pm_part__pruefmittel__ersetzen(
    _pm_id integer,
    _pm_part__alt varchar,
    _pm_part__neu varchar
) RETURNS void AS $$
  DECLARE
      _pm_part__ist varchar;
      _pm_part__soll varchar;
  BEGIN

  -- #16627 ersetzt im Messprotokoll das Prüfmittel durch ein anderes

      IF NOT tartikel.art__artikel__pruefmittel__is( _pm_part__neu ) THEN
          RETURN;
      END IF;

      -- #17608 gibt es bereits Messwerte zu diesem Prüfung, dann gibt es hier nichts zu tun,
      --   Prüfmittel dürfen nicht ersetzt werden, wenn bereits Messwerte dazu erfasst wurden
      IF EXISTS( SELECT 1 FROM oplpm_mw WHERE mw_pm_id = _pm_id AND mw_messwert IS NOT null ) THEN
          RETURN;
      END IF;

      -- zwei Abkürzungen
      _pm_part__ist := pm_part FROM oplpm_data WHERE pm_id = _pm_id;
      _pm_part__soll := _pm_part__ist;

      IF _pm_part__ist = _pm_part__alt THEN
          _pm_part__soll :=  _pm_part__neu;
      END IF;

      IF _pm_part__soll <> _pm_part__ist THEN

          -- Prüfmittel ersetzen, in Protokoll ersetzen
          UPDATE oplpm_data
          SET pm_part = _pm_part__soll
          WHERE pm_id = _pm_id;

          -- Messdatensätze ohne Messungen, bei denen noch eine
          -- Inventarnummer des alten Prüfmittels gesetzt ist,
          -- bekommen ihre Inventarnummer gelöscht
          UPDATE oplpm_mw
          SET mw_pr_pmnr = null
          WHERE
                  mw_pm_id = _pm_id
              AND mw_messwert IS null
              AND EXISTS(
                  SELECT 1 FROM artpr
                  WHERE
                          pr_pmnr = mw_pr_pmnr
                      AND pr_aknr = _pm_part__alt
              );
      END IF;

  END $$ LANGUAGE plpgsql;


CREATE OR REPLACE FUNCTION tartikel.oplpm_data__pm_part__pruefmittel__ersetzen__abk(
    _ab_ix integer,
    _pm_part__alt varchar,
    _pm_part__neu varchar
) RETURNS void AS $$
  BEGIN

  -- #16628 ersetzt in allen zu einer ABK gehörenden Messprotokollen das Prüfmittel durch ein anderes

      PERFORM tartikel.oplpm_data__pm_part__pruefmittel__ersetzen( pm_id, _pm_part__alt, _pm_part__neu )
      FROM oplpm_data
      JOIN ab2 ON a2_id = pm_a2_id AND a2_ab_ix = _ab_ix;

  END $$ LANGUAGE plpgsql;


CREATE OR REPLACE FUNCTION tartikel.oplpm_data__pm_part__pruefmittel__ersetzen__ask(
    _op_ix integer,
    _pm_part__alt varchar,
    _pm_part__neu varchar,
    _mit_abks boolean DEFAULT true
) RETURNS void AS $$
  BEGIN

  -- #16629 ersetzt in allen zu einer AVOR-Stammkarte gehörenden Messprotokollen das Prüfmittel durch ein anderes

      PERFORM tartikel.oplpm_data__pm_part__pruefmittel__ersetzen( pm_id, _pm_part__alt, _pm_part__neu )
      FROM oplpm_data
      JOIN op2 ON pm_op2_id = o2_id
      WHERE
              o2_ix = _op_ix
          AND ( _mit_abks OR pm_a2_id IS null );

  END $$ LANGUAGE plpgsql;


CREATE OR REPLACE FUNCTION tartikel.oplpm_data__pm_part__pruefmittel__ersetzen__alle(
    _pm_part__alt varchar,
    _pm_part__neu varchar
) RETURNS void AS $$
  BEGIN

  -- #16629 ersetzt in allen Messprotokollen das Prüfmittel durch ein anderes

      PERFORM tartikel.oplpm_data__pm_part__pruefmittel__ersetzen( pm_id, _pm_part__alt, _pm_part__neu )
      FROM oplpm_data
      WHERE _pm_part__alt = pm_part;

  END $$ LANGUAGE plpgsql;


CREATE OR REPLACE FUNCTION tartikel.artpr__pruefmittel__einsatzbereit__is(
    _pr_id integer
) RETURNS boolean AS $$

  -- #16625 Ist Prüfmittel bereits inbetrieb genommen und noch nicht aussortiert?

       SELECT EXISTS (
        SELECT 1 FROM artpr
        WHERE
                ( -- Berücksichtigung Datum der Inbetriebnahme
                    pr_ibda IS null
                    OR pr_ibda <= CURRENT_DATE
                )
            AND ( -- Berücksichtigung Datum der Aussonderung
                    pr_lqda IS null
                    OR pr_lqda >= CURRENT_DATE
                    OR pr_ifreig
                )
            AND pr_id = _pr_id
        )

  $$ LANGUAGE sql STABLE;

--
--https://redmine.prodat-sql.de/issues/9135
CREATE OR REPLACE FUNCTION TArtikel.art_has_beistellung_lieferant(aknr VARCHAR) RETURNS BOOLEAN
  AS $$

  SELECT EXISTS( SELECT TRUE FROM stv                                         WHERE st_zn = aknr AND TSystem.ENUM_GetValue(st_stat, 'BL') )OR
         EXISTS( SELECT TRUE FROM op6 JOIN opl ON op_ix=o6_ix AND op_standard WHERE op_n  = aknr AND TSystem.ENUM_GetValue(o6_stat, 'BL') );
  $$ LANGUAGE sql STABLE STRICT;


 --
 CREATE OR REPLACE FUNCTION TArtikel.ain_hest_herkunft__set(
     IN _aknr  varchar,
     IN _table  varchar DEFAULT null,
     IN _param  varchar DEFAULT null
     )
     RETURNS void
     AS $$
     DECLARE sHest       varchar;
             _e_best     varchar;
             _e_herkunft varchar;
     BEGIN
       -- Ohne Parameter um "Freie Eingabe" bei default einlegen (wird in trigger benutzt)
       IF _param IS null THEN
          -- freie Eingabe
          sHest := lang_text(10278);
       ELSE
          -- Herkunft Zuweisung (jetzt immer update)
          IF _table = 'opl' THEN
             sHest := 'ASK';
          ELSIF _table = 'erg' THEN
             sHest := 'ERG';
          ELSIF _table = 'nka' THEN
             sHest := 'NKA';
          ELSIF _table = 'epreis' THEN
             -- Herkunft aus Lieferantenpreisen -> Fallunterscheidung notwendig
             SELECT  e_best,  e_herkunft
               INTO _e_best, _e_herkunft
               FROM epreis
              WHERE dbrid = _param;
             -- Falls Herkunft Nachkalkulation
             IF coalesce( _e_herkunft, _e_best ) LIKE 'ABK-%' THEN
                sHest := 'NKA';
                _param := REPLACE( coalesce( _e_herkunft, _e_best ), 'ABK-', '' ); -- ABK
             -- Falls Herkunft Eingangsrechnung
             ELSIF _e_herkunft LIKE lang_text( 13789 ) || ' %' THEN -- E.-RG.
                sHest := 'ERG';
                _param := REPLACE(_e_herkunft, lang_text( 13789 ) || ' ', '' ); -- Rechnungsnummer
             -- Falls Herkunft Lieferantenanfrage/-angebot
             ELSIF _e_herkunft LIKE lang_text( 13831 ) || ' %' THEN -- Anf.Nr.
                sHest := 'ANF';
                _param := REPLACE(_e_herkunft, lang_text( 13831 ) || ' ', '' ); -- Anfrage-/Angebotsnummer
             -- Sonst Lieferant
             ELSE
                sHest := 'LIEF';
                _param := (SELECT e_lkn FROM epreis WHERE dbrid = _param); -- Lieferantenkürzel
             END IF;
          ELSE
             sHest := _table;
          END IF;
       END IF;

       -- Datensatz erstellen. Wenn bereits vorhanden, Update. Herkunft = "Freie Eingabe"  oder "richtige Herkunft : Parameter" => NKA: 4711
       INSERT INTO artinfo
                   (ain_ak_nr, ain_hest_datum, ain_hest_user, ain_hest_herkunft)
            VALUES (_aknr, current_date, current_user, sHest)
       ON CONFLICT (ain_ak_nr)
       DO
        UPDATE SET ain_hest_datum    = current_date,
                   ain_hest_user     = current_user,
                   ain_hest_herkunft = sHest || coalesce(': ' || _param, '')
       ;
     END $$ LANGUAGE plpgsql;


-- https://redmine.prodat-sql.de/issues/19552
CREATE OR REPLACE FUNCTION TArtikel.art__auftg__get_lieferbar_menge_termin__by_agid(
    IN _ag_id INTEGER
    )
    RETURNS TABLE (
    -- gemäß Bedarfsberechnung: maximal lieferbare Menge zum Liefertermin des Auftrages ohne dass Folgeaufträge nicht mehr lieferbar sind
    menge__b_nbestand__max__by_bedarf            numeric,
    -- gemäß Bedarfsberechnung: frühestmöglicher Liefertermin des Auftrages ohne dass andere Aufträge nicht mehr lieferbar sind
    date__b_termin__min__by_bedarf               date,
    -- Formatierung für unterschiedliche Status
    menge__b_nbestand__max__by_bedarf_cimgreen   boolean,
    menge__b_nbestand__max__by_bedarf_cimyellow  boolean,
    menge__b_nbestand__max__by_bedarf_cimred     boolean,
    date__b_termin__min__by_bedarf_cimgreen      boolean,
    date__b_termin__min__by_bedarf_cimyellow     boolean,
    date__b_termin__min__by_bedarf_cimred        boolean
    )
    AS $$

  DECLARE
    _ak_nr                 varchar;
    _agid_b_date           date;
    _agid_b_bestand        numeric;
    _agid_b_nbestand       numeric;
    _agid_b_zuab           numeric;
    _agid_b_id             integer;
    _folge_b_id            integer;
    _folge_b_nbestand      numeric;
    _folge_b_date          date;
    _vorgaenger_b_id       integer;
    _vorgaenger_b_nbestand numeric;
    _vorgaenger_b_date     date;
    _ak_verfueg            numeric;
    _status                integer;
  BEGIN

    -- Artikelnummer aus Auftrags holen
    SELECT ag_aknr    INTO _ak_nr      FROM auftg WHERE ag_id = _ag_id;


    -- Verfügbarkeit zur Auftragsposition
    SELECT ak_verfueg INTO _ak_verfueg FROM art   WHERE ak_nr = _ak_nr;

    -- Bedarfsberechnung zur Auftrags-ID
    SELECT       b_date,       b_bestand,       b_nbestand,       b_zuab,       b_id
      INTO _agid_b_date, _agid_b_bestand, _agid_b_nbestand, _agid_b_zuab, _agid_b_id
      FROM bedarf
    WHERE b_ag_id = _ag_id;

    -- der Auftrags-ID nachgelagerter minimaler Terminbestand
    SELECT        b_date,        b_nbestand,        b_id
      INTO _folge_b_date, _folge_b_nbestand, _folge_b_id
      FROM bedarf
    WHERE b_id > _agid_b_id
      AND b_aknr = _ak_nr
    ORDER BY b_nbestand ASC
    LIMIT 1;

    -- Status ermitteln
    SELECT CASE WHEN _agid_b_nbestand >= 0 and coalesce( _folge_b_nbestand, _agid_b_nbestand ) >= 0 THEN 1
                WHEN _agid_b_nbestand <  0 and _ak_verfueg >= 0                                     THEN 2
                WHEN _agid_b_nbestand >= 0 and _folge_b_nbestand < 0                                THEN 3
                WHEN _agid_b_nbestand <  0 and _ak_verfueg < 0                                      THEN 4
          END INTO _status;

    -- Maximal lieferbare Menge zum Auftragstermin ist
    -- Auftragsmenge + Mininum vom Terminbestand der Bedarfsberechnung aller nachgelagerten Vorgänge und aktuellem Terminbestand
    menge__b_nbestand__max__by_bedarf  := -_agid_b_zuab + LEAST(coalesce(_folge_b_nbestand, _agid_b_nbestand), _agid_b_nbestand);

    -- Ermittlung des frühestmöglichen Termins je nach Status
    IF _status = 1 THEN
      -- Status 1: Bedarfsberechnung zur Auftrags-ID >=0 und alle nachfolgenden Bedarfsverursacher >=0

      -- frühestmöglicher Termin
      -- Eintrag in Bedarfsberechnung vor dem aktullen Termin finden nach dem der Terminbestand immer >=0 ist
      WITH bedarfe AS(
        SELECT min(b_nbestand) OVER (PARTITION BY b_aknr ORDER BY b_id DESC) as min_nbestand_nachfolgend,
              *
          FROM bedarf
        WHERE b_id < _agid_b_id
          AND b_aknr = _ak_nr
        ORDER BY b_id ASC
        )
      SELECT             b_date, min_nbestand_nachfolgend,             b_id
        INTO _vorgaenger_b_date,   _vorgaenger_b_nbestand, _vorgaenger_b_id
        FROM bedarfe
      WHERE min_nbestand_nachfolgend + _agid_b_zuab >= 0
      ORDER BY bedarfe.b_id ASC
      LIMIT 1;

      date__b_termin__min__by_bedarf := coalesce( _vorgaenger_b_date, _agid_b_date);

    ELSIF _status = 2 or _status = 3 THEN
      -- Status 2: Bedarfsberechnung zur Auftrags-ID < 0 ABER Verfügbarkeit > 0
      -- Status 3: Bedarfsberechnung zur Auftrags-ID >=0 ABER es existieren nachfolgende Bedarfsverursacher <0

      -- frühestmöglicher Termin
      -- Eintrag in Bedarfsberechnung nach dem aktuellen Termin finden nach dem der Terminbestand immer >=0 ist
      WITH bedarfe AS(
        SELECT min(b_nbestand) OVER (PARTITION BY b_aknr ORDER BY b_id DESC) as min_nbestand_nachfolgend,
              *
          FROM bedarf
        WHERE b_id > _agid_b_id
          AND b_aknr = _ak_nr
        ORDER BY b_id ASC
        )
      SELECT        b_date, min_nbestand_nachfolgend, b_id
        INTO _folge_b_date, _folge_b_nbestand, _folge_b_id
        FROM bedarfe
      WHERE min_nbestand_nachfolgend >= 0
      ORDER BY bedarfe.b_id ASC
      LIMIT 1;

      date__b_termin__min__by_bedarf := coalesce( _folge_b_date, _agid_b_date);

    ELSIF _status = 4 THEN
      -- Status 4: Bedarfsberechnung zur Auftrags-ID <0 und Verfügbarkeit <0

      -- frühestmöglicher Termin
      -- ergibt sich aus aktueller Wiederbeschaffungszeit inkl. Puffer (14 Tage)
      date__b_termin__min__by_bedarf := (SELECT now() + make_interval(days => ak_bfr + 14) FROM art WHERE ak_nr = _ak_nr);

    END IF;

    -- Formatierte Ausgabe von Menge und Termin
    RETURN QUERY
    SELECT menge__b_nbestand__max__by_bedarf,
           date__b_termin__min__by_bedarf,
           _status = 1                 AS menge__b_nbestand__max__by_bedarf_cimgreen,
           _status = 2 or _status = 3  AS menge__b_nbestand__max__by_bedarf_cimyellow,
           _status = 4                 AS menge__b_nbestand__max__by_bedarf_cimred,
           _status = 1                 AS date__b_termin__min__by_bedarf_cimgreen,
           _status = 2 or _status = 3  AS date__b_termin__min__by_bedarf_cimyellow,
           _status = 4                 AS date__b_termin__min__by_bedarf_cimred;

  END $$ LANGUAGE plpgsql STABLE;

---
CREATE OR REPLACE FUNCTION werkzeug_link__b_ud__abk()
    RETURNS TRIGGER
    AS $$
  DECLARE
    esl_id    integer;
    abk       integer;
    ag_ab_ix  integer;
    ag        integer;
    ag_wzl_id integer;
  BEGIN
    -- Thema #20025, ESL (Electronic-Shelf-Label)
    -- Trigger der bei Änderung bzw. Löschen einer ESL-ABK-Verknüpfung auch den zugehörigen AG löscht
    SELECT
      link_ab2.wzl_pkey, -- Arbeitsgang-ID (a2_id)
      ab2.a2_ab_ix,      -- ABK (ab_ix)
      link_ab2.wzl_id
    INTO
      ag,
      ag_ab_ix,
      ag_wzl_id
    FROM werkzeug_link
    LEFT JOIN werkzeug_link AS link_ab2
           ON link_ab2.wzl_wz_id = werkzeug_link.wzl_wz_id
          AND link_ab2.wzl_table = 'ab2'::regclass -- aktuellen AG vom ESL anhängen
    LEFT JOIN ab2 ON link_ab2.wzl_pkey = ab2.a2_id
    WHERE werkzeug_link.wzl_id = old.wzl_id;

    IF TG_OP = 'UPDATE' THEN
      IF ag IS NOT null AND coalesce( ag_ab_ix != new.wzl_pkey, true ) THEN
        DELETE FROM werkzeug_link
              WHERE werkzeug_link.wzl_id = ag_wzl_id;
      END IF;
      RETURN new;
    END IF;

    IF TG_OP = 'DELETE' THEN
      DELETE FROM werkzeug_link
            WHERE werkzeug_link.wzl_id = ag_wzl_id;
      RETURN old;
    END IF;

  END $$ LANGUAGE 'plpgsql';

CREATE TRIGGER werkzeug_link__b_ud__abk
    BEFORE DELETE OR UPDATE
    ON werkzeug_link
    FOR EACH ROW
    WHEN ( old.wzl_table::oid = 'abk'::regclass::oid )
    EXECUTE PROCEDURE werkzeug_link__b_ud__abk();
---
 ---  alle ESL-Verlinkungen zu einem ESL als Tabelle erhalten
 CREATE OR REPLACE FUNCTION TArtikel.werkzeug_link__link__get(
    IN      _esl_barcode varchar  -- ESL Barcode
    )
    RETURNS TABLE(
            esl_id       varchar,
            wzl_table    regclass,
            wzl_pkey     varchar
    )
    AS $$
    DECLARE _wz_id       integer;
            _r           record;
    BEGIN

    -- in einzelne ESL auflösen
    FOR _r IN  SELECT esl
                 FROM regexp_split_to_table(_esl_barcode, E'\r\n|,| ') esl
                WHERE esl IS NOT NULL
                  AND esl <> ''
    LOOP
      -- ID des ESLs ermitteln
      SELECT wz_id
        INTO _wz_id
        FROM werkzeug
       WHERE wz_wznr = _r.esl;

      -- bestehende Verlinkungen ausgeben
      return query SELECT _r.esl::varchar as esl_id,
                          werkzeug_link.wzl_table,
                          werkzeug_link.wzl_pkey
                     FROM werkzeug_link
                    WHERE wzl_wz_id = _wz_id;

    END LOOP;

 END $$ LANGUAGE plpgsql;

 --- #20025 ESL als werkzeug behandeln
CREATE OR REPLACE FUNCTION werkzeug_link__a_iu__lagerorte()
    RETURNS TRIGGER
    AS $$
  DECLARE
    esl_id   integer;
    lagerort varchar;
    abk      integer;
    ag       integer;
    folgeag  integer;
  BEGIN
    -- Trigger der einen zum Übergabebahnhof passenden Folgearbeitsgang findet und diesen verlinkt
    --  - Übergabebahnhof => Standardlagerort mit Kostenstellenzuordnung (lgo_ks)
    --  - passenden Folgearbeitsgang => der nächste offene Arbeitsgang bei dem:
    --                        - die Kostenstelle (lgo_ks) aus dem Übergabebahnhof hinterlegt ist und
    --                        - der zu der mit dem ESL (Electronic-Shelf-Label) verlinkten ABK gehört

    SELECT
      werkzeug_link.wzl_wz_id, -- ESL-ID (wz_id)
      werkzeug_link.wzl_pkey,  -- Lagerort (lgo_name)
      link_abk.wzl_pkey,    -- ABK (ab_ix)
      link_ab2.wzl_pkey,    -- Arbeitsgang-ID (a2_id)
      ( SELECT ab2.a2_id FROM ab2
        WHERE coalesce( arbeitsgang.a2_n, 0 ) < ab2.a2_n -- Falls noch kein AG am ESL hängt sind alle AGs mit Pos > 0 zulässig
          AND ab2.a2_ab_ix = link_abk.wzl_pkey
          AND ab2.a2_ks = lagerorte.lgo_ks
        ORDER BY ab2.a2_n ASC
        LIMIT 1
      ) AS folge_ag  -- der nächste Arbeitsgang auf der zum Lagerort gehörenden Kostenstelle in der ABK nach dem aktuellen AG
      INTO
        esl_id,
        lagerort,
        abk,
        ag,
        folgeag
      FROM werkzeug_link
      JOIN lagerorte ON lagerorte.lgo_name = werkzeug_link.wzl_pkey  -- Standardlagerort anhängen um zugeordnete Kostenstelle zu erhalten
      JOIN werkzeug_link AS link_abk
        ON link_abk.wzl_wz_id = werkzeug_link.wzl_wz_id
       AND link_abk.wzl_table = 'abk'::regclass  -- aktuelle ABK vom ESL anhängen
      LEFT JOIN werkzeug_link AS link_ab2
             ON link_ab2.wzl_wz_id = werkzeug_link.wzl_wz_id
            AND link_ab2.wzl_table = 'ab2'::regclass -- aktuellen AG vom ESL anhängen
      LEFT JOIN ab2 AS arbeitsgang ON arbeitsgang.a2_id = link_ab2.wzl_pkey
     WHERE werkzeug_link.wzl_id = new.wzl_id;

    -- Wenn ein passender FolgeAG gefunden wird, dann wird dieser mit dem ESL verlinkt (Tabelle werkzeug_link)
    IF folgeag IS NOT null THEN
      INSERT INTO werkzeug_link ( wzl_wz_id,       wzl_table, wzl_pkey )
      VALUES                    (    esl_id, 'ab2'::regclass,  folgeag )
      ON CONFLICT ( wzl_wz_id, wzl_table )
         DO UPDATE SET wzl_pkey = Excluded.wzl_pkey;  -- Wenn ESL bereits mit einem Arbeitsgang verlinkt ist, wird die bestehende Verlinkung überschrieben
    END IF;

  RETURN new;

  END $$ LANGUAGE plpgsql;

CREATE TRIGGER werkzeug_link__a_iu__lagerorte
    AFTER INSERT OR UPDATE
    ON werkzeug_link
    FOR EACH ROW
    WHEN ( new.wzl_table::oid = 'lagerorte'::regclass::oid AND new.wzl_pkey IS NOT null )
    EXECUTE PROCEDURE werkzeug_link__a_iu__lagerorte();
---

 ---  einen konkreten Wert aus ESL-Verlinkung zu einer Tabelle erhalten
 CREATE OR REPLACE FUNCTION TArtikel.werkzeug_link__link__get(
    IN _esl_barcode varchar,  -- ESL Barcode
    IN _table       regclass  -- Zieltabelle
    )
    RETURNS         varchar   -- Zieldatensatz
    AS $$
    DECLARE _pkey   varchar;
    BEGIN

    -- bestehende Verlinkung suchen (Kombinaion aus ESL und Zieltabelle ist eindeutig -> daher gibt es nur einen pkey)
    SELECT wzl_pkey
      INTO _pkey
      FROM werkzeug_link
      JOIN werkzeug ON wz_id = wzl_wz_id
     WHERE wz_wznr   = _esl_barcode
       AND wzl_table = _table
     LIMIT 1;

    -- gefundenen Wert ausgeben
    return _pkey;

 END $$ LANGUAGE plpgsql;

 --- ESL verlinken
 CREATE OR REPLACE FUNCTION TArtikel.werkzeug_link__link__set(
    IN _esl_barcode varchar,               -- ESL Barcode
    IN _table       regclass DEFAULT NULL, -- Zieltabelle
    IN _pkey        varchar  DEFAULT NULL, -- Zieldatensatz
    IN _r_id        varchar  DEFAULT NULL  -- Druckreport
    )
    RETURNS void
    AS $$
    DECLARE _wz_id integer;
            _r     record;
    BEGIN

    -- in einzelne ESL auflösen
    FOR _r IN  SELECT esl
                 FROM regexp_split_to_table(_esl_barcode, E'\r\n|,| ') esl
                WHERE esl IS NOT NULL
                  AND esl <> ''
    LOOP
      -- ID des ESLs ermitteln
      SELECT wz_id
        INTO _wz_id
        FROM werkzeug
       WHERE wz_wznr = _r.esl;

      -- Abbruch falls ESL gar nicht vorhanden
      IF _wz_id IS NULL THEN
        RAISE Exception 'Das ESL "%" existiert nicht.', _r.esl;
      END IF;

      -- Wenn zu verlinkende Tabelle + Datensatz NULL ist -> ESL entkoppeln
      IF _table IS NULL AND _pkey IS NULL THEN
        DELETE FROM werkzeug_link
         WHERE wzl_wz_id = _wz_id;
      ELSE

      -- Sonst Verlinkung hinzufügen
        INSERT INTO werkzeug_link ( wzl_wz_id, wzl_table, wzl_pkey )
               VALUES          ( _wz_id   ,_table    , _pkey    )
            -- Falls Verlinkung zu der Tabelle bereits vorhanden ist -> bestehenden Link updaten
            ON CONFLICT (wzl_wz_id, wzl_table)
            DO UPDATE SET wzl_pkey = Excluded.wzl_pkey;

        IF _r_id IS NOT NULL THEN
          -- Druckauftrag in Druckwarteschlange hinzufügen, vorher alte Aufträge löschen falls
          DELETE FROM report_print_queue WHERE rpq_table = 'werkzeug'::regclass AND rpq_pkey = _wz_id;

          INSERT INTO report_print_queue (rpq_table,         rpq_pkey, rpq_owner_form, rpq_modul_name,       rpq_r_pos)
                 VALUES                  ('werkzeug'::regclass, _wz_id,   'SELF',         'TFormESLVerwaltung', _r_id    );
      END IF;

      END IF;

    END LOOP;

 END $$ LANGUAGE plpgsql;
---
CREATE OR REPLACE FUNCTION TArtikel.werkzeug_link__next_ag__get(
    IN _esl_barcode varchar -- ESL Barcode
    )
    RETURNS integer         -- a2_id des nächsten Arbeitsgangs
    AS $$
    DECLARE _wz_id      integer; -- interne ID des ESL (Electronic-Shelf-Label)
            _abk        integer; -- ABK Index
            _a2_id      integer; -- Arbeitsgang-ID
            _next_a2_id integer; -- Arbeitsgang-ID des vorgeschlagenen Arbeitsgangs
            _lgo        varchar; -- Standardlagerort
            _ks         varchar; -- Kostenstelle
    BEGIN
    /*
     Diese Funktion ermittelt den nächsten logischen Arbeitsgang der einem ESL zugeordnet werden müsste
     Vorgehen:
       1. aktuelle Verlinkung von ABK und AG des ESL ermitteln
       2. aktuelle Verlinkung des ESL zu einem Lagerort und damit einer Kostenstelle ermitteln
       3. Folgearbeitsgang aus 1. und 2. ableiten
          Fall 1: Kostenstelle lässt sich ableiten -> nächsten offenen AG aus ABK finden der zur KS passt
          Fall 2: Kostenstelle lässt sich nicht ableiten -> nächsten offenen AG aus ABK finden
    */

    -- 1. aktuelle Verlinkung von ABK und AG des ESL ermitteln
      -- ID des ESLs ermitteln
      SELECT wz_id
        INTO _wz_id
        FROM werkzeug
       WHERE wz_wznr = _esl_barcode;

      -- Abbruch falls ESL gar nicht vorhanden
      IF _wz_id IS NULL THEN
        RAISE Exception 'Das ESL "%" existiert nicht.', _esl_barcode;
      END IF;

      -- Prüfen mit welcher ABK das ESL verlinkt ist
      SELECT wzl_pkey::integer
        INTO _abk
        FROM werkzeug_link
       WHERE wzl_wz_id = _wz_id
         AND wzl_table = 'abk'::regclass;

      -- Abbruch falls ESL gar nicht mit ABK verlinkt
      IF _abk IS NULL THEN
        RAISE Exception 'Das ESL "%" ist keiner ABK zugeordnet.', _esl_barcode;
      END IF;

      -- Prüfen mit welchem AG das ESL verlinkt ist
      SELECT wzl_pkey::integer
        INTO _a2_id
        FROM werkzeug_link
       WHERE wzl_wz_id = _wz_id
         AND wzl_table = 'ab2'::regclass;

    -- 2. aktuelle Verlinkung des ESL zu einem Lagerort und damit einer Kostenstelle ermitteln
      -- Prüfen mit welchem Standardlagerort das ESL verlinkt ist
      SELECT wzl_pkey, lgo_ks
        INTO _lgo    , _ks
        FROM werkzeug_link
        LEFT JOIN lagerorte ON wzl_pkey = lgo_name
       WHERE wzl_wz_id = _wz_id
         AND wzl_table = 'lagerorte'::regclass;

    -- 3. Folgearbeitsgang aus 1. und 2. ableiten
      -- Fall 1: Kostenstelle lässt sich ableiten -> nächsten offenen AG aus ABK finden der zur KS passt
      IF _ks IS NOT NULL THEN
        SELECT ab2.a2_id
          INTO _next_a2_id
          FROM ab2
         WHERE COALESCE( ( SELECT ab2.a2_n FROM ab2 WHERE ab2.a2_id = _a2_id ), 0) < ab2.a2_n -- Falls noch kein AG am ESL hängt sind alle AGs mit Pos > 0 zulässig
           AND ab2.a2_ab_ix = _abk
           AND ab2.a2_ks    = _ks
           AND NOT ab2.a2_ende
         ORDER BY ab2.a2_n ASC
         LIMIT 1;

      -- Fall 2: Kostenstelle lässt sich nicht ableiten -> nächsten offenen AG aus ABK finden
      ELSE
        SELECT ab2.a2_id
          INTO _next_a2_id
          FROM ab2
         WHERE COALESCE( ( SELECT ab2.a2_n FROM ab2 WHERE ab2.a2_id = _a2_id ), 0) < ab2.a2_n -- Falls noch kein AG am ESL hängt sind alle AGs mit Pos > 0 zulässig
           AND ab2.a2_ab_ix = _abk
           AND NOT ab2.a2_ende
         ORDER BY ab2.a2_n ASC
         LIMIT 1;
      END IF;

      return _next_a2_id;

 END $$ LANGUAGE plpgsql;